/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.HornetQConnectionTimedOutException;
import org.hornetq.api.core.HornetQDisconnectedException;
import org.hornetq.api.core.HornetQDuplicateMetaDataException;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQIOErrorException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.HornetQIncompatibleClientServerException;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.api.core.HornetQInvalidFilterExpressionException;
import org.hornetq.api.core.HornetQNonExistentQueueException;
import org.hornetq.api.core.HornetQQueueExistsException;
import org.hornetq.api.core.HornetQSecurityException;
import org.hornetq.api.core.HornetQSessionCreationException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.JournalType;
import org.hornetq.spi.core.protocol.ProtocolType;

public class HornetQMessageBundle_$bundle
implements Serializable,
HornetQMessageBundle {
    private static final long serialVersionUID = 1L;
    public static final HornetQMessageBundle_$bundle INSTANCE = new HornetQMessageBundle_$bundle();
    private static final String noDiscoveryGroupFound = "HQ119081: No Discovery Group configuration named {0} found";
    private static final String autoConvertError = "HQ119075: method autoEncode doesn't know how to convert {0} yet";
    private static final String addressIsNull = "HQ119057: Address is null";
    private static final String clientExited = "HQ119014: Did not receive data from {0}. It is likely the client has exited or crashed without closing its connection, or the network between the server and client has failed. You also might have configured connection-ttl and client-failure-check-period incorrectly. Please check user manual for more information. The connection will now be closed.";
    private static final String invalidRetryInterval = "HQ119037: retry interval must be positive, was {0}";
    private static final String noQueueFound = "HQ119049: No queue found for {0}";
    private static final String emptyOrNull = "HQ119038: {0} must neither be null nor empty";
    private static final String alreadyHaveReplicationServer = "HQ119024: Backup replication server is already connected to another server";
    private static final String journalsNotInSync = "HQ119022: Cannot compare journals if not in sync!";
    private static final String cannotCreateDir = "HQ119052: Directory {0} does not exist and cannot be created";
    private static final String messageIdNotAssigned = "HQ119021: MessageId was not assigned to Message";
    private static final String notPercent = "HQ119040: {0} must be a valid percentual value between 0 and 100 (actual value: {1})";
    private static final String routeNameIsNull = "HQ119055: Routing name is null";
    private static final String threadDump = "HQ119002: Thread {0} name = {1} id = {2} group = {3}";
    private static final String cannotDeleteQueue = "HQ119025: Cannot delete queue {0} on binding {1} - it has consumers = {2}";
    private static final String invalidPageIO = "HQ119080: Invalid Page IO, PagingManager was stopped or closed";
    private static final String invalidType = "HQ119036: Invalid type: {0}";
    private static final String invalidFilter = "HQ119020: Invalid filter: {0}";
    private static final String greaterThanZeroOrMinusOne = "HQ119042: {0}  must be equals to -1 or greater or equals to 0 (actual value: {1})";
    private static final String destroyConnectionWithSessionMetadataNoSessionFound = "HQ119079: No session found with {0}={1}";
    private static final String bindingAlreadyExists = "HQ119018: Binding already exists {0}";
    private static final String serverNotStarted = "HQ119034: Server not started";
    private static final String destroyConnectionWithSessionMetadataClosingConnection = "HQ119077: Closing connection {0}";
    private static final String mustbeBetween = "HQ119043: {0} must be betwen {1} and {2} inclusive (actual value: {3})";
    private static final String errorCreatingTransformerClass = "HQ119074: Error instantiating transformer class {0}";
    private static final String invalidJournalType = "HQ119044: Invalid journal type {0}";
    private static final String noOperation = "HQ119069: no operation {0}/{1}";
    private static final String replicationUnhandledDataType = "HQ119011: unhandled data type!";
    private static final String invalidAddressFullPolicyType = "HQ119045: Invalid address full message policy type {0}";
    private static final String queueNameIsNull = "HQ119066: Queue name is null";
    private static final String unknownProtocol = "HQ119064: Unknown protocol {0}";
    private static final String acceptorNotExists = "HQ119063: Acceptor with id {0} not registered";
    private static final String clusterNameIsNull = "HQ119056: Cluster name is null";
    private static final String bindingTypeNotSpecified = "HQ119058: Binding type not specified";
    private static final String nodeIdNull = "HQ119065: node id is null";
    private static final String consumerNoReference = "HQ119027: Could not find reference on consumer ID={0}, messageId = {1} queue = {2}";
    private static final String ioTimeout = "HQ119015: Timeout on waiting I/O completion";
    private static final String invalidNewPriority = "HQ119048: invalid new Priority value: {0}. It must be between 0 and 9 (both included)";
    private static final String serverDescribe = "HQ119004: Information about server {0}\nCluster Connection:{1}";
    private static final String noSuchQueue = "HQ119017: Queue {0} does not exist";
    private static final String endThreadDump = "HQ119003: End Thread dump";
    private static final String replicationUnhandledError = "HQ119007: unhandled error during replication";
    private static final String connectionExists = "HQ119061: Connection already exists with id {0}";
    private static final String greaterThanMinusOne = "HQ119041: {0}  must be equals to -1 or greater than 0 (actual value: {1})";
    private static final String greaterThanZero1 = "HQ119046: invalid value: {0} count must be greater than 0";
    private static final String invalidMessageCounterPeriod = "HQ119047: Cannot set Message Counter Sample Period < {0}ms";
    private static final String greaterThanZero2 = "HQ119039: {0}  must be greater than 0 (actual value: {1})";
    private static final String noAddress = "HQ119029: No address configured on the Server's Session";
    private static final String connectionsClosedByManagement = "HQ119005: connections for {0} closed by management";
    private static final String nullPassword = "HQ119073: Password cannot be null";
    private static final String noGetterMethod = "HQ119068: no getter method for {0}";
    private static final String bindingIdNotSpecified = "HQ119059: Binding ID is null";
    private static final String invalidJournal = "HQ119050: Only NIO and AsyncIO are supported journals";
    private static final String largeMessageNotInitialised = "HQ119030: large-message not initialized on server";
    private static final String replicationTooManyJournals = "HQ119008: Live Node contains more journals than the backup node. Probably a version match error";
    private static final String backupServerNotInSync = "HQ119026: Backup Server was not yet in sync with live";
    private static final String cannotFindResource = "HQ119067: Cannot find resource with name {0}";
    private static final String consumerDoesntExist = "HQ119028: Consumer {0} doesn't exist on the server";
    private static final String bindingNotDivert = "HQ119013: Binding {0} is not a divert";
    private static final String incompatibleClientServer = "HQ119033: Server and client versions incompatible";
    private static final String noBindingForDivert = "HQ119012: No binding for divert {0}";
    private static final String nullMatch = "HQ119070: match can not be null";
    private static final String duplicateMetadata = "HQ119035: Metadata {0}={1} had been set already";
    private static final String destroyConnectionWithSessionMetadataHeader = "HQ119076: Executing destroyConnection with {0}={1} through management's request";
    private static final String nullUser = "HQ119072: User cannot be null";
    private static final String replicationBackupUpToDate = "HQ119010: Remote Backup can not be up-to-date!";
    private static final String acceptorExists = "HQ119062: Acceptor with id {0} already registered";
    private static final String invalidIndex = "HQ119053: Invalid index {0}";
    private static final String activationForServer = "HQ119000: Activation for server {0}";
    private static final String serverNotBackupServer = "HQ119023: Connected server is not a backup server";
    private static final String invalidJournalType2 = "HQ119051: Invalid journal type {0}";
    private static final String destroyConnectionWithSessionMetadataSendException = "HQ119078: Disconnected per admin's request on {0}={1}";
    private static final String distancenotSpecified = "HQ119060: Distance is null";
    private static final String cannotConvertToInt = "HQ119054: Cannot convert to int";
    private static final String groupingQueueRemoved = "HQ119016: queue {0} has been removed cannot deliver message, queues should not be removed when grouping is used";
    private static final String notJournalImpl = "HQ119006: journals are not JournalImpl. You can't set a replicator!";
    private static final String invalidMatch = "HQ119071: * can only be at end of match";
    private static final String userNoPermissions = "HQ119032: User: {0} doesn't have permission='{1}' on address {2}";
    private static final String unableToValidateUser = "HQ119031: Unable to validate user: {0}";
    private static final String queueAlreadyExists = "HQ119019: Queue already exists {0}";
    private static final String generatingThreadDump = "HQ119001: Generating thread dump because - {0}";
    private static final String replicationUnhandledFileType = "HQ119009: Unhandled file type {0}";

    protected HornetQMessageBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public final HornetQException noDiscoveryGroupFound(DiscoveryGroupConfiguration dg) {
        HornetQException result = new HornetQException(MessageFormat.format(this.noDiscoveryGroupFound$str(), dg));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDiscoveryGroupFound$str() {
        return noDiscoveryGroupFound;
    }

    public final IllegalArgumentException autoConvertError(Class aClass) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.autoConvertError$str(), aClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String autoConvertError$str() {
        return autoConvertError;
    }

    @Override
    public final IllegalArgumentException addressIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(this.addressIsNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String addressIsNull$str() {
        return addressIsNull;
    }

    @Override
    public final HornetQConnectionTimedOutException clientExited(String remoteAddress) {
        HornetQConnectionTimedOutException result = new HornetQConnectionTimedOutException(MessageFormat.format(this.clientExited$str(), remoteAddress));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clientExited$str() {
        return clientExited;
    }

    @Override
    public final IllegalArgumentException invalidRetryInterval(Long size) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidRetryInterval$str(), size));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRetryInterval$str() {
        return invalidRetryInterval;
    }

    @Override
    public final IllegalArgumentException noQueueFound(String otherQueueName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.noQueueFound$str(), otherQueueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noQueueFound$str() {
        return noQueueFound;
    }

    @Override
    public final IllegalArgumentException emptyOrNull(String name) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.emptyOrNull$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String emptyOrNull$str() {
        return emptyOrNull;
    }

    @Override
    public final HornetQIllegalStateException alreadyHaveReplicationServer() {
        HornetQIllegalStateException result = new HornetQIllegalStateException(this.alreadyHaveReplicationServer$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String alreadyHaveReplicationServer$str() {
        return alreadyHaveReplicationServer;
    }

    @Override
    public final HornetQIllegalStateException journalsNotInSync() {
        HornetQIllegalStateException result = new HornetQIllegalStateException(this.journalsNotInSync$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String journalsNotInSync$str() {
        return journalsNotInSync;
    }

    @Override
    public final IllegalArgumentException cannotCreateDir(String dir) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.cannotCreateDir$str(), dir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateDir$str() {
        return cannotCreateDir;
    }

    @Override
    public final HornetQIllegalStateException messageIdNotAssigned() {
        HornetQIllegalStateException result = new HornetQIllegalStateException(this.messageIdNotAssigned$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String messageIdNotAssigned$str() {
        return messageIdNotAssigned;
    }

    @Override
    public final IllegalArgumentException notPercent(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.notPercent$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notPercent$str() {
        return notPercent;
    }

    @Override
    public final IllegalArgumentException routeNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(this.routeNameIsNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String routeNameIsNull$str() {
        return routeNameIsNull;
    }

    @Override
    public final String threadDump(Thread key, String name, Long id, ThreadGroup threadGroup) {
        String result = MessageFormat.format(this.threadDump$str(), key, name, id, threadGroup);
        return result;
    }

    protected String threadDump$str() {
        return threadDump;
    }

    @Override
    public final HornetQIllegalStateException cannotDeleteQueue(SimpleString name, SimpleString queueName, String s) {
        HornetQIllegalStateException result = new HornetQIllegalStateException(MessageFormat.format(this.cannotDeleteQueue$str(), name, queueName, s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeleteQueue$str() {
        return cannotDeleteQueue;
    }

    @Override
    public final HornetQIllegalStateException invalidPageIO() {
        HornetQIllegalStateException result = new HornetQIllegalStateException(this.invalidPageIO$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPageIO$str() {
        return invalidPageIO;
    }

    @Override
    public final IllegalArgumentException invalidType(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidType$str() {
        return invalidType;
    }

    @Override
    public final HornetQInvalidFilterExpressionException invalidFilter(Throwable e, SimpleString filter) {
        HornetQInvalidFilterExpressionException result = new HornetQInvalidFilterExpressionException(MessageFormat.format(this.invalidFilter$str(), filter));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFilter$str() {
        return invalidFilter;
    }

    @Override
    public final IllegalArgumentException greaterThanZeroOrMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.greaterThanZeroOrMinusOne$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZeroOrMinusOne$str() {
        return greaterThanZeroOrMinusOne;
    }

    @Override
    public final String destroyConnectionWithSessionMetadataNoSessionFound(String key, String value) {
        String result = MessageFormat.format(this.destroyConnectionWithSessionMetadataNoSessionFound$str(), key, value);
        return result;
    }

    protected String destroyConnectionWithSessionMetadataNoSessionFound$str() {
        return destroyConnectionWithSessionMetadataNoSessionFound;
    }

    @Override
    public final HornetQQueueExistsException bindingAlreadyExists(Binding binding) {
        HornetQQueueExistsException result = new HornetQQueueExistsException(MessageFormat.format(this.bindingAlreadyExists$str(), binding));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingAlreadyExists$str() {
        return bindingAlreadyExists;
    }

    @Override
    public final HornetQSessionCreationException serverNotStarted() {
        HornetQSessionCreationException result = new HornetQSessionCreationException(this.serverNotStarted$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverNotStarted$str() {
        return serverNotStarted;
    }

    @Override
    public final String destroyConnectionWithSessionMetadataClosingConnection(String serverSessionString) {
        String result = MessageFormat.format(this.destroyConnectionWithSessionMetadataClosingConnection$str(), serverSessionString);
        return result;
    }

    protected String destroyConnectionWithSessionMetadataClosingConnection$str() {
        return destroyConnectionWithSessionMetadataClosingConnection;
    }

    @Override
    public final IllegalArgumentException mustbeBetween(String name, Integer minPriority, Integer maxPriority, Object value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.mustbeBetween$str(), name, minPriority, maxPriority, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustbeBetween$str() {
        return mustbeBetween;
    }

    @Override
    public final IllegalArgumentException errorCreatingTransformerClass(Exception e, String transformerClassName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.errorCreatingTransformerClass$str(), transformerClassName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCreatingTransformerClass$str() {
        return errorCreatingTransformerClass;
    }

    @Override
    public final IllegalArgumentException invalidJournalType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidJournalType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournalType$str() {
        return invalidJournalType;
    }

    @Override
    public final IllegalArgumentException noOperation(String operation, Integer length) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.noOperation$str(), operation, length));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noOperation$str() {
        return noOperation;
    }

    @Override
    public final HornetQInternalErrorException replicationUnhandledDataType() {
        HornetQInternalErrorException result = new HornetQInternalErrorException(this.replicationUnhandledDataType$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledDataType$str() {
        return replicationUnhandledDataType;
    }

    @Override
    public final IllegalArgumentException invalidAddressFullPolicyType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidAddressFullPolicyType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAddressFullPolicyType$str() {
        return invalidAddressFullPolicyType;
    }

    @Override
    public final IllegalArgumentException queueNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(this.queueNameIsNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueNameIsNull$str() {
        return queueNameIsNull;
    }

    @Override
    public final IllegalArgumentException unknownProtocol(ProtocolType protocol) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.unknownProtocol$str(), protocol));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownProtocol$str() {
        return unknownProtocol;
    }

    @Override
    public final IllegalArgumentException acceptorNotExists(Integer id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.acceptorNotExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acceptorNotExists$str() {
        return acceptorNotExists;
    }

    @Override
    public final IllegalArgumentException clusterNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(this.clusterNameIsNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clusterNameIsNull$str() {
        return clusterNameIsNull;
    }

    @Override
    public final IllegalArgumentException bindingTypeNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(this.bindingTypeNotSpecified$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingTypeNotSpecified$str() {
        return bindingTypeNotSpecified;
    }

    @Override
    public final IllegalArgumentException nodeIdNull() {
        IllegalArgumentException result = new IllegalArgumentException(this.nodeIdNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nodeIdNull$str() {
        return nodeIdNull;
    }

    @Override
    public final HornetQIllegalStateException consumerNoReference(Long id, Long messageID, SimpleString name) {
        HornetQIllegalStateException result = new HornetQIllegalStateException(MessageFormat.format(this.consumerNoReference$str(), id, messageID, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerNoReference$str() {
        return consumerNoReference;
    }

    @Override
    public final HornetQIOErrorException ioTimeout() {
        HornetQIOErrorException result = new HornetQIOErrorException(this.ioTimeout$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioTimeout$str() {
        return ioTimeout;
    }

    @Override
    public final IllegalArgumentException invalidNewPriority(Integer period) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidNewPriority$str(), period));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNewPriority$str() {
        return invalidNewPriority;
    }

    @Override
    public final String serverDescribe(String identity, String describe) {
        String result = MessageFormat.format(this.serverDescribe$str(), identity, describe);
        return result;
    }

    protected String serverDescribe$str() {
        return serverDescribe;
    }

    @Override
    public final HornetQNonExistentQueueException noSuchQueue(SimpleString queueName) {
        HornetQNonExistentQueueException result = new HornetQNonExistentQueueException(MessageFormat.format(this.noSuchQueue$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchQueue$str() {
        return noSuchQueue;
    }

    @Override
    public final String endThreadDump() {
        String result = this.endThreadDump$str();
        return result;
    }

    protected String endThreadDump$str() {
        return endThreadDump;
    }

    @Override
    public final HornetQInternalErrorException replicationUnhandledError(Exception e) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(this.replicationUnhandledError$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledError$str() {
        return replicationUnhandledError;
    }

    @Override
    public final IllegalArgumentException connectionExists(Object id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.connectionExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionExists$str() {
        return connectionExists;
    }

    @Override
    public final IllegalArgumentException greaterThanMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.greaterThanMinusOne$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanMinusOne$str() {
        return greaterThanMinusOne;
    }

    @Override
    public final IllegalArgumentException greaterThanZero(Integer count) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.greaterThanZero1$str(), count));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZero1$str() {
        return greaterThanZero1;
    }

    @Override
    public final IllegalArgumentException invalidMessageCounterPeriod(Long period) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidMessageCounterPeriod$str(), period));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMessageCounterPeriod$str() {
        return invalidMessageCounterPeriod;
    }

    @Override
    public final IllegalArgumentException greaterThanZero(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.greaterThanZero2$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZero2$str() {
        return greaterThanZero2;
    }

    @Override
    public final HornetQIllegalStateException noAddress() {
        HornetQIllegalStateException result = new HornetQIllegalStateException(this.noAddress$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noAddress$str() {
        return noAddress;
    }

    @Override
    public final HornetQInternalErrorException connectionsClosedByManagement(String ipAddress) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format(this.connectionsClosedByManagement$str(), ipAddress));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionsClosedByManagement$str() {
        return connectionsClosedByManagement;
    }

    @Override
    public final IllegalArgumentException nullPassword() {
        IllegalArgumentException result = new IllegalArgumentException(this.nullPassword$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullPassword$str() {
        return nullPassword;
    }

    @Override
    public final IllegalArgumentException noGetterMethod(String resourceName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.noGetterMethod$str(), resourceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noGetterMethod$str() {
        return noGetterMethod;
    }

    @Override
    public final IllegalArgumentException bindingIdNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(this.bindingIdNotSpecified$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingIdNotSpecified$str() {
        return bindingIdNotSpecified;
    }

    @Override
    public final IllegalArgumentException invalidJournal() {
        IllegalArgumentException result = new IllegalArgumentException(this.invalidJournal$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournal$str() {
        return invalidJournal;
    }

    @Override
    public final HornetQIllegalStateException largeMessageNotInitialised() {
        HornetQIllegalStateException result = new HornetQIllegalStateException(this.largeMessageNotInitialised$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String largeMessageNotInitialised$str() {
        return largeMessageNotInitialised;
    }

    @Override
    public final HornetQInternalErrorException replicationTooManyJournals() {
        HornetQInternalErrorException result = new HornetQInternalErrorException(this.replicationTooManyJournals$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationTooManyJournals$str() {
        return replicationTooManyJournals;
    }

    @Override
    public final HornetQIllegalStateException backupServerNotInSync() {
        HornetQIllegalStateException result = new HornetQIllegalStateException(this.backupServerNotInSync$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backupServerNotInSync$str() {
        return backupServerNotInSync;
    }

    @Override
    public final IllegalArgumentException cannotFindResource(String resourceName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.cannotFindResource$str(), resourceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindResource$str() {
        return cannotFindResource;
    }

    @Override
    public final HornetQIllegalStateException consumerDoesntExist(long consumerID) {
        HornetQIllegalStateException result = new HornetQIllegalStateException(MessageFormat.format(this.consumerDoesntExist$str(), consumerID));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerDoesntExist$str() {
        return consumerDoesntExist;
    }

    @Override
    public final HornetQInternalErrorException bindingNotDivert(SimpleString name) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format(this.bindingNotDivert$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingNotDivert$str() {
        return bindingNotDivert;
    }

    @Override
    public final HornetQIncompatibleClientServerException incompatibleClientServer() {
        HornetQIncompatibleClientServerException result = new HornetQIncompatibleClientServerException(this.incompatibleClientServer$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incompatibleClientServer$str() {
        return incompatibleClientServer;
    }

    @Override
    public final HornetQInternalErrorException noBindingForDivert(SimpleString name) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format(this.noBindingForDivert$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noBindingForDivert$str() {
        return noBindingForDivert;
    }

    @Override
    public final IllegalArgumentException nullMatch() {
        IllegalArgumentException result = new IllegalArgumentException(this.nullMatch$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullMatch$str() {
        return nullMatch;
    }

    @Override
    public final HornetQDuplicateMetaDataException duplicateMetadata(String key, String data) {
        HornetQDuplicateMetaDataException result = new HornetQDuplicateMetaDataException(MessageFormat.format(this.duplicateMetadata$str(), key, data));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateMetadata$str() {
        return duplicateMetadata;
    }

    @Override
    public final String destroyConnectionWithSessionMetadataHeader(String key, String value) {
        String result = MessageFormat.format(this.destroyConnectionWithSessionMetadataHeader$str(), key, value);
        return result;
    }

    protected String destroyConnectionWithSessionMetadataHeader$str() {
        return destroyConnectionWithSessionMetadataHeader;
    }

    @Override
    public final IllegalArgumentException nullUser() {
        IllegalArgumentException result = new IllegalArgumentException(this.nullUser$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullUser$str() {
        return nullUser;
    }

    @Override
    public final HornetQInternalErrorException replicationBackupUpToDate() {
        HornetQInternalErrorException result = new HornetQInternalErrorException(this.replicationBackupUpToDate$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationBackupUpToDate$str() {
        return replicationBackupUpToDate;
    }

    @Override
    public final IllegalArgumentException acceptorExists(Integer id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.acceptorExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acceptorExists$str() {
        return acceptorExists;
    }

    @Override
    public final IllegalArgumentException invalidIndex(Integer index) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidIndex$str(), index));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidIndex$str() {
        return invalidIndex;
    }

    @Override
    public final String activationForServer(HornetQServer server) {
        String result = MessageFormat.format(this.activationForServer$str(), server);
        return result;
    }

    protected String activationForServer$str() {
        return activationForServer;
    }

    @Override
    public final HornetQIllegalStateException serverNotBackupServer() {
        HornetQIllegalStateException result = new HornetQIllegalStateException(this.serverNotBackupServer$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverNotBackupServer$str() {
        return serverNotBackupServer;
    }

    @Override
    public final IllegalArgumentException invalidJournalType2(JournalType journalType) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidJournalType2$str(), new Object[]{journalType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournalType2$str() {
        return invalidJournalType2;
    }

    @Override
    public final HornetQDisconnectedException destroyConnectionWithSessionMetadataSendException(String key, String value) {
        HornetQDisconnectedException result = new HornetQDisconnectedException(MessageFormat.format(this.destroyConnectionWithSessionMetadataSendException$str(), key, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String destroyConnectionWithSessionMetadataSendException$str() {
        return destroyConnectionWithSessionMetadataSendException;
    }

    @Override
    public final IllegalArgumentException distancenotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(this.distancenotSpecified$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String distancenotSpecified$str() {
        return distancenotSpecified;
    }

    @Override
    public final IllegalArgumentException cannotConvertToInt() {
        IllegalArgumentException result = new IllegalArgumentException(this.cannotConvertToInt$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConvertToInt$str() {
        return cannotConvertToInt;
    }

    @Override
    public final HornetQNonExistentQueueException groupingQueueRemoved(SimpleString chosenClusterName) {
        HornetQNonExistentQueueException result = new HornetQNonExistentQueueException(MessageFormat.format(this.groupingQueueRemoved$str(), chosenClusterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String groupingQueueRemoved$str() {
        return groupingQueueRemoved;
    }

    @Override
    public final HornetQInternalErrorException notJournalImpl() {
        HornetQInternalErrorException result = new HornetQInternalErrorException(this.notJournalImpl$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notJournalImpl$str() {
        return notJournalImpl;
    }

    @Override
    public final IllegalArgumentException invalidMatch() {
        IllegalArgumentException result = new IllegalArgumentException(this.invalidMatch$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMatch$str() {
        return invalidMatch;
    }

    @Override
    public final HornetQSecurityException userNoPermissions(String username, CheckType checkType, String saddress) {
        HornetQSecurityException result = new HornetQSecurityException(MessageFormat.format(this.userNoPermissions$str(), new Object[]{username, checkType, saddress}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userNoPermissions$str() {
        return userNoPermissions;
    }

    @Override
    public final HornetQSecurityException unableToValidateUser(String user) {
        HornetQSecurityException result = new HornetQSecurityException(MessageFormat.format(this.unableToValidateUser$str(), user));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToValidateUser$str() {
        return unableToValidateUser;
    }

    @Override
    public final HornetQQueueExistsException queueAlreadyExists(SimpleString queueName) {
        HornetQQueueExistsException result = new HornetQQueueExistsException(MessageFormat.format(this.queueAlreadyExists$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueAlreadyExists$str() {
        return queueAlreadyExists;
    }

    @Override
    public final String generatingThreadDump(String reason) {
        String result = MessageFormat.format(this.generatingThreadDump$str(), reason);
        return result;
    }

    protected String generatingThreadDump$str() {
        return generatingThreadDump;
    }

    @Override
    public final HornetQInternalErrorException replicationUnhandledFileType(ReplicationSyncFileMessage.FileType fileType) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format(this.replicationUnhandledFileType$str(), new Object[]{fileType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledFileType$str() {
        return replicationUnhandledFileType;
    }
}

