/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.infinispan.manager.CacheContainer;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactoryService;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.ChannelDependentServiceProvider;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanJndiName;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.TransportResource;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.Services;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class CacheContainerAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheContainerAdd.class.getPackage().getName());
    public static final CacheContainerAdd INSTANCE = new CacheContainerAdd();

    static ModelNode createOperation(ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        CacheContainerAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        CacheContainerResource.DEFAULT_CACHE.validateAndSet(source, target);
        if (source.hasDefined("aliases")) {
            target.get("aliases").set(source.get("aliases"));
        }
        CacheContainerResource.JNDI_NAME.validateAndSet(source, target);
        CacheContainerResource.START.validateAndSet(source, target);
        CacheContainerResource.LISTENER_EXECUTOR.validateAndSet(source, target);
        CacheContainerResource.EVICTION_EXECUTOR.validateAndSet(source, target);
        CacheContainerResource.REPLICATION_QUEUE_EXECUTOR.validateAndSet(source, target);
        CacheContainerResource.CACHE_CONTAINER_MODULE.validateAndSet(source, target);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CacheContainerAdd.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        newControllers.addAll(this.installRuntimeServices(context, operation, model, verificationHandler));
    }

    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        PathAddress address = this.getCacheContainerAddressFromOperation(operation);
        String name = address.getLastElement().getValue();
        ServiceTarget target = context.getServiceTarget();
        ModelNode resolvedValue = null;
        resolvedValue = CacheContainerResource.DEFAULT_CACHE.resolveModelAttribute(context, containerModel);
        String defaultCache = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CacheContainerResource.JNDI_NAME.resolveModelAttribute(context, containerModel);
        String jndiName = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CacheContainerResource.LISTENER_EXECUTOR.resolveModelAttribute(context, containerModel);
        String listenerExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CacheContainerResource.EVICTION_EXECUTOR.resolveModelAttribute(context, containerModel);
        String evictionExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CacheContainerResource.REPLICATION_QUEUE_EXECUTOR.resolveModelAttribute(context, containerModel);
        String replicationQueueExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        ServiceController.Mode initialMode = StartMode.valueOf(CacheContainerResource.START.resolveModelAttribute(context, containerModel).asString()).getMode();
        ServiceName[] aliases = null;
        if (containerModel.hasDefined("aliases")) {
            List list = operation.get("aliases").asList();
            aliases = new ServiceName[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                aliases[i] = EmbeddedCacheManagerService.getServiceName(((ModelNode)list.get(i)).asString());
            }
        }
        ModuleIdentifier moduleId = (resolvedValue = CacheContainerResource.CACHE_CONTAINER_MODULE.resolveModelAttribute(context, containerModel)).isDefined() ? ModuleIdentifier.fromString((String)resolvedValue.asString()) : null;
        Transport transportConfig = containerModel.hasDefined("transport") && containerModel.get("transport").hasDefined("TRANSPORT") ? new Transport() : null;
        String stack = null;
        String transportExecutor = null;
        LinkedList controllers = new LinkedList();
        if (transportConfig != null) {
            ModelNode transport = containerModel.get(new String[]{"transport", "TRANSPORT"});
            resolvedValue = TransportResource.STACK.resolveModelAttribute(context, transport);
            stack = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            resolvedValue = TransportResource.CLUSTER.resolveModelAttribute(context, transport);
            String cluster = resolvedValue.isDefined() ? resolvedValue.asString() : name;
            long lockTimeout = TransportResource.LOCK_TIMEOUT.resolveModelAttribute(context, transport).asLong();
            resolvedValue = TransportResource.EXECUTOR.resolveModelAttribute(context, transport);
            transportExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            transportConfig.setClusterName(cluster);
            transportConfig.setLockTimeout(lockTimeout);
            controllers.add(this.installChannelService(target, name, cluster, stack, verificationHandler));
            for (ChannelDependentServiceProvider provider : ServiceLoader.load(ChannelDependentServiceProvider.class, ChannelDependentServiceProvider.class.getClassLoader())) {
                controllers.add(provider.install(target, name));
            }
        }
        controllers.add(this.installContainerConfigurationService(target, name, defaultCache, moduleId, stack, transportConfig, transportExecutor, listenerExecutor, evictionExecutor, replicationQueueExecutor, verificationHandler));
        controllers.add(this.installContainerService(target, name, aliases, transportConfig, initialMode, verificationHandler));
        controllers.add(this.installJndiService(target, name, InfinispanJndiName.createCacheContainerJndiName(jndiName, name), verificationHandler));
        controllers.add(this.installKeyAffinityServiceFactoryService(target, name, verificationHandler));
        log.debugf("%s cache container installed", (Object)name);
        return controllers;
    }

    void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = this.getCacheContainerAddressFromOperation(operation);
        String containerName = address.getLastElement().getValue();
        context.removeService(KeyAffinityServiceFactoryService.getServiceName(containerName));
        ModelNode resolvedValue = null;
        resolvedValue = CacheContainerResource.JNDI_NAME.resolveModelAttribute(context, model);
        String jndiName = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)InfinispanJndiName.createCacheContainerJndiName(jndiName, containerName));
        context.removeService(bindInfo.getBinderServiceName());
        context.removeService(EmbeddedCacheManagerService.getServiceName(containerName));
        context.removeService(EmbeddedCacheManagerConfigurationService.getServiceName(containerName));
        ServiceName channelServiceName = ChannelService.getServiceName((String)containerName);
        ServiceController channelServiceController = context.getServiceRegistry(false).getService(channelServiceName);
        if (channelServiceController != null) {
            for (ChannelDependentServiceProvider provider : ServiceLoader.load(ChannelDependentServiceProvider.class, ChannelDependentServiceProvider.class.getClassLoader())) {
                context.removeService(provider.getServiceName(containerName));
            }
            context.removeService(channelServiceName);
        }
    }

    ServiceController<?> installKeyAffinityServiceFactoryService(ServiceTarget target, String containerName, ServiceVerificationHandler verificationHandler) {
        return AsynchronousService.addService((ServiceTarget)target, (ServiceName)KeyAffinityServiceFactoryService.getServiceName(containerName), (Service)new KeyAffinityServiceFactoryService(10), (boolean)false, (boolean)true).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    ServiceController<?> installChannelService(ServiceTarget target, String containerName, String cluster, String stack, ServiceVerificationHandler verificationHandler) {
        InjectedValue channelFactory = new InjectedValue();
        return AsynchronousService.addService((ServiceTarget)target, (ServiceName)ChannelService.getServiceName((String)containerName), (Service)new ChannelService(cluster, (Value)channelFactory)).addDependency(ChannelFactoryService.getServiceName((String)stack), ChannelFactory.class, (Injector)channelFactory).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    PathAddress getCacheContainerAddressFromOperation(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.get("address"));
    }

    ServiceController<?> installContainerConfigurationService(ServiceTarget target, String containerName, String defaultCache, ModuleIdentifier moduleId, String stack, Transport transportConfig, String transportExecutor, String listenerExecutor, String evictionExecutor, String replicationQueueExecutor, ServiceVerificationHandler verificationHandler) {
        ServiceName configServiceName = EmbeddedCacheManagerConfigurationService.getServiceName(containerName);
        EmbeddedCacheManagerDependencies dependencies = new EmbeddedCacheManagerDependencies(transportConfig);
        EmbeddedCacheManagerConfigurationService service = new EmbeddedCacheManagerConfigurationService(containerName, defaultCache, moduleId, dependencies);
        ServiceBuilder configBuilder = target.addService(configServiceName, (Service)service).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, dependencies.getModuleLoaderInjector()).addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, dependencies.getMBeanServerInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (transportConfig != null) {
            if (transportExecutor != null) {
                this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, transportExecutor, transportConfig.getExecutorInjector());
            }
            configBuilder.addDependency(ChannelFactoryService.getServiceName((String)stack), ChannelFactory.class, transportConfig.getChannelFactoryInjector());
        }
        this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, listenerExecutor, dependencies.getListenerExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, evictionExecutor, dependencies.getEvictionExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, replicationQueueExecutor, dependencies.getReplicationQueueExecutorInjector());
        return configBuilder.install();
    }

    ServiceController<?> installContainerService(ServiceTarget target, String containerName, ServiceName[] aliases, Transport transport, ServiceController.Mode initialMode, ServiceVerificationHandler verificationHandler) {
        ServiceName containerServiceName = EmbeddedCacheManagerService.getServiceName(containerName);
        ServiceName configServiceName = EmbeddedCacheManagerConfigurationService.getServiceName(containerName);
        InjectedValue config = new InjectedValue();
        EmbeddedCacheManagerService service = new EmbeddedCacheManagerService((Value<EmbeddedCacheManagerConfiguration>)config);
        ServiceBuilder builder = target.addService(containerServiceName, (Service)service).addDependency(configServiceName, EmbeddedCacheManagerConfiguration.class, (Injector)config).addAliases(aliases).setInitialMode(initialMode);
        if (transport != null) {
            builder.addDependency(ChannelService.getServiceName((String)containerName));
        }
        return builder.install();
    }

    ServiceController<?> installJndiService(ServiceTarget target, String containerName, String jndiName, ServiceVerificationHandler verificationHandler) {
        ServiceName containerServiceName = EmbeddedCacheManagerService.getServiceName(containerName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        return target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName})}).addDependency(containerServiceName, CacheContainer.class, (Injector)new ManagedReferenceInjector(binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    private void addExecutorDependency(ServiceBuilder<EmbeddedCacheManagerConfiguration> builder, String executor, Injector<Executor> injector) {
        if (executor != null) {
            builder.addDependency(ThreadsServices.executorName((String)executor), Executor.class, injector);
        }
    }

    private void addScheduledExecutorDependency(ServiceBuilder<EmbeddedCacheManagerConfiguration> builder, String executor, Injector<ScheduledExecutorService> injector) {
        if (executor != null) {
            builder.addDependency(ThreadsServices.executorName((String)executor), ScheduledExecutorService.class, injector);
        }
    }

    static class Transport
    implements EmbeddedCacheManagerConfigurationService.TransportConfiguration {
        private final InjectedValue<ChannelFactory> channelFactory = new InjectedValue();
        private final InjectedValue<Executor> executor = new InjectedValue();
        private Long lockTimeout;
        private String clusterName;

        Transport() {
        }

        void setLockTimeout(long lockTimeout) {
            this.lockTimeout = lockTimeout;
        }

        void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        Injector<ChannelFactory> getChannelFactoryInjector() {
            return this.channelFactory;
        }

        Injector<Executor> getExecutorInjector() {
            return this.executor;
        }

        @Override
        public ChannelFactory getChannelFactory() {
            return (ChannelFactory)this.channelFactory.getValue();
        }

        @Override
        public Executor getExecutor() {
            return (Executor)this.executor.getOptionalValue();
        }

        @Override
        public Long getLockTimeout() {
            return this.lockTimeout;
        }

        @Override
        public String getClusterName() {
            return this.clusterName;
        }
    }

    static class EmbeddedCacheManagerDependencies
    implements EmbeddedCacheManagerConfigurationService.Dependencies {
        private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
        private final InjectedValue<Executor> listenerExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> evictionExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> replicationQueueExecutor = new InjectedValue();
        private final EmbeddedCacheManagerConfigurationService.TransportConfiguration transport;
        private final InjectedValue<ModuleLoader> moduleLoader = new InjectedValue();

        EmbeddedCacheManagerDependencies(EmbeddedCacheManagerConfigurationService.TransportConfiguration transport) {
            this.transport = transport;
        }

        Injector<MBeanServer> getMBeanServerInjector() {
            return this.mbeanServer;
        }

        Injector<Executor> getListenerExecutorInjector() {
            return this.listenerExecutor;
        }

        Injector<ScheduledExecutorService> getEvictionExecutorInjector() {
            return this.evictionExecutor;
        }

        Injector<ScheduledExecutorService> getReplicationQueueExecutorInjector() {
            return this.replicationQueueExecutor;
        }

        Injector<ModuleLoader> getModuleLoaderInjector() {
            return this.moduleLoader;
        }

        @Override
        public EmbeddedCacheManagerConfigurationService.TransportConfiguration getTransportConfiguration() {
            return this.transport;
        }

        @Override
        public MBeanServer getMBeanServer() {
            return (MBeanServer)this.mbeanServer.getOptionalValue();
        }

        @Override
        public Executor getListenerExecutor() {
            return (Executor)this.listenerExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getEvictionExecutor() {
            return (ScheduledExecutorService)this.evictionExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getReplicationQueueExecutor() {
            return (ScheduledExecutorService)this.replicationQueueExecutor.getOptionalValue();
        }

        @Override
        public ModuleLoader getModuleLoader() {
            return (ModuleLoader)this.moduleLoader.getValue();
        }
    }
}

