/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public final class ContextClassLoaderInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = 3727922476337147374L;
    private static final RuntimePermission SET_CLASS_LOADER_PERMISSION = new RuntimePermission("setContextClassLoader");
    private final ClassLoader classLoader;

    public ContextClassLoaderInterceptor(ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CLASS_LOADER_PERMISSION);
        }
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processInvocation(InterceptorContext context) throws Exception {
        ClassLoader old;
        Thread thread = Thread.currentThread();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            old = AccessController.doPrivileged(new ClassLoaderAction(this.classLoader));
        } else {
            old = thread.getContextClassLoader();
            thread.setContextClassLoader(this.classLoader);
        }
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            if (sm != null) {
                AccessController.doPrivileged(new ClassLoaderAction(old));
            } else {
                thread.setContextClassLoader(old);
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CLASS_LOADER_PERMISSION);
        }
    }

    private static class ClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        private ClassLoader classLoader;

        public ClassLoaderAction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClassLoader run() {
            Thread thread = Thread.currentThread();
            try {
                ClassLoader classLoader = thread.getContextClassLoader();
                return classLoader;
            }
            finally {
                thread.setContextClassLoader(this.classLoader);
            }
        }
    }
}

