/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEClassIntrospector;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.interceptors.UserInterceptorFactory;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.stateful.SerializedCdiInterceptorsKey;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.WeldStartService;
import org.jboss.as.weld.deployment.WeldClassIntrospector;
import org.jboss.as.weld.ejb.EjbRequestScopeActivationInterceptor;
import org.jboss.as.weld.ejb.Jsr299BindingsCreateInterceptor;
import org.jboss.as.weld.ejb.Jsr299BindingsInterceptor;
import org.jboss.as.weld.ejb.WeldInterceptorBindingsService;
import org.jboss.as.weld.injection.WeldInjectionInterceptor;
import org.jboss.as.weld.injection.WeldManagedReferenceFactory;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.weld.ejb.spi.InterceptorBindings;

public class WeldComponentIntegrationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        final DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(Attachments.CLASS_INDEX);
        if (!WeldDeploymentMarker.isWeldDeployment(deploymentUnit)) {
            return;
        }
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        final ServiceName weldBootstrapService = topLevelDeployment.getServiceName().append(WeldBootstrapService.SERVICE_NAME);
        final ServiceName weldStartService = topLevelDeployment.getServiceName().append(WeldStartService.SERVICE_NAME);
        eeModuleDescription.setClassIntrospector((EEClassIntrospector)WeldClassIntrospector.install(deploymentUnit, phaseContext.getServiceTarget()));
        for (ComponentDescription component : eeModuleDescription.getComponentDescriptions()) {
            final String beanName = component instanceof EJBComponentDescription ? component.getComponentName() : null;
            component.getConfigurators().addFirst(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    Class componentClass = configuration.getComponentClass();
                    DeploymentUnit deploymentUnit = context.getDeploymentUnit();
                    ModuleClassLoader classLoader = ((Module)deploymentUnit.getAttachment(Attachments.MODULE)).getClassLoader();
                    HashSet interceptorClasses = new HashSet();
                    for (InterceptorDescription interceptorDescription : description.getAllInterceptors()) {
                        try {
                            ClassIndex index = classIndex.classIndex(interceptorDescription.getInterceptorClassName());
                            interceptorClasses.add(index.getModuleClass());
                        }
                        catch (ClassNotFoundException e) {
                            throw WeldMessages.MESSAGES.couldNotLoadInterceptorClass(interceptorDescription.getInterceptorClassName(), e);
                        }
                    }
                    WeldComponentIntegrationProcessor.this.addWeldIntegration(context.getServiceTarget(), configuration, description, componentClass, beanName, weldBootstrapService, weldStartService, interceptorClasses, (ClassLoader)classLoader, description.getBeanDeploymentArchiveId());
                    WeldManagedReferenceFactory refFactory = configuration.getInstanceFactory() instanceof WeldManagedReferenceFactory ? (WeldManagedReferenceFactory)configuration.getInstanceFactory() : null;
                    configuration.addPostConstructInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new WeldInjectionInterceptor(refFactory, interceptorClasses)), 3152);
                    if (description instanceof StatefulComponentDescription) {
                        configuration.getInterceptorContextKeys().add(SerializedCdiInterceptorsKey.class);
                    }
                }
            });
        }
    }

    private void addWeldIntegration(ServiceTarget target, ComponentConfiguration configuration, ComponentDescription description, Class<?> componentClass, String beanName, ServiceName weldServiceName, ServiceName weldStartService, Set<Class<?>> interceptorClasses, ClassLoader classLoader, String beanDeploymentArchiveId) {
        final ServiceName serviceName = configuration.getComponentDescription().getServiceName().append(new String[]{"WeldInstantiator"});
        WeldManagedReferenceFactory factory = new WeldManagedReferenceFactory(componentClass, beanName, interceptorClasses, classLoader, beanDeploymentArchiveId, description.isCDIInterceptorEnabled());
        ServiceBuilder builder = target.addService(serviceName, (Service)factory).addDependency(weldServiceName, WeldBootstrapService.class, factory.getWeldContainer()).addDependency(weldStartService);
        configuration.setInstanceFactory((ManagedReferenceFactory)factory);
        configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

            public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                serviceBuilder.addDependency(serviceName);
            }
        });
        if (description instanceof EJBComponentDescription) {
            WeldInterceptorBindingsService weldInterceptorBindingsService = new WeldInterceptorBindingsService(beanDeploymentArchiveId, configuration.getComponentName());
            ServiceName bindingServiceName = configuration.getComponentDescription().getServiceName().append(WeldInterceptorBindingsService.SERVICE_NAME);
            target.addService(bindingServiceName, (Service)weldInterceptorBindingsService).addDependency(weldServiceName, WeldBootstrapService.class, weldInterceptorBindingsService.getWeldContainer()).addDependency(weldStartService).install();
            EjbRequestScopeActivationInterceptor.Factory requestFactory = new EjbRequestScopeActivationInterceptor.Factory(weldServiceName);
            configuration.addComponentInterceptor((InterceptorFactory)requestFactory, 800, false);
            Jsr299BindingsCreateInterceptor createInterceptor = new Jsr299BindingsCreateInterceptor(description.getBeanDeploymentArchiveId(), beanName);
            configuration.addPostConstructInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)createInterceptor), 1664);
            builder.addDependency(weldServiceName, WeldBootstrapService.class, createInterceptor.getWeldContainer());
            builder.addDependency(bindingServiceName, InterceptorBindings.class, createInterceptor.getInterceptorBindings());
            configuration.addComponentInterceptor((InterceptorFactory)new UserInterceptorFactory(Jsr299BindingsInterceptor.factory(InterceptionType.AROUND_INVOKE, builder, bindingServiceName), Jsr299BindingsInterceptor.factory(InterceptionType.AROUND_TIMEOUT, builder, bindingServiceName)), 2816, false);
            configuration.addPreDestroyInterceptor(Jsr299BindingsInterceptor.factory(InterceptionType.PRE_DESTROY, builder, bindingServiceName), 3072);
            if (description.isPassivationApplicable()) {
                configuration.addPrePassivateInterceptor(Jsr299BindingsInterceptor.factory(InterceptionType.PRE_PASSIVATE, builder, bindingServiceName), 2560);
                configuration.addPostActivateInterceptor(Jsr299BindingsInterceptor.factory(InterceptionType.POST_ACTIVATE, builder, bindingServiceName), 2560);
            }
            configuration.addPostConstructInterceptor(Jsr299BindingsInterceptor.factory(InterceptionType.POST_CONSTRUCT, builder, bindingServiceName), 4096);
            EjbRequestScopeActivationInterceptor.Factory postConstructRequestContextActivationFactory = new EjbRequestScopeActivationInterceptor.Factory(weldServiceName);
            configuration.addPostConstructInterceptor((InterceptorFactory)postConstructRequestContextActivationFactory, 3712);
        }
        builder.install();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

