/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.lang.reflect.Member;
import javax.annotation.Resource;
import javax.ejb.TimerService;
import javax.ejb.spi.HandleDelegate;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.weld.WeldLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.helpers.AbstractResourceServices;
import org.jboss.ws.common.injection.ThreadLocalAwareWebServiceContext;
import org.omg.CORBA.ORB;

public class WeldResourceInjectionServices
extends AbstractResourceServices
implements Service<WeldResourceInjectionServices>,
ResourceInjectionServices {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"WeldResourceInjectionServices"});
    private static final String USER_TRANSACTION_LOCATION = "java:comp/UserTransaction";
    private static final String USER_TRANSACTION_CLASS_NAME = "javax.transaction.UserTransaction";
    private static final String HANDLE_DELEGATE_CLASS_NAME = "javax.ejb.spi.HandleDelegate";
    private static final String TIMER_SERVICE_CLASS_NAME = "javax.ejb.TimerService";
    private static final String ORB_CLASS_NAME = "org.omg.CORBA.ORB";
    private static final String EJB_CONTEXT_LOCATION = "java:comp/EJBContext";
    private static final String EJB_CONTEXT_CLASS_NAME = "javax.ejb.EJBContext";
    private static final String EJB_SESSION_CONTEXT_CLASS_NAME = "javax.ejb.SessionContext";
    private static final String EJB_MESSAGE_DRIVEN_CONTEXT_CLASS_NAME = "javax.ejb.MessageDrivenContext";
    private static final String EJB_ENTITY_CONTEXT_CLASS_NAME = "javax.ejb.EntityContext";
    private static final String WEB_SERVICE_CONTEXT_CLASS_NAME = "javax.xml.ws.WebServiceContext";
    private final Context context;

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public WeldResourceInjectionServices getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    protected static String getEJBResourceName(InjectionPoint injectionPoint, String proposedName) {
        if (injectionPoint.getType() instanceof Class) {
            Class type = (Class)injectionPoint.getType();
            String typeName = type.getName();
            if (USER_TRANSACTION_CLASS_NAME.equals(typeName)) {
                return USER_TRANSACTION_LOCATION;
            }
            if (HANDLE_DELEGATE_CLASS_NAME.equals(typeName)) {
                WeldLogger.ROOT_LOGGER.injectionTypeNotValue(HandleDelegate.class, injectionPoint.getMember());
                return proposedName;
            }
            if (ORB_CLASS_NAME.equals(typeName)) {
                WeldLogger.ROOT_LOGGER.injectionTypeNotValue(ORB.class, injectionPoint.getMember());
                return proposedName;
            }
            if (TIMER_SERVICE_CLASS_NAME.equals(typeName)) {
                WeldLogger.ROOT_LOGGER.injectionTypeNotValue(TimerService.class, injectionPoint.getMember());
                return proposedName;
            }
            if (EJB_CONTEXT_CLASS_NAME.equals(typeName) || EJB_SESSION_CONTEXT_CLASS_NAME.equals(typeName) || EJB_MESSAGE_DRIVEN_CONTEXT_CLASS_NAME.equals(typeName) || EJB_ENTITY_CONTEXT_CLASS_NAME.equals(typeName)) {
                return EJB_CONTEXT_LOCATION;
            }
            if (WEB_SERVICE_CONTEXT_CLASS_NAME.equals(typeName)) {
                return WEB_SERVICE_CONTEXT_CLASS_NAME;
            }
        }
        return proposedName;
    }

    public WeldResourceInjectionServices() {
        try {
            this.context = new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected Context getContext() {
        return this.context;
    }

    protected String getResourceName(InjectionPoint injectionPoint) {
        Resource resource = (Resource)injectionPoint.getAnnotated().getAnnotation(Resource.class);
        String mappedName = resource.mappedName();
        String lookup = resource.lookup();
        if (!lookup.isEmpty()) {
            return lookup;
        }
        if (!mappedName.isEmpty()) {
            return mappedName;
        }
        String proposedName = super.getResourceName(injectionPoint);
        return WeldResourceInjectionServices.getEJBResourceName(injectionPoint, proposedName);
    }

    public Object resolveResource(InjectionPoint injectionPoint) {
        Member member = injectionPoint.getMember();
        String name = this.getResourceName(injectionPoint);
        if (name.equals(WEB_SERVICE_CONTEXT_CLASS_NAME)) {
            return ThreadLocalAwareWebServiceContext.getInstance();
        }
        return super.resolveResource(injectionPoint);
    }

    public void cleanup() {
    }
}

