/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.SimpleInterceptorFactoryContext;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class BasicComponent
implements Component {
    private final String componentName;
    private final Class<?> componentClass;
    private final InterceptorFactory postConstruct;
    private final InterceptorFactory preDestroy;
    private final Map<Method, InterceptorFactory> interceptorFactoryMap;
    private final NamespaceContextSelector namespaceContextSelector;
    private final ServiceName createServiceName;
    private volatile boolean gate;
    private final AtomicBoolean stopping = new AtomicBoolean();
    private Interceptor postConstructInterceptor;
    private Interceptor preDestroyInterceptor;
    private Map<Method, Interceptor> interceptorInstanceMap;

    public BasicComponent(BasicComponentCreateService createService) {
        this.componentName = createService.getComponentName();
        this.componentClass = createService.getComponentClass();
        this.postConstruct = createService.getPostConstruct();
        this.preDestroy = createService.getPreDestroy();
        this.interceptorFactoryMap = createService.getComponentInterceptors();
        this.namespaceContextSelector = createService.getNamespaceContextSelector();
        this.createServiceName = createService.getServiceName();
    }

    @Override
    public ComponentInstance createInstance() {
        BasicComponentInstance instance = this.constructComponentInstance(null, true);
        return instance;
    }

    public ComponentInstance createInstance(Object instance) {
        BasicComponentInstance obj = this.constructComponentInstance(new ValueManagedReferenceFactory((Value)new ImmediateValue(instance)).getReference(), true);
        obj.constructionFinished();
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForComponentStart() {
        if (!this.gate) {
            BasicComponent basicComponent = this;
            synchronized (basicComponent) {
                if (this.stopping.get()) {
                    throw EeMessages.MESSAGES.componentIsStopped();
                }
                while (!this.gate) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw EeMessages.MESSAGES.componentNotAvailable();
                    }
                }
            }
        }
    }

    protected BasicComponentInstance constructComponentInstance(ManagedReference instance, boolean invokePostConstruct) {
        return this.constructComponentInstance(instance, invokePostConstruct, Collections.<Object, Object>emptyMap());
    }

    protected BasicComponentInstance constructComponentInstance(ManagedReference instance, boolean invokePostConstruct, Map<Object, Object> context) {
        this.waitForComponentStart();
        BasicComponentInstance basicComponentInstance = this.instantiateComponentInstance(this.preDestroyInterceptor, this.interceptorInstanceMap, context);
        if (instance != null) {
            basicComponentInstance.setInstanceData(BasicComponentInstance.INSTANCE_KEY, instance);
        }
        if (invokePostConstruct) {
            InterceptorContext interceptorContext = new InterceptorContext();
            interceptorContext.putPrivateData(Component.class, (Object)this);
            interceptorContext.putPrivateData(ComponentInstance.class, (Object)basicComponentInstance);
            interceptorContext.putPrivateData(InvocationType.class, (Object)InvocationType.POST_CONSTRUCT);
            interceptorContext.setContextData(new HashMap());
            try {
                this.postConstructInterceptor.processInvocation(interceptorContext);
            }
            catch (Exception e) {
                throw EeMessages.MESSAGES.componentConstructionFailure(e);
            }
        }
        this.componentInstanceCreated(basicComponentInstance);
        return basicComponentInstance;
    }

    protected void componentInstanceCreated(BasicComponentInstance basicComponentInstance) {
    }

    protected BasicComponentInstance instantiateComponentInstance(Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, Map<Object, Object> context) {
        return new BasicComponentInstance(this, preDestroyInterceptor, methodInterceptors);
    }

    @Override
    public Class<?> getComponentClass() {
        return this.componentClass;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public ServiceName getCreateServiceName() {
        return this.createServiceName;
    }

    @Override
    public synchronized void start() {
        SimpleInterceptorFactoryContext context = new SimpleInterceptorFactoryContext();
        context.getContextData().put(Component.class, this);
        this.createInterceptors((InterceptorFactoryContext)context);
        this.stopping.set(false);
        this.gate = true;
        this.notifyAll();
    }

    protected void createInterceptors(InterceptorFactoryContext context) {
        this.postConstructInterceptor = this.postConstruct.create(context);
        this.preDestroyInterceptor = this.getPreDestroy().create(context);
        Map<Method, InterceptorFactory> interceptorFactoryMap = this.getInterceptorFactoryMap();
        IdentityHashMap<Method, Interceptor> interceptorMap = new IdentityHashMap<Method, Interceptor>();
        for (Method method : interceptorFactoryMap.keySet()) {
            interceptorMap.put(method, interceptorFactoryMap.get(method).create(context));
        }
        this.interceptorInstanceMap = interceptorMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.stopping.compareAndSet(false, true)) {
            BasicComponent basicComponent = this;
            synchronized (basicComponent) {
                this.gate = false;
                this.interceptorInstanceMap = null;
                this.preDestroyInterceptor = null;
                this.postConstructInterceptor = null;
            }
        }
    }

    Map<Method, InterceptorFactory> getInterceptorFactoryMap() {
        return this.interceptorFactoryMap;
    }

    InterceptorFactory getPostConstruct() {
        return this.postConstruct;
    }

    InterceptorFactory getPreDestroy() {
        return this.preDestroy;
    }

    void finishDestroy() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.componentName;
    }

    @Override
    public NamespaceContextSelector getNamespaceContextSelector() {
        return this.namespaceContextSelector;
    }

    public static ServiceName serviceNameOf(ServiceName deploymentUnitServiceName, String componentName) {
        return deploymentUnitServiceName.append(new String[]{"component"}).append(new String[]{componentName});
    }
}

