/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.concurrent.CountDownLatch;

public final class StartupCountdown {
    private static final ThreadLocal<Boolean> isPrivileged = new ThreadLocal();
    private final CountDownLatch latch;

    public StartupCountdown(int count) {
        this.latch = new CountDownLatch(count);
    }

    public void countDown() {
        this.latch.countDown();
    }

    public void await() throws InterruptedException {
        if (Boolean.TRUE.equals(isPrivileged.get())) {
            return;
        }
        this.latch.await();
    }

    public void markAsPrivileged() {
        isPrivileged.set(Boolean.TRUE);
    }

    public void unmarkAsPrivileged() {
        isPrivileged.set(Boolean.FALSE);
    }
}

