/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class EJBClientDescriptor12Parser
implements XMLElementReader<EJBClientDescriptorMetaData> {
    public static final String NAMESPACE_1_2 = "urn:jboss:ejb-client:1.2";
    private final PropertyReplacer propertyReplacer;

    protected EJBClientDescriptor12Parser(PropertyReplacer propertyReplacer) {
        this.propertyReplacer = propertyReplacer;
    }

    public void readElement(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case CLIENT_CONTEXT: {
                            this.parseClientContext(reader, ejbClientDescriptorMetaData);
                            continue block7;
                        }
                    }
                    EJBClientDescriptor12Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor12Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private void parseClientContext(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case INVOCATION_TIMEOUT: {
                    Long invocationTimeout = Long.parseLong(value);
                    ejbClientDescriptorMetaData.setInvocationTimeout(invocationTimeout);
                    continue block12;
                }
                case DEPLOYMENT_NODE_SELECTOR: {
                    ejbClientDescriptorMetaData.setDeploymentNodeSelector(value);
                    continue block12;
                }
                default: {
                    EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (visited.contains((Object)element)) {
                        EJBClientDescriptor12Parser.unexpectedElement(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case EJB_RECEIVERS: {
                            this.parseEJBReceivers(reader, ejbClientDescriptorMetaData);
                            continue block13;
                        }
                        case CLUSTERS: {
                            this.parseClusters(reader, ejbClientDescriptorMetaData);
                            continue block13;
                        }
                    }
                    EJBClientDescriptor12Parser.unexpectedElement(reader);
                    continue block13;
                }
            }
            EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor12Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private void parseEJBReceivers(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        Boolean localReceiverPassByValue = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case EXCLUDE_LOCAL_RECEIVER: {
                    boolean excludeLocalReceiver = Boolean.parseBoolean(value);
                    ejbClientDescriptorMetaData.setExcludeLocalReceiver(excludeLocalReceiver);
                    continue block11;
                }
                case LOCAL_RECEIVER_PASS_BY_VALUE: {
                    localReceiverPassByValue = Boolean.parseBoolean(value);
                    continue block11;
                }
                default: {
                    EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        ejbClientDescriptorMetaData.setLocalReceiverPassByValue(localReceiverPassByValue);
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case REMOTING_EJB_RECEIVER: {
                            this.parseRemotingReceiver(reader, ejbClientDescriptorMetaData);
                            continue block12;
                        }
                    }
                    EJBClientDescriptor12Parser.unexpectedElement(reader);
                    continue block12;
                }
            }
            EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor12Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private void parseRemotingReceiver(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        String outboundConnectionRef = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.OUTBOUND_CONNECTION_REF);
        int count = reader.getAttributeCount();
        EJBClientDescriptorMetaData.RemotingReceiverConfiguration remotingReceiverConfiguration = null;
        long connectTimeout = 5000L;
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case OUTBOUND_CONNECTION_REF: {
                    outboundConnectionRef = value;
                    remotingReceiverConfiguration = ejbClientDescriptorMetaData.addRemotingReceiverConnectionRef(outboundConnectionRef);
                    continue block11;
                }
                case CONNECT_TIMEOUT: {
                    connectTimeout = Long.parseLong(value);
                    continue block11;
                }
                default: {
                    EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor12Parser.missingAttributes(reader.getLocation(), required);
        }
        remotingReceiverConfiguration.setConnectionTimeout(connectTimeout);
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case CHANNEL_CREATION_OPTIONS: {
                            Properties channelCreationOptions = this.parseChannelCreationOptions(reader);
                            remotingReceiverConfiguration.setChannelCreationOptions(channelCreationOptions);
                            continue block12;
                        }
                    }
                    EJBClientDescriptor12Parser.unexpectedElement(reader);
                    continue block12;
                }
            }
            EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor12Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private void parseClusters(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case CLUSTER: {
                            this.parseCluster(reader, ejbClientDescriptorMetaData);
                            continue block7;
                        }
                    }
                    EJBClientDescriptor12Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor12Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private void parseCluster(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        String clusterName = null;
        String clusterNodeSelector = null;
        long connectTimeout = 5000L;
        long maxAllowedConnectedNodes = 10L;
        String userName = null;
        String securityRealm = null;
        block17: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case NAME: {
                    clusterName = value;
                    continue block17;
                }
                case CONNECT_TIMEOUT: {
                    connectTimeout = Long.parseLong(value);
                    continue block17;
                }
                case CLUSTER_NODE_SELECTOR: {
                    clusterNodeSelector = value;
                    continue block17;
                }
                case MAX_ALLOWED_CONNECTED_NODES: {
                    maxAllowedConnectedNodes = Long.parseLong(value);
                    continue block17;
                }
                case USERNAME: {
                    userName = value;
                    continue block17;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block17;
                }
                default: {
                    EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor12Parser.missingAttributes(reader.getLocation(), required);
        }
        EJBClientDescriptorMetaData.ClusterConfig clusterConfig = ejbClientDescriptorMetaData.newClusterConfig(clusterName);
        clusterConfig.setConnectTimeout(connectTimeout);
        clusterConfig.setNodeSelector(clusterNodeSelector);
        clusterConfig.setMaxAllowedConnectedNodes(maxAllowedConnectedNodes);
        clusterConfig.setSecurityRealm(securityRealm);
        clusterConfig.setUserName(userName);
        block18: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case CONNECTION_CREATION_OPTIONS: {
                            Properties connectionCreationOptions = this.parseConnectionCreationOptions(reader);
                            clusterConfig.setConnectionOptions(connectionCreationOptions);
                            continue block18;
                        }
                        case CHANNEL_CREATION_OPTIONS: {
                            Properties channelCreationOptions = this.parseChannelCreationOptions(reader);
                            clusterConfig.setChannelCreationOptions(channelCreationOptions);
                            continue block18;
                        }
                        case NODE: {
                            this.parseClusterNode(reader, clusterConfig);
                            continue block18;
                        }
                    }
                    EJBClientDescriptor12Parser.unexpectedElement(reader);
                    continue block18;
                }
            }
            EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor12Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private Properties parseConnectionCreationOptions(XMLExtendedStreamReader reader) throws XMLStreamException {
        Properties connectionCreationOptions = new Properties();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return connectionCreationOptions;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PROPERTY: {
                            connectionCreationOptions.putAll((Map<?, ?>)this.parseProperty(reader));
                            continue block7;
                        }
                    }
                    EJBClientDescriptor12Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor12Parser.unexpectedEndOfDocument(reader.getLocation());
        return connectionCreationOptions;
    }

    private Properties parseChannelCreationOptions(XMLExtendedStreamReader reader) throws XMLStreamException {
        Properties channelCreationOptions = new Properties();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return channelCreationOptions;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PROPERTY: {
                            channelCreationOptions.putAll((Map<?, ?>)this.parseProperty(reader));
                            continue block7;
                        }
                    }
                    EJBClientDescriptor12Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor12Parser.unexpectedEndOfDocument(reader.getLocation());
        return channelCreationOptions;
    }

    private void parseClusterNode(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData.ClusterConfig clusterConfig) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        String nodeName = null;
        long connectTimeout = 5000L;
        String userName = null;
        String securityRealm = null;
        block14: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case NAME: {
                    nodeName = value;
                    continue block14;
                }
                case CONNECT_TIMEOUT: {
                    connectTimeout = Long.parseLong(value);
                    continue block14;
                }
                case USERNAME: {
                    userName = value;
                    continue block14;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block14;
                }
                default: {
                    EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor12Parser.missingAttributes(reader.getLocation(), required);
        }
        EJBClientDescriptorMetaData.ClusterNodeConfig clusterNodeConfig = clusterConfig.newClusterNode(nodeName);
        clusterNodeConfig.setConnectTimeout(connectTimeout);
        clusterNodeConfig.setSecurityRealm(securityRealm);
        clusterNodeConfig.setUserName(userName);
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case CONNECTION_CREATION_OPTIONS: {
                            Properties connectionCreationOptions = this.parseConnectionCreationOptions(reader);
                            clusterNodeConfig.setConnectionOptions(connectionCreationOptions);
                            continue block15;
                        }
                        case CHANNEL_CREATION_OPTIONS: {
                            Properties channelCreationOptions = this.parseChannelCreationOptions(reader);
                            clusterNodeConfig.setChannelCreationOptions(channelCreationOptions);
                            continue block15;
                        }
                    }
                    EJBClientDescriptor12Parser.unexpectedElement(reader);
                    continue block15;
                }
            }
            EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor12Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private Properties parseProperty(XMLExtendedStreamReader reader) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        String name = null;
        String value = null;
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String val = this.readResolveValue(reader, i);
            switch (attribute) {
                case NAME: {
                    name = val;
                    continue block4;
                }
                case VALUE: {
                    value = val;
                    continue block4;
                }
                default: {
                    EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor12Parser.missingAttributes(reader.getLocation(), required);
        }
        EJBClientDescriptor12Parser.requireNoContent(reader);
        Properties property = new Properties();
        property.put(name, value);
        return property;
    }

    protected String readResolveValue(XMLExtendedStreamReader reader, int index) {
        return this.propertyReplacer.replaceProperties(reader.getAttributeValue(index).trim());
    }

    private static void unexpectedEndOfDocument(Location location) throws XMLStreamException {
        throw EeMessages.MESSAGES.errorParsingEJBClientDescriptor("Unexpected end of document", location);
    }

    private static void missingAttributes(Location location, Set<Attribute> required) throws XMLStreamException {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        throw EeMessages.MESSAGES.errorParsingEJBClientDescriptor(b.toString(), location);
    }

    public static void requireNoContent(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.hasNext() && reader.nextTag() != 2) {
            EJBClientDescriptor12Parser.unexpectedElement(reader);
        }
    }

    public static void unexpectedElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        throw EeMessages.MESSAGES.unexpectedElement(reader.getName(), reader.getLocation());
    }

    private static void unexpectedContent(XMLStreamReader reader) throws XMLStreamException {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        throw EeMessages.MESSAGES.errorParsingEJBClientDescriptor(b.toString(), reader.getLocation());
    }

    static enum Attribute {
        EXCLUDE_LOCAL_RECEIVER,
        LOCAL_RECEIVER_PASS_BY_VALUE,
        CONNECT_TIMEOUT,
        NAME,
        OUTBOUND_CONNECTION_REF,
        VALUE,
        MAX_ALLOWED_CONNECTED_NODES,
        CLUSTER_NODE_SELECTOR,
        USERNAME,
        SECURITY_REALM,
        INVOCATION_TIMEOUT,
        DEPLOYMENT_NODE_SELECTOR,
        UNKNOWN;

        private static final Map<QName, Attribute> attributes;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName("exclude-local-receiver"), EXCLUDE_LOCAL_RECEIVER);
            attributesMap.put(new QName("local-receiver-pass-by-value"), LOCAL_RECEIVER_PASS_BY_VALUE);
            attributesMap.put(new QName("name"), NAME);
            attributesMap.put(new QName("value"), VALUE);
            attributesMap.put(new QName("outbound-connection-ref"), OUTBOUND_CONNECTION_REF);
            attributesMap.put(new QName("connect-timeout"), CONNECT_TIMEOUT);
            attributesMap.put(new QName("max-allowed-connected-nodes"), MAX_ALLOWED_CONNECTED_NODES);
            attributesMap.put(new QName("cluster-node-selector"), CLUSTER_NODE_SELECTOR);
            attributesMap.put(new QName("username"), USERNAME);
            attributesMap.put(new QName("security-realm"), SECURITY_REALM);
            attributesMap.put(new QName("invocation-timeout"), INVOCATION_TIMEOUT);
            attributesMap.put(new QName("deployment-node-selector"), DEPLOYMENT_NODE_SELECTOR);
            attributes = attributesMap;
        }
    }

    static enum Element {
        CLIENT_CONTEXT,
        NODE,
        EJB_RECEIVERS,
        JBOSS_EJB_CLIENT,
        REMOTING_EJB_RECEIVER,
        CLUSTERS,
        CLUSTER,
        CHANNEL_CREATION_OPTIONS,
        CONNECTION_CREATION_OPTIONS,
        PROPERTY,
        UNKNOWN;

        private static final Map<QName, Element> elements;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(EJBClientDescriptor12Parser.NAMESPACE_1_2, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(EJBClientDescriptor12Parser.NAMESPACE_1_2, "jboss-ejb-client"), JBOSS_EJB_CLIENT);
            elementsMap.put(new QName(EJBClientDescriptor12Parser.NAMESPACE_1_2, "client-context"), CLIENT_CONTEXT);
            elementsMap.put(new QName(EJBClientDescriptor12Parser.NAMESPACE_1_2, "ejb-receivers"), EJB_RECEIVERS);
            elementsMap.put(new QName(EJBClientDescriptor12Parser.NAMESPACE_1_2, "remoting-ejb-receiver"), REMOTING_EJB_RECEIVER);
            elementsMap.put(new QName(EJBClientDescriptor12Parser.NAMESPACE_1_2, "clusters"), CLUSTERS);
            elementsMap.put(new QName(EJBClientDescriptor12Parser.NAMESPACE_1_2, "cluster"), CLUSTER);
            elementsMap.put(new QName(EJBClientDescriptor12Parser.NAMESPACE_1_2, "node"), NODE);
            elementsMap.put(new QName(EJBClientDescriptor12Parser.NAMESPACE_1_2, "channel-creation-options"), CHANNEL_CREATION_OPTIONS);
            elementsMap.put(new QName(EJBClientDescriptor12Parser.NAMESPACE_1_2, "connection-creation-options"), CONNECTION_CREATION_OPTIONS);
            elementsMap.put(new QName(EJBClientDescriptor12Parser.NAMESPACE_1_2, "property"), PROPERTY);
            elements = elementsMap;
        }
    }
}

