/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

public class ServerDependenciesProcessor
implements DeploymentUnitProcessor {
    private static ModuleIdentifier[] DEFAULT_MODULES = new ModuleIdentifier[]{ModuleIdentifier.create((String)"sun.jdk"), ModuleIdentifier.create((String)"ibm.jdk"), ModuleIdentifier.create((String)"javax.api"), ModuleIdentifier.create((String)"org.jboss.vfs")};

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        for (ModuleIdentifier moduleId : DEFAULT_MODULES) {
            try {
                moduleLoader.loadModule(moduleId);
                boolean importServices = moduleId.getName().endsWith("jdk");
                moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleId, false, false, importServices, false));
            }
            catch (ModuleLoadException ex) {
                ServerLogger.ROOT_LOGGER.debugf("Module not found: %s", moduleId);
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

