/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayContentAdd;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayContentRemove;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayModel;
import org.jboss.as.server.deploymentoverlay.ReadContentHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentOverlayContentDefinition
extends SimpleResourceDefinition {
    public static final ContentAttributeDefinition CONTENT = new ContentAttributeDefinition("content", ModelType.BYTES, false);
    private final ContentRepository contentRepository;
    private final SimpleOperationDefinition readContent;
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CONTENT};

    public static AttributeDefinition[] attributes() {
        return (AttributeDefinition[])ATTRIBUTES.clone();
    }

    public DeploymentOverlayContentDefinition(ContentRepository contentRepository, DeploymentFileRepository remoteRepository) {
        super(DeploymentOverlayModel.CONTENT_PATH, ControllerResolver.getResolver((String[])new String[]{"deployment-overlay", "content"}), (OperationStepHandler)new DeploymentOverlayContentAdd(contentRepository, remoteRepository), (OperationStepHandler)new DeploymentOverlayContentRemove(contentRepository));
        this.contentRepository = contentRepository;
        this.readContent = new SimpleOperationDefinition("read-content", this.getResourceDescriptionResolver());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadOnlyAttribute(attr, null);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        ReadContentHandler handler = new ReadContentHandler(this.contentRepository);
        resourceRegistration.registerOperationHandler((OperationDefinition)this.readContent, (OperationStepHandler)handler);
    }

    public static final class ContentAttributeDefinition
    extends SimpleAttributeDefinition {
        private ContentAttributeDefinition(String name, ModelType type, boolean allowNull) {
            super(name, type, allowNull);
        }

        public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle2);
            this.addOperationParameterValueTypeDescription(result, operationName, resolver, locale, bundle2);
            return result;
        }

        private void addOperationParameterValueTypeDescription(ModelNode result, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            ModelNode valueType = this.getNoTextValueTypeDescription(result);
            result.get("type").set(ModelType.OBJECT);
            valueType.get(new String[]{"input-stream-index", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"input-stream-index"}));
            valueType.get(new String[]{"hash", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"hash"}));
            valueType.get(new String[]{"bytes", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"bytes"}));
            valueType.get(new String[]{"url", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"url"}));
        }

        private ModelNode getNoTextValueTypeDescription(ModelNode parent) {
            ModelNode valueType = parent.get("value-type");
            ModelNode inputStreamIndex = valueType.get("input-stream-index");
            inputStreamIndex.get("type").set(ModelType.INT);
            inputStreamIndex.get("description");
            inputStreamIndex.get("required").set(false);
            inputStreamIndex.get("min").set(0);
            inputStreamIndex.get("nillable").set(true);
            ModelNode hash = valueType.get("hash");
            hash.get("type").set(ModelType.BYTES);
            hash.get("description");
            hash.get("required").set(false);
            hash.get("min-length").set(20);
            hash.get("max-length").set(20);
            hash.get("nillable").set(true);
            ModelNode bytes = valueType.get("bytes");
            bytes.get("type").set(ModelType.BYTES);
            bytes.get("description");
            bytes.get("required").set(false);
            bytes.get("min-length").set(1);
            bytes.get("nillable").set(true);
            ModelNode url = valueType.get("url");
            url.get("type").set(ModelType.STRING);
            url.get("description");
            url.get("required").set(false);
            url.get("min-length").set(1);
            url.get("nillable").set(true);
            return valueType;
        }
    }
}

