/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.remote.ResponseAttachmentInputStreamSupport;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.mgmt.domain.HostControllerClient;
import org.jboss.as.server.mgmt.domain.HostControllerConnection;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;

public class HostControllerConnectionService
implements Service<HostControllerClient> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "client"});
    private static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    private static final long SERVER_CONNECTION_TIMEOUT = 60000L;
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> scheduledExecutorInjector = new InjectedValue();
    private final InjectedValue<Endpoint> endpointInjector = new InjectedValue();
    private final InjectedValue<ControlledProcessStateService> processStateServiceInjectedValue = new InjectedValue();
    private final int port;
    private final String hostName;
    private final String serverName;
    private final String userName;
    private final String serverProcessName;
    private final byte[] initialAuthKey;
    private final int initialOperationID;
    private final boolean managementSubsystemEndpoint;
    private volatile ResponseAttachmentInputStreamSupport responseAttachmentSupport;
    private HostControllerClient client;

    public HostControllerConnectionService(String hostName, int port, String serverName, String serverProcessName, byte[] authKey, int initialOperationID, boolean managementSubsystemEndpoint) {
        this.port = port;
        this.hostName = hostName;
        this.serverName = serverName;
        this.userName = "=" + serverName;
        this.serverProcessName = serverProcessName;
        this.initialAuthKey = authKey;
        this.initialOperationID = initialOperationID;
        this.managementSubsystemEndpoint = managementSubsystemEndpoint;
    }

    public synchronized void start(StartContext context) throws StartException {
        Endpoint endpoint = (Endpoint)this.endpointInjector.getValue();
        try {
            URI connectionURI = new URI("remote://" + NetworkUtils.formatPossibleIpv6Address((String)this.hostName) + ":" + this.port);
            OptionMap options = OptionMap.create((Option)Options.SASL_DISALLOWED_MECHANISMS, (Object)Sequence.of((Object[])new String[]{JBOSS_LOCAL_USER}));
            ProtocolConnectionConfiguration configuration = ProtocolConnectionConfiguration.create((Endpoint)endpoint, (URI)connectionURI, (OptionMap)options);
            configuration.setCallbackHandler(HostControllerConnection.createClientCallbackHandler(this.userName, this.initialAuthKey));
            configuration.setConnectionTimeout(60000L);
            configuration.setSslContext(HostControllerConnectionService.getAcceptingSSLContext());
            this.responseAttachmentSupport = new ResponseAttachmentInputStreamSupport((ScheduledExecutorService)this.scheduledExecutorInjector.getValue());
            final HostControllerConnection connection = new HostControllerConnection(this.serverProcessName, this.userName, this.initialOperationID, configuration, this.responseAttachmentSupport, (ExecutorService)this.executorInjector.getValue());
            ControlledProcessStateService processService = (ControlledProcessStateService)this.processStateServiceInjectedValue.getValue();
            processService.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ControlledProcessState.State current = (ControlledProcessState.State)evt.getNewValue();
                    if (current == ControlledProcessState.State.RUNNING) {
                        connection.started();
                    }
                }
            });
            this.client = new HostControllerClient(this.serverName, connection.getChannelHandler(), connection, this.managementSubsystemEndpoint);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext stopContext) {
        ExecutorService executorService = (ExecutorService)this.executorInjector.getValue();
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HostControllerConnectionService.this.responseAttachmentSupport.shutdown();
                }
                finally {
                    StreamUtils.safeClose((Closeable)HostControllerConnectionService.this.client);
                    HostControllerConnectionService.this.client = null;
                    stopContext.complete();
                }
            }
        };
        try {
            executorService.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            stopContext.asynchronous();
        }
    }

    public synchronized HostControllerClient getValue() throws IllegalStateException, IllegalArgumentException {
        HostControllerClient client = this.client;
        if (client == null) {
            throw new IllegalStateException();
        }
        return client;
    }

    public InjectedValue<ControlledProcessStateService> getProcessStateServiceInjectedValue() {
        return this.processStateServiceInjectedValue;
    }

    public InjectedValue<Endpoint> getEndpointInjector() {
        return this.endpointInjector;
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executorInjector;
    }

    public InjectedValue<ScheduledExecutorService> getScheduledExecutorInjector() {
        return this.scheduledExecutorInjector;
    }

    private static SSLContext getAcceptingSSLContext() throws IOException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            sslContext.init(null, trustManagers, null);
            return sslContext;
        }
        catch (GeneralSecurityException e) {
            throw ServerMessages.MESSAGES.unableToInitialiseSSLContext(e.getMessage());
        }
    }
}

