/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.repository.LocalDeploymentFileRepository;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.mgmt.domain.CompositeContentRepository;
import org.jboss.as.server.mgmt.domain.HostControllerClient;
import org.jboss.as.server.mgmt.domain.HostControllerConnectionService;
import org.jboss.as.server.mgmt.domain.RemoteFileRepositoryExecutor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.vfs.VirtualFile;

public class RemoteFileRepositoryService
implements CompositeContentRepository,
Service<CompositeContentRepository> {
    private final InjectedValue<HostControllerClient> clientInjectedValue = new InjectedValue();
    private final File localDeploymentFolder;
    private final DeploymentFileRepository localRepository;
    private final ContentRepository contentRepository;
    private volatile RemoteFileRepositoryExecutor remoteFileRepositoryExecutor;

    public static void addService(ServiceTarget target, File localDeploymentContentsFolder) {
        RemoteFileRepositoryService service = new RemoteFileRepositoryService(localDeploymentContentsFolder);
        target.addService(ContentRepository.SERVICE_NAME, (Service)service).addDependency(HostControllerConnectionService.SERVICE_NAME, HostControllerClient.class, service.clientInjectedValue).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    RemoteFileRepositoryService(File localDeploymentFolder) {
        this.localDeploymentFolder = localDeploymentFolder;
        this.contentRepository = ContentRepository.Factory.create((File)localDeploymentFolder);
        this.localRepository = new LocalDeploymentFileRepository(localDeploymentFolder);
    }

    public void start(StartContext context) throws StartException {
        HostControllerClient client = (HostControllerClient)this.clientInjectedValue.getValue();
        this.remoteFileRepositoryExecutor = client.getRemoteFileRepository();
    }

    public void stop(StopContext context) {
        this.remoteFileRepositoryExecutor = null;
    }

    public CompositeContentRepository getValue() throws IllegalStateException, IllegalArgumentException {
        RemoteFileRepositoryExecutor executor = this.remoteFileRepositoryExecutor;
        if (executor == null) {
            throw ServerMessages.MESSAGES.couldNotFindHcFileRepositoryConnection();
        }
        return this;
    }

    public byte[] addContent(InputStream stream) throws IOException {
        return this.contentRepository.addContent(stream);
    }

    public VirtualFile getContent(byte[] hash) {
        return this.contentRepository.getContent(hash);
    }

    public boolean syncContent(ContentReference reference) {
        if (!this.contentRepository.hasContent(reference.getHash())) {
            this.getDeploymentFiles(reference);
        }
        return this.contentRepository.hasContent(reference.getHash());
    }

    public boolean hasContent(byte[] hash) {
        return this.contentRepository.hasContent(hash);
    }

    public void removeContent(ContentReference reference) {
        this.contentRepository.removeContent(reference);
    }

    public final File[] getDeploymentFiles(ContentReference reference) {
        File root = this.getDeploymentRoot(reference);
        return root.listFiles();
    }

    public File getDeploymentRoot(ContentReference reference) {
        File file = this.localRepository.getDeploymentRoot(reference);
        if (!file.exists()) {
            return this.getFile(reference, (byte)40);
        }
        return file;
    }

    private File getFile(ContentReference reference, byte repoId) {
        RemoteFileRepositoryExecutor executor = this.remoteFileRepositoryExecutor;
        if (executor == null) {
            throw ServerMessages.MESSAGES.couldNotFindHcFileRepositoryConnection();
        }
        File file = this.remoteFileRepositoryExecutor.getFile(reference.getHexHash(), repoId, this.localDeploymentFolder);
        this.addContentReference(reference);
        return file;
    }

    public void deleteDeployment(ContentReference reference) {
        if (this.hasContent(reference.getHash())) {
            this.removeContent(reference);
        } else {
            this.localRepository.deleteDeployment(reference);
            this.removeContent(reference);
        }
    }

    public void addContentReference(ContentReference reference) {
        this.contentRepository.addContentReference(reference);
    }

    public Map<String, Set<String>> cleanObsoleteContent() {
        return this.contentRepository.cleanObsoleteContent();
    }
}

