/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.controller.AccessAuditContext;

class SecurityActions {
    SecurityActions() {
    }

    static AccessAuditContext currentAccessAuditContext() {
        return SecurityActions.createAccessAuditContextActions().currentContext();
    }

    private static AccessAuditContextActions createAccessAuditContextActions() {
        return System.getSecurityManager() != null ? AccessAuditContextActions.PRIVILEGED : AccessAuditContextActions.NON_PRIVILEGED;
    }

    private static interface AccessAuditContextActions {
        public static final AccessAuditContextActions NON_PRIVILEGED = new AccessAuditContextActions(){

            @Override
            public AccessAuditContext currentContext() {
                return AccessAuditContext.currentAccessAuditContext();
            }
        };
        public static final AccessAuditContextActions PRIVILEGED = new AccessAuditContextActions(){
            private final PrivilegedAction<AccessAuditContext> PRIVILEGED_ACTION = new PrivilegedAction<AccessAuditContext>(){

                @Override
                public AccessAuditContext run() {
                    return NON_PRIVILEGED.currentContext();
                }
            };

            @Override
            public AccessAuditContext currentContext() {
                return AccessController.doPrivileged(this.PRIVILEGED_ACTION);
            }
        };

        public AccessAuditContext currentContext();
    }
}

