/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.NoSuchResourceException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.dmr.ModelNode;

public abstract class DeploymentRemoveHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "remove";

    private DeploymentRemoveHandler() {
    }

    public static DeploymentRemoveHandler createForSlave(DeploymentFileRepository fileRepository, ContentRepository contentRepository) {
        return new SlaveDeploymentRemoveHandler(fileRepository, contentRepository);
    }

    public static DeploymentRemoveHandler createForMaster(ContentRepository contentRepository) {
        return new MasterDeploymentRemoveHandler(contentRepository);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.checkCanRemove(context, operation);
        final PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        final List deploymentHashes = DeploymentUtils.getDeploymentHash((Resource)resource);
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        if (resultAction != OperationContext.ResultAction.ROLLBACK) {
                            Set newHashes;
                            try {
                                newHashes = DeploymentUtils.getDeploymentHexHash((ModelNode)context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel());
                            }
                            catch (NoSuchResourceException ex) {
                                newHashes = Collections.EMPTY_SET;
                            }
                            DeploymentRemoveHandler.this.removeContent(address, newHashes, deploymentHashes);
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }

    protected void checkCanRemove(OperationContext context, ModelNode operation) throws OperationFailedException {
        String deploymentName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        if (root.hasChild(PathElement.pathElement((String)"server-group"))) {
            ArrayList<String> badGroups = new ArrayList<String>();
            for (Resource.ResourceEntry entry : root.getChildren("server-group")) {
                if (!entry.hasChild(PathElement.pathElement((String)"deployment", (String)deploymentName))) continue;
                badGroups.add(entry.getName());
            }
            if (badGroups.size() > 0) {
                throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.cannotRemoveDeploymentInUse(deploymentName, badGroups)));
            }
        }
    }

    abstract void removeContent(PathAddress var1, Set<String> var2, List<byte[]> var3);

    private static class SlaveDeploymentRemoveHandler
    extends DeploymentRemoveHandler {
        final DeploymentFileRepository fileRepository;
        final ContentRepository contentRepository;

        private SlaveDeploymentRemoveHandler(DeploymentFileRepository fileRepository, ContentRepository contentRepository) {
            assert (fileRepository != null) : "Null fileRepository";
            assert (contentRepository != null) : "Null contentRepository";
            this.fileRepository = fileRepository;
            this.contentRepository = contentRepository;
        }

        @Override
        void removeContent(PathAddress address, Set<String> newHashes, List<byte[]> hashes) {
            for (byte[] hash : hashes) {
                try {
                    if (this.contentRepository.hasContent(hash)) {
                        this.contentRepository.removeContent(ModelContentReference.fromModelAddress((PathAddress)address, (byte[])hash));
                        continue;
                    }
                    if (newHashes.isEmpty() || !newHashes.contains(HashUtil.bytesToHexString((byte[])hash))) {
                        this.fileRepository.deleteDeployment(ModelContentReference.fromModelAddress((PathAddress)address, (byte[])hash));
                        continue;
                    }
                    DomainControllerLogger.DEPLOYMENT_LOGGER.undeployingDeploymentHasBeenRedeployed(address.getLastElement().getValue());
                }
                catch (Exception e) {
                    DomainControllerLogger.DEPLOYMENT_LOGGER.debugf(e, "Exception occurred removing %s", Arrays.asList(new byte[][]{hash}));
                }
            }
        }
    }

    private static class MasterDeploymentRemoveHandler
    extends DeploymentRemoveHandler {
        final ContentRepository contentRepository;

        private MasterDeploymentRemoveHandler(ContentRepository contentRepository) {
            assert (contentRepository != null) : "Null contentRepository";
            this.contentRepository = contentRepository;
        }

        @Override
        void removeContent(PathAddress address, Set<String> newHashes, List<byte[]> hashes) {
            for (byte[] hash : hashes) {
                try {
                    if (this.contentRepository != null && (newHashes.isEmpty() || !newHashes.contains(HashUtil.bytesToHexString((byte[])hash)))) {
                        this.contentRepository.removeContent(ModelContentReference.fromModelAddress((PathAddress)address, (byte[])hash));
                        continue;
                    }
                    if (this.contentRepository == null) continue;
                    DomainControllerLogger.DEPLOYMENT_LOGGER.undeployingDeploymentHasBeenRedeployed(address.getLastElement().getValue());
                }
                catch (Exception e) {
                    DomainControllerLogger.DEPLOYMENT_LOGGER.debugf(e, "Exception occurred removing %s", Arrays.asList(new byte[][]{hash}));
                }
            }
        }
    }
}

