/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;

class SecurityActions {
    private SecurityActions() {
    }

    static Subject getCurrentSubject() {
        AccessControlContext acc = AccessController.getContext();
        return SecurityActions.subjectActions().getCurrentSubject(acc);
    }

    static SubjectActions subjectActions() {
        return System.getSecurityManager() != null ? SubjectActions.PRIVILEGED : SubjectActions.NON_PRIVILEGED;
    }

    private static interface SubjectActions {
        public static final SubjectActions NON_PRIVILEGED = new SubjectActions(){

            @Override
            public Subject getCurrentSubject(AccessControlContext acc) {
                return Subject.getSubject(acc);
            }
        };
        public static final SubjectActions PRIVILEGED = new SubjectActions(){

            @Override
            public Subject getCurrentSubject(final AccessControlContext acc) {
                return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

                    @Override
                    public Subject run() {
                        return NON_PRIVILEGED.getCurrentSubject(acc);
                    }
                });
            }
        };

        public Subject getCurrentSubject(AccessControlContext var1);
    }
}

