/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.DomainModelControllerService;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.jmx.RemotingConnectorService;
import org.jboss.as.host.controller.mgmt.ServerToHostOperationHandlerFactoryService;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.resources.NativeManagementResourceDefinition;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.RemotingOptions;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class NativeManagementAddHandler
extends AbstractAddStepHandler {
    private static final int heartbeatInterval = 15000;
    public static final String OPERATION_NAME = "add";
    private static final int WINDOW_SIZE = 32768;
    private static final OptionMap SERVICE_OPTIONS = OptionMap.create((Option)RemotingOptions.TRANSMIT_WINDOW_SIZE, (Object)32768, (Option)RemotingOptions.RECEIVE_WINDOW_SIZE, (Object)32768);
    private static final OptionMap CONNECTION_OPTIONS = OptionMap.create((Option)RemotingOptions.HEARTBEAT_INTERVAL, (Object)15000, (Option)Options.READ_TIMEOUT, (Object)45000);
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public NativeManagementAddHandler(LocalHostControllerInfoImpl hostControllerInfo) {
        this.hostControllerInfo = hostControllerInfo;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : NativeManagementResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            attr.validateAndSet(operation, model);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        NativeManagementAddHandler.populateHostControllerInfo(this.hostControllerInfo, context, model);
        ServiceTarget serviceTarget = context.getServiceTarget();
        ManagementChannelRegistryService.addService((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT);
        ManagementRemotingServices.installRemotingEndpoint((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (String)this.hostControllerInfo.getLocalHostName(), (EndpointService.EndpointType)EndpointService.EndpointType.MANAGEMENT, (OptionMap)CONNECTION_OPTIONS, null, null);
        boolean onDemand = context.isBooting();
        OptionMap connectionOptions = NativeManagementAddHandler.createConnectorOptions(context, model);
        NativeManagementAddHandler.installNativeManagementServices(serviceTarget, this.hostControllerInfo, verificationHandler, newControllers, onDemand, connectionOptions);
    }

    static void populateHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo, OperationContext context, ModelNode model) throws OperationFailedException {
        hostControllerInfo.setNativeManagementInterface(NativeManagementResourceDefinition.INTERFACE.resolveModelAttribute(context, model).asString());
        ModelNode portNode = NativeManagementResourceDefinition.NATIVE_PORT.resolveModelAttribute(context, model);
        hostControllerInfo.setNativeManagementPort(portNode.isDefined() ? portNode.asInt() : -1);
        ModelNode realmNode = NativeManagementResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        hostControllerInfo.setNativeManagementSecurityRealm(realmNode.isDefined() ? realmNode.asString() : null);
    }

    public static void installNativeManagementServices(ServiceTarget serviceTarget, LocalHostControllerInfo hostControllerInfo, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, boolean onDemand, OptionMap connectionOptions) {
        String nativeSecurityRealm = hostControllerInfo.getNativeManagementSecurityRealm();
        ServiceName nativeManagementInterfaceBinding = NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{hostControllerInfo.getNativeManagementInterface()});
        ManagementRemotingServices.installDomainConnectorServices((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (ServiceName)nativeManagementInterfaceBinding, (int)hostControllerInfo.getNativeManagementPort(), (String)nativeSecurityRealm, (OptionMap)connectionOptions, (ServiceVerificationHandler)verificationHandler, newControllers);
        ManagementRemotingServices.installManagementChannelOpenListenerService((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (String)"server", (ServiceName)ServerToHostOperationHandlerFactoryService.SERVICE_NAME, (OptionMap)SERVICE_OPTIONS, (ServiceVerificationHandler)verificationHandler, newControllers, (boolean)onDemand);
        ManagementRemotingServices.installManagementChannelServices((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (AbstractModelControllerOperationHandlerFactoryService)new ModelControllerClientOperationHandlerFactoryService(), (ServiceName)DomainModelControllerService.SERVICE_NAME, (String)"management", (ServiceName)HostControllerService.HC_EXECUTOR_SERVICE_NAME, (ServiceName)HostControllerService.HC_SCHEDULED_EXECUTOR_SERVICE_NAME, (ServiceVerificationHandler)verificationHandler, newControllers);
        RemotingConnectorService.addService(serviceTarget, verificationHandler);
    }

    private static OptionMap createConnectorOptions(OperationContext context, ModelNode model) throws OperationFailedException {
        OptionMap.Builder builder = OptionMap.builder();
        builder.addAll(CONNECTION_OPTIONS);
        builder.set(RemotingOptions.SASL_PROTOCOL, (Object)NativeManagementResourceDefinition.SASL_PROTOCOL.resolveModelAttribute(context, model).asString());
        ModelNode serverName = NativeManagementResourceDefinition.SERVER_NAME.resolveModelAttribute(context, model);
        if (serverName.isDefined()) {
            builder.set(RemotingOptions.SERVER_NAME, (Object)serverName.asString());
        }
        return builder.getMap();
    }
}

