/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra.processors;

import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.services.resourceadapters.deployment.InactiveResourceAdapterDeploymentService;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.connector.util.RaServicesFactory;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class RaXmlDeploymentProcessor
implements DeploymentUnitProcessor {
    private final MetadataRepository mdr;

    public RaXmlDeploymentProcessor(MetadataRepository mdr) {
        this.mdr = mdr;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ManagementResourceRegistration baseRegistration = (ManagementResourceRegistration)deploymentUnit.getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT);
        Resource deploymentResource = (Resource)phaseContext.getDeploymentUnit().getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
        ConnectorXmlDescriptor connectorXmlDescriptor = (ConnectorXmlDescriptor)deploymentUnit.getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY);
        if (connectorXmlDescriptor == null) {
            return;
        }
        ManagementResourceRegistration registration = deploymentUnit.getParent() != null ? baseRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subdeployment")})) : baseRegistration;
        ResourceAdaptersService.ModifiableResourceAdaptors raxmls = null;
        ServiceController raService = phaseContext.getServiceRegistry().getService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
        if (raService != null) {
            raxmls = (ResourceAdaptersService.ModifiableResourceAdaptors)raService.getValue();
        }
        ConnectorLogger.ROOT_LOGGER.tracef("processing Raxml", new Object[0]);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw ConnectorMessages.MESSAGES.failedToGetModuleAttachment(deploymentUnit);
        }
        try {
            String deploymentUnitName;
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            String deploymentUnitPrefix = "";
            if (deploymentUnit.getParent() != null) {
                deploymentUnitPrefix = deploymentUnit.getParent().getName() + "#";
            }
            String deployment = (deploymentUnitName = deploymentUnitPrefix + deploymentUnit.getName()).lastIndexOf(46) == -1 ? deploymentUnitName : deploymentUnitName.substring(0, deploymentUnitName.lastIndexOf(46));
            if (raxmls != null) {
                for (ResourceAdapter raxml : raxmls.getResourceAdapters()) {
                    String rarName = raxml.getArchive();
                    if (!deploymentUnitName.equals(rarName)) continue;
                    RaServicesFactory.createDeploymentService(registration, connectorXmlDescriptor, module, serviceTarget, deploymentUnitName, deploymentUnit.getServiceName(), deployment, raxml, deploymentResource, null);
                }
            }
            ServiceName serviceName = ConnectorServices.INACTIVE_RESOURCE_ADAPTER_SERVICE.append(new String[]{deploymentUnitName});
            InactiveResourceAdapterDeploymentService service = new InactiveResourceAdapterDeploymentService(connectorXmlDescriptor, module, deployment, deploymentUnitName, deploymentUnit.getServiceName(), registration, serviceTarget, deploymentResource);
            ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
            builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException(t);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

