/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.logging;

import java.sql.Driver;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.ServiceName;

@MessageLogger(projectCode="JBAS")
public interface ConnectorLogger
extends BasicLogger {
    public static final ConnectorLogger ROOT_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)ConnectorLogger.class.getPackage().getName());
    public static final ConnectorLogger DEPLOYER_JDBC_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployers.jdbc");
    public static final ConnectorLogger DEPLOYMENT_CONNECTOR_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployment");
    public static final ConnectorLogger DEPLOYMENT_CONNECTOR_REGISTRY_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployment.registry");
    public static final ConnectorLogger DS_DEPLOYER_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployer.dsdeployer");
    public static final ConnectorLogger MDR_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.services.mdr");
    public static final ConnectorLogger SUBSYSTEM_DATASOURCES_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.subsystems.datasources");
    public static final ConnectorLogger SUBSYSTEM_RA_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.subsystems.resourceadapters");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10400, value="Bound data source [%s]")
    public void boundDataSource(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10401, value="Bound JCA %s [%s]")
    public void boundJca(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10402, value="Unable to instantiate driver class \"%s\": %s")
    public void cannotInstantiateDriverClass(String var1, Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10403, value="Deploying JDBC-compliant driver %s (version %d.%d)")
    public void deployingCompliantJdbcDriver(Class<? extends Driver> var1, int var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10404, value="Deploying non-JDBC-compliant driver %s (version %d.%d)")
    public void deployingNonCompliantJdbcDriver(Class<? extends Driver> var1, int var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10405, value="Registered admin object at %s")
    public void registeredAdminObject(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10406, value="Registered connection factory %s")
    public void registeredConnectionFactory(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10407, value="Starting service %s")
    public void startingService(ServiceName var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10408, value="Starting %s Subsystem (%s)")
    public void startingSubsystem(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10409, value="Unbound data source [%s]")
    public void unboundDataSource(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10410, value="Unbound JCA %s [%s]")
    public void unboundJca(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10411, value="<drivers/> in standalone -ds.xml deployments aren't supported: Ignoring %s")
    public void driversElementNotSupported(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10415, value="Method %s on DataSource class %s not found. Ignoring")
    public void methodNotFoundOnDataSource(String var1, Class<?> var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10416, value="Forcing ironjacamar.xml descriptor to null")
    public void forceIJToNull();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10429, value="Unable to register recovery: %s (%s)")
    public void unableToRegisterRecovery(String var1, boolean var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10487, value="Unable to find driver class name in \"%s\" jar")
    public void cannotFindDriverClassName(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10489, value="-ds.xml file deployments are deprecated. Support may be removed in a future version.")
    public void deprecated();
}

