/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.h2.command.Prepared;
import org.h2.command.dml.ScriptBase;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.util.ScriptReader;

public class RunScriptCommand
extends ScriptBase {
    private String charset = "UTF8";

    public RunScriptCommand(Session session) {
        super(session);
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        int count = 0;
        try {
            String sql;
            this.openInput();
            InputStreamReader reader = new InputStreamReader(this.in, this.charset);
            ScriptReader r = new ScriptReader(reader);
            while ((sql = r.readStatement()) != null) {
                this.execute(sql);
                if ((++count & 0x7F) != 0) continue;
                this.checkCanceled();
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
        finally {
            this.closeIO();
        }
        return count;
    }

    private void execute(String sql) {
        try {
            Prepared command = this.session.prepare(sql);
            if (command.isQuery()) {
                command.query(0);
            } else {
                command.update();
            }
            if (this.session.getAutoCommit()) {
                this.session.commit(false);
            }
        }
        catch (DbException e) {
            throw e.addSQL(sql);
        }
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 64;
    }
}

