/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.h2.command.Parser;
import org.h2.command.dml.ScriptBase;
import org.h2.command.dml.SetTypes;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.Database;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueString;

public class ScriptCommand
extends ScriptBase {
    private String charset = "UTF8";
    private Set<String> schemaNames;
    private Collection<Table> tables;
    private boolean passwords;
    private boolean data;
    private boolean settings;
    private boolean drop;
    private boolean simple;
    private LocalResult result;
    private byte[] lineSeparator;
    private byte[] buffer;
    private boolean tempLobTableCreated;
    private int nextLobId;
    private int lobBlockSize = 4096;

    public ScriptCommand(Session session) {
        super(session);
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    public void setSchemaNames(Set<String> schemaNames) {
        this.schemaNames = schemaNames;
    }

    public void setTables(Collection<Table> tables) {
        this.tables = tables;
    }

    public void setData(boolean data) {
        this.data = data;
    }

    public void setPasswords(boolean passwords) {
        this.passwords = passwords;
    }

    public void setSettings(boolean settings) {
        this.settings = settings;
    }

    public void setLobBlockSize(long blockSize) {
        this.lobBlockSize = MathUtils.convertLongToInt(blockSize);
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult r = this.createResult();
        r.done();
        return r;
    }

    private LocalResult createResult() {
        Expression[] expressions = new Expression[]{new ExpressionColumn(this.session.getDatabase(), new Column("SCRIPT", 13))};
        return new LocalResult(this.session, expressions, 1);
    }

    @Override
    public ResultInterface query(int maxrows) {
        this.session.getUser().checkAdmin();
        this.reset();
        Database db = this.session.getDatabase();
        if (this.schemaNames != null) {
            for (String schemaName : this.schemaNames) {
                Schema schema = db.findSchema(schemaName);
                if (schema != null) continue;
                throw DbException.get(90079, schemaName);
            }
        }
        try {
            this.result = this.createResult();
            this.deleteStore();
            this.openOutput();
            if (this.out != null) {
                this.buffer = new byte[4096];
            }
            if (this.settings) {
                for (Setting setting : db.getAllSettings()) {
                    if (setting.getName().equals(SetTypes.getTypeName(34))) continue;
                    this.add(setting.getCreateSQL(), false);
                }
            }
            if (this.out != null) {
                this.add("", true);
            }
            for (User user : db.getAllUsers()) {
                this.add(user.getCreateSQL(this.passwords), false);
            }
            for (Role role : db.getAllRoles()) {
                this.add(role.getCreateSQL(true), false);
            }
            for (Schema schema : db.getAllSchemas()) {
                if (this.excludeSchema(schema)) continue;
                this.add(schema.getCreateSQL(), false);
            }
            for (UserDataType datatype : db.getAllUserDataTypes()) {
                if (this.drop) {
                    this.add(datatype.getDropSQL(), false);
                }
                this.add(datatype.getCreateSQL(), false);
            }
            for (SchemaObject obj : db.getAllSchemaObjects(11)) {
                if (this.excludeSchema(obj.getSchema())) continue;
                Constant constant = (Constant)obj;
                this.add(constant.getCreateSQL(), false);
            }
            ArrayList<Table> tables = db.getAllTablesAndViews(false);
            Collections.sort(tables, new Comparator<Table>(){

                @Override
                public int compare(Table t1, Table t2) {
                    return t1.getId() - t2.getId();
                }
            });
            for (Table table : tables) {
                if (this.excludeSchema(table.getSchema()) || this.excludeTable(table) || table.isHidden()) continue;
                table.lock(this.session, false, false);
                String sql = table.getCreateSQL();
                if (sql == null || !this.drop) continue;
                this.add(table.getDropSQL(), false);
            }
            for (SchemaObject obj : db.getAllSchemaObjects(9)) {
                if (this.excludeSchema(obj.getSchema())) continue;
                if (this.drop) {
                    this.add(obj.getDropSQL(), false);
                }
                this.add(obj.getCreateSQL(), false);
            }
            for (UserAggregate agg : db.getAllAggregates()) {
                if (this.drop) {
                    this.add(agg.getDropSQL(), false);
                }
                this.add(agg.getCreateSQL(), false);
            }
            for (SchemaObject obj : db.getAllSchemaObjects(3)) {
                if (this.excludeSchema(obj.getSchema())) continue;
                Sequence sequence = (Sequence)obj;
                if (this.drop) {
                    this.add(sequence.getDropSQL(), false);
                }
                this.add(sequence.getCreateSQL(), false);
            }
            int count = 0;
            for (Table table : tables) {
                if (this.excludeSchema(table.getSchema()) || this.excludeTable(table) || table.isHidden()) continue;
                table.lock(this.session, false, false);
                String sql = table.getCreateSQL();
                if (sql == null) continue;
                String tableType = table.getTableType();
                this.add(sql, false);
                ArrayList<Constraint> constraints = table.getConstraints();
                if (constraints != null) {
                    for (Constraint constraint : constraints) {
                        if (!"PRIMARY KEY".equals(constraint.getConstraintType())) continue;
                        this.add(constraint.getCreateSQLWithoutIndexes(), false);
                    }
                }
                if ("TABLE".equals(tableType)) {
                    if (table.canGetRowCount()) {
                        String rowcount = "-- " + table.getRowCountApproximation() + " +/- SELECT COUNT(*) FROM " + table.getSQL();
                        this.add(rowcount, false);
                    }
                    if (this.data) {
                        PlanItem plan = table.getBestPlanItem(this.session, null);
                        Index index = plan.getIndex();
                        Cursor cursor = index.find(this.session, null, null);
                        Column[] columns = table.getColumns();
                        StatementBuilder buff = new StatementBuilder("INSERT INTO ");
                        buff.append(table.getSQL()).append('(');
                        for (Column col : columns) {
                            buff.appendExceptFirst(", ");
                            buff.append(Parser.quoteIdentifier(col.getName()));
                        }
                        buff.append(") VALUES");
                        if (!this.simple) {
                            buff.append('\n');
                        }
                        buff.append('(');
                        String ins = buff.toString();
                        buff = null;
                        while (cursor.next()) {
                            Row row = cursor.get();
                            if (buff == null) {
                                buff = new StatementBuilder(ins);
                            } else {
                                buff.append(",\n(");
                            }
                            for (int j = 0; j < row.getColumnCount(); ++j) {
                                Value v;
                                if (j > 0) {
                                    buff.append(", ");
                                }
                                if ((v = row.getValue(j)).getPrecision() > (long)this.lobBlockSize) {
                                    int id;
                                    if (v.getType() == 16) {
                                        id = this.writeLobStream(v);
                                        buff.append("SYSTEM_COMBINE_CLOB(" + id + ")");
                                        continue;
                                    }
                                    if (v.getType() == 15) {
                                        id = this.writeLobStream(v);
                                        buff.append("SYSTEM_COMBINE_BLOB(" + id + ")");
                                        continue;
                                    }
                                    buff.append(v.getSQL());
                                    continue;
                                }
                                buff.append(v.getSQL());
                            }
                            buff.append(')');
                            if ((++count & 0x7F) == 0) {
                                this.checkCanceled();
                            }
                            if (!this.simple && buff.length() <= 4096) continue;
                            this.add(buff.toString(), true);
                            buff = null;
                        }
                        if (buff != null) {
                            this.add(buff.toString(), true);
                        }
                    }
                }
                ArrayList<Index> indexes = table.getIndexes();
                for (int j = 0; indexes != null && j < indexes.size(); ++j) {
                    Index index = indexes.get(j);
                    if (index.getIndexType().getBelongsToConstraint()) continue;
                    this.add(index.getCreateSQL(), false);
                }
            }
            if (this.tempLobTableCreated) {
                this.add("DROP TABLE IF EXISTS SYSTEM_LOB_STREAM", true);
                this.add("CALL SYSTEM_COMBINE_BLOB(-1)", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_CLOB", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_BLOB", true);
                this.tempLobTableCreated = false;
            }
            ArrayList<SchemaObject> constraints = db.getAllSchemaObjects(5);
            Collections.sort(constraints, new Comparator<SchemaObject>(){

                @Override
                public int compare(SchemaObject c1, SchemaObject c2) {
                    return ((Constraint)c1).compareTo((Constraint)c2);
                }
            });
            for (SchemaObject obj : constraints) {
                Constraint constraint;
                if (this.excludeSchema(obj.getSchema()) || this.excludeTable((constraint = (Constraint)obj).getTable()) || constraint.getTable().isHidden() || "PRIMARY KEY".equals(constraint.getConstraintType())) continue;
                this.add(constraint.getCreateSQLWithoutIndexes(), false);
            }
            for (SchemaObject obj : db.getAllSchemaObjects(4)) {
                TriggerObject trigger;
                if (this.excludeSchema(obj.getSchema()) || this.excludeTable((trigger = (TriggerObject)obj).getTable())) continue;
                this.add(trigger.getCreateSQL(), false);
            }
            for (Right right : db.getAllRights()) {
                Table table = right.getGrantedTable();
                if (table != null && (this.excludeSchema(table.getSchema()) || this.excludeTable(table))) continue;
                this.add(right.getCreateSQL(), false);
            }
            for (Comment comment : db.getAllComments()) {
                this.add(comment.getCreateSQL(), false);
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.getFileName());
        }
        finally {
            this.closeIO();
        }
        this.result.done();
        LocalResult r = this.result;
        this.reset();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeLobStream(Value v) throws IOException {
        if (!this.tempLobTableCreated) {
            this.add("CREATE TABLE IF NOT EXISTS SYSTEM_LOB_STREAM(ID INT NOT NULL, PART INT NOT NULL, CDATA VARCHAR, BDATA BINARY)", true);
            this.add("CREATE PRIMARY KEY SYSTEM_LOB_STREAM_PRIMARY_KEY ON SYSTEM_LOB_STREAM(ID, PART)", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_CLOB FOR \"" + this.getClass().getName() + ".combineClob\"", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_BLOB FOR \"" + this.getClass().getName() + ".combineBlob\"", true);
            this.tempLobTableCreated = true;
        }
        int id = this.nextLobId++;
        block2 : switch (v.getType()) {
            case 15: {
                byte[] bytes = new byte[this.lobBlockSize];
                InputStream input = v.getInputStream();
                try {
                    int i = 0;
                    while (true) {
                        StringBuilder buff = new StringBuilder(this.lobBlockSize * 2);
                        buff.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(" + id + ", " + i + ", NULL, '");
                        int len = IOUtils.readFully(input, bytes, 0, this.lobBlockSize);
                        if (len <= 0) {
                            break block2;
                        }
                        buff.append(StringUtils.convertBytesToHex(bytes, len)).append("')");
                        String sql = buff.toString();
                        this.add(sql, true);
                        ++i;
                    }
                }
                finally {
                    IOUtils.closeSilently(input);
                }
            }
            case 16: {
                char[] chars = new char[this.lobBlockSize];
                Reader reader = v.getReader();
                try {
                    int i = 0;
                    while (true) {
                        StringBuilder buff = new StringBuilder(this.lobBlockSize * 2);
                        buff.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(" + id + ", " + i + ", ");
                        int len = IOUtils.readFully(reader, chars, this.lobBlockSize);
                        if (len < 0) {
                            break block2;
                        }
                        buff.append(StringUtils.quoteStringSQL(new String(chars, 0, len))).append(", NULL)");
                        String sql = buff.toString();
                        this.add(sql, true);
                        ++i;
                    }
                }
                finally {
                    IOUtils.closeSilently(reader);
                }
            }
            default: {
                DbException.throwInternalError("type:" + v.getType());
            }
        }
        return id;
    }

    public static InputStream combineBlob(Connection conn, int id) throws SQLException {
        if (id < 0) {
            return null;
        }
        final ResultSet rs = ScriptCommand.getLobStream(conn, "BDATA", id);
        return new InputStream(){
            private InputStream current;
            private boolean closed;

            @Override
            public int read() throws IOException {
                try {
                    while (true) {
                        int x;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!rs.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = rs.getBinaryStream(1);
                            this.current = new BufferedInputStream(this.current);
                        }
                        if ((x = this.current.read()) >= 0) {
                            return x;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException e) {
                    throw DbException.convertToIOException(e);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw DbException.convertToIOException(e);
                }
            }
        };
    }

    public static Reader combineClob(Connection conn, int id) throws SQLException {
        if (id < 0) {
            return null;
        }
        final ResultSet rs = ScriptCommand.getLobStream(conn, "CDATA", id);
        return new Reader(){
            private Reader current;
            private boolean closed;

            @Override
            public int read() throws IOException {
                try {
                    while (true) {
                        int x;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!rs.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = rs.getCharacterStream(1);
                            this.current = new BufferedReader(this.current);
                        }
                        if ((x = this.current.read()) >= 0) {
                            return x;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException e) {
                    throw DbException.convertToIOException(e);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw DbException.convertToIOException(e);
                }
            }

            @Override
            public int read(char[] buffer, int off, int len) throws IOException {
                int i;
                if (len == 0) {
                    return 0;
                }
                int c = this.read();
                if (c == -1) {
                    return -1;
                }
                buffer[off] = (char)c;
                for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                    buffer[off + i] = (char)c;
                }
                return i;
            }
        };
    }

    private static ResultSet getLobStream(Connection conn, String column, int id) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT " + column + " FROM SYSTEM_LOB_STREAM WHERE ID=? ORDER BY PART");
        prep.setInt(1, id);
        return prep.executeQuery();
    }

    private void reset() {
        this.result = null;
        this.buffer = null;
        try {
            this.lineSeparator = SysProperties.LINE_SEPARATOR.getBytes(this.charset);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    private boolean excludeSchema(Schema schema) {
        if (this.schemaNames != null && !this.schemaNames.contains(schema.getName())) {
            return true;
        }
        if (this.tables != null) {
            for (Table table : schema.getAllTablesAndViews()) {
                if (!this.tables.contains(table)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean excludeTable(Table table) {
        return this.tables != null && !this.tables.contains(table);
    }

    private void add(String s, boolean insert) throws IOException {
        if (s == null) {
            return;
        }
        s = s + ";";
        if (this.out != null) {
            byte[] buff = s.getBytes(this.charset);
            int len = MathUtils.roundUpInt(buff.length + this.lineSeparator.length, 16);
            this.buffer = Utils.copy(buff, this.buffer);
            if (len > this.buffer.length) {
                this.buffer = new byte[len];
            }
            System.arraycopy(buff, 0, this.buffer, 0, buff.length);
            for (int i = buff.length; i < len - this.lineSeparator.length; ++i) {
                this.buffer[i] = 32;
            }
            int j = 0;
            int i = len - this.lineSeparator.length;
            while (i < len) {
                this.buffer[i] = this.lineSeparator[j];
                ++i;
                ++j;
            }
            this.out.write(this.buffer, 0, len);
            if (!insert) {
                Value[] row = new Value[]{ValueString.get(s)};
                this.result.addRow(row);
            }
        } else {
            Value[] row = new Value[]{ValueString.get(s)};
            this.result.addRow(row);
        }
    }

    public void setSimple(boolean simple) {
        this.simple = simple;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public int getType() {
        return 65;
    }
}

