/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class Update
extends Prepared {
    private Expression condition;
    private TableFilter tableFilter;
    private Expression limitExpr;
    private ArrayList<Column> columns = New.arrayList();
    private HashMap<Column, Expression> expressionMap = New.hashMap();

    public Update(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.tableFilter = tableFilter;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public void setAssignment(Column column, Expression expression) {
        if (this.expressionMap.containsKey(column)) {
            throw DbException.get(42121, column.getName());
        }
        this.columns.add(column);
        this.expressionMap.put(column, expression);
        if (expression instanceof Parameter) {
            Parameter p = (Parameter)expression;
            p.setColumn(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        this.tableFilter.startQuery(this.session);
        this.tableFilter.reset();
        RowList rows = new RowList(this.session);
        try {
            Value v;
            Table table = this.tableFilter.getTable();
            this.session.getUser().checkRight(table, 8);
            table.fire(this.session, 2, true);
            table.lock(this.session, true, false);
            int columnCount = table.getColumns().length;
            this.setCurrentRowNumber(0);
            int count = 0;
            Column[] columns = table.getColumns();
            int limitRows = -1;
            if (this.limitExpr != null && (v = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
                limitRows = v.getInt();
            }
            while (this.tableFilter.next()) {
                this.setCurrentRowNumber(count + 1);
                if (limitRows >= 0 && count >= limitRows) break;
                if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
                Row oldRow = this.tableFilter.get();
                Row newRow = table.getTemplateRow();
                for (int i = 0; i < columnCount; ++i) {
                    Column column;
                    Value newValue;
                    Expression newExpr = this.expressionMap.get(columns[i]);
                    if (newExpr == null) {
                        newValue = oldRow.getValue(i);
                    } else if (newExpr == ValueExpression.getDefault()) {
                        column = table.getColumn(i);
                        newValue = table.getDefaultValue(this.session, column);
                    } else {
                        column = table.getColumn(i);
                        newValue = column.convert(newExpr.getValue(this.session));
                    }
                    newRow.setValue(i, newValue);
                }
                table.validateConvertUpdateSequence(this.session, newRow);
                boolean done = false;
                if (table.fireRow()) {
                    done = table.fireBeforeRow(this.session, oldRow, newRow);
                }
                if (!done) {
                    rows.add(oldRow);
                    rows.add(newRow);
                }
                ++count;
            }
            table.updateRows(this, this.session, rows);
            if (table.fireRow()) {
                rows.invalidateCache();
                rows.reset();
                while (rows.hasNext()) {
                    Row o = rows.next();
                    Row n = rows.next();
                    table.fireAfterRow(this.session, o, n, false);
                }
            }
            table.fire(this.session, 2, false);
            int n = count;
            return n;
        }
        finally {
            rows.close();
        }
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder buff = new StatementBuilder("UPDATE ");
        buff.append(this.tableFilter.getPlanSQL(false)).append("\nSET\n    ");
        int size = this.columns.size();
        for (int i = 0; i < size; ++i) {
            Column c = this.columns.get(i);
            Expression e = this.expressionMap.get(c);
            buff.appendExceptFirst(",\n    ");
            buff.append(c.getName()).append(" = ").append(e.getSQL());
        }
        if (this.condition != null) {
            buff.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        return buff.toString();
    }

    @Override
    public void prepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.tableFilter, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.tableFilter);
        }
        int size = this.columns.size();
        for (int i = 0; i < size; ++i) {
            Column c = this.columns.get(i);
            Expression e = this.expressionMap.get(c);
            e.mapColumns(this.tableFilter, 0);
            this.expressionMap.put(c, e.optimize(this.session));
        }
        PlanItem item = this.tableFilter.getBestPlanItem(this.session, 1);
        this.tableFilter.setPlanItem(item);
        this.tableFilter.prepare();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 68;
    }

    public void setLimit(Expression limit) {
        this.limitExpr = limit;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }
}

