/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;

public class Subquery
extends Expression {
    private Query query;
    private Expression expression;

    public Subquery(Query query) {
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value getValue(Session session) {
        this.query.setSession(session);
        LocalResult result = this.query.query(2);
        try {
            Value v;
            int rowcount = result.getRowCount();
            if (rowcount > 1) {
                throw DbException.get(90053);
            }
            if (rowcount <= 0) {
                v = ValueNull.INSTANCE;
            } else {
                result.next();
                Value[] values = result.currentRow();
                v = result.getVisibleColumnCount() == 1 ? values[0] : ValueArray.get(values);
            }
            ValueNull valueNull = v;
            return valueNull;
        }
        finally {
            result.close();
        }
    }

    @Override
    public int getType() {
        return this.getExpression().getType();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        this.query.mapColumns(resolver, level + 1);
    }

    @Override
    public Expression optimize(Session session) {
        this.query.prepare();
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.query.setEvaluatable(tableFilter, b);
    }

    @Override
    public int getScale() {
        return this.getExpression().getScale();
    }

    @Override
    public long getPrecision() {
        return this.getExpression().getPrecision();
    }

    @Override
    public int getDisplaySize() {
        return this.getExpression().getDisplaySize();
    }

    @Override
    public String getSQL() {
        return "(" + this.query.getPlanSQL() + ")";
    }

    @Override
    public void updateAggregate(Session session) {
        this.query.updateAggregate(session);
    }

    private Expression getExpression() {
        if (this.expression == null) {
            ArrayList<Expression> expressions = this.query.getExpressions();
            int columnCount = this.query.getColumnCount();
            if (columnCount == 1) {
                this.expression = expressions.get(0);
            } else {
                Expression[] list = new Expression[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    list[i] = expressions.get(i);
                }
                this.expression = new ExpressionList(list);
            }
        }
        return this.expression;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.query.isEverything(visitor);
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public int getCost() {
        return this.query.getCostAsExpression();
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        return this.getExpression().getExpressionColumns(session);
    }
}

