/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;

public class HashIndex
extends BaseIndex {
    protected final int indexColumn;
    private final RegularTable tableData;
    private ValueHashMap<Long> rows;

    public HashIndex(RegularTable table, int id, String indexName, IndexColumn[] columns, IndexType indexType) {
        this.initBaseIndex(table, id, indexName, columns, indexType);
        this.indexColumn = columns[0].column.getColumnId();
        this.tableData = table;
        this.reset();
    }

    private void reset() {
        this.rows = ValueHashMap.newInstance();
    }

    @Override
    public void truncate(Session session) {
        this.reset();
    }

    @Override
    public void add(Session session, Row row) {
        Value key = row.getValue(this.indexColumn);
        Long old = this.rows.get(key);
        if (old != null) {
            throw this.getDuplicateKeyException();
        }
        this.rows.put(key, row.getKey());
    }

    @Override
    public void remove(Session session, Row row) {
        this.rows.remove(row.getValue(this.indexColumn));
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        if (first == null || last == null) {
            throw DbException.throwInternalError();
        }
        Long pos = this.rows.get(first.getValue(this.indexColumn));
        Row result = pos == null ? null : this.tableData.getRow(session, pos.intValue());
        return new SingleRowCursor(result);
    }

    @Override
    public long getRowCount(Session session) {
        return this.getRowCountApproximation();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rows.size();
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void remove(Session session) {
    }

    @Override
    public double getCost(Session session, int[] masks) {
        for (Column column : this.columns) {
            int index = column.getColumnId();
            int mask = masks[index];
            if ((mask & 1) == 1) continue;
            return 9.223372036854776E18;
        }
        return 2.0;
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        throw DbException.getUnsupportedException("HASH");
    }

    @Override
    public boolean canScan() {
        return false;
    }
}

