/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.LinkedCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableLink;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class LinkedIndex
extends BaseIndex {
    private TableLink link;
    private String targetTableName;
    private long rowCount;

    public LinkedIndex(TableLink table, int id, IndexColumn[] columns, IndexType indexType) {
        this.initBaseIndex(table, id, null, columns, indexType);
        this.link = table;
        this.targetTableName = this.link.getQualifiedTable();
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void close(Session session) {
    }

    private static boolean isNull(Value v) {
        return v == null || v == ValueNull.INSTANCE;
    }

    @Override
    public void add(Session session, Row row) {
        ArrayList<Value> params = New.arrayList();
        StatementBuilder buff = new StatementBuilder("INSERT INTO ");
        buff.append(this.targetTableName).append(" VALUES(");
        for (int i = 0; i < row.getColumnCount(); ++i) {
            Value v = row.getValue(i);
            buff.appendExceptFirst(", ");
            if (v == null) {
                buff.append("DEFAULT");
                continue;
            }
            if (LinkedIndex.isNull(v)) {
                buff.append("NULL");
                continue;
            }
            buff.append('?');
            params.add(v);
        }
        buff.append(')');
        String sql = buff.toString();
        try {
            this.link.execute(sql, params, true);
            ++this.rowCount;
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        Column col;
        Value v;
        int i;
        ArrayList<Value> params = New.arrayList();
        StatementBuilder buff = new StatementBuilder("SELECT * FROM ");
        buff.append(this.targetTableName).append(" T");
        for (i = 0; first != null && i < first.getColumnCount(); ++i) {
            v = first.getValue(i);
            if (v == null) continue;
            buff.appendOnlyFirst(" WHERE ");
            buff.appendExceptFirst(" AND ");
            col = this.table.getColumn(i);
            buff.append(col.getSQL());
            if (v == ValueNull.INSTANCE) {
                buff.append(" IS NULL");
                continue;
            }
            buff.append(">=");
            this.addParameter(buff, col);
            params.add(v);
        }
        for (i = 0; last != null && i < last.getColumnCount(); ++i) {
            v = last.getValue(i);
            if (v == null) continue;
            buff.appendOnlyFirst(" WHERE ");
            buff.appendExceptFirst(" AND ");
            col = this.table.getColumn(i);
            buff.append(col.getSQL());
            if (v == ValueNull.INSTANCE) {
                buff.append(" IS NULL");
                continue;
            }
            buff.append("<=");
            this.addParameter(buff, col);
            params.add(v);
        }
        String sql = buff.toString();
        try {
            PreparedStatement prep = this.link.execute(sql, params, false);
            ResultSet rs = prep.getResultSet();
            return new LinkedCursor(this.link, rs, session, sql, prep);
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    private void addParameter(StatementBuilder buff, Column col) {
        if (col.getType() == 21 && this.link.isOracle()) {
            buff.append("CAST(? AS CHAR(").append(col.getPrecision()).append("))");
        } else {
            buff.append('?');
        }
    }

    @Override
    public double getCost(Session session, int[] masks) {
        return 100L + this.getCostRangeIndex(masks, this.rowCount + 1000L);
    }

    @Override
    public void remove(Session session) {
    }

    @Override
    public void truncate(Session session) {
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("LINKED");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        throw DbException.getUnsupportedException("LINKED");
    }

    @Override
    public void remove(Session session, Row row) {
        ArrayList<Value> params = New.arrayList();
        StatementBuilder buff = new StatementBuilder("DELETE FROM ");
        buff.append(this.targetTableName).append(" WHERE ");
        for (int i = 0; i < row.getColumnCount(); ++i) {
            buff.appendExceptFirst("AND ");
            Column col = this.table.getColumn(i);
            buff.append(col.getSQL());
            Value v = row.getValue(i);
            if (LinkedIndex.isNull(v)) {
                buff.append(" IS NULL ");
                continue;
            }
            buff.append('=');
            this.addParameter(buff, col);
            params.add(v);
            buff.append(' ');
        }
        String sql = buff.toString();
        try {
            PreparedStatement prep = this.link.execute(sql, params, false);
            int count = prep.executeUpdate();
            this.link.reusePreparedStatement(prep, sql);
            this.rowCount -= (long)count;
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    public void update(Row oldRow, Row newRow) {
        int i;
        ArrayList<Value> params = New.arrayList();
        StatementBuilder buff = new StatementBuilder("UPDATE ");
        buff.append(this.targetTableName).append(" SET ");
        for (i = 0; i < newRow.getColumnCount(); ++i) {
            buff.appendExceptFirst(", ");
            buff.append(this.table.getColumn(i).getSQL()).append('=');
            Value v = newRow.getValue(i);
            if (v == null) {
                buff.append("DEFAULT");
                continue;
            }
            buff.append('?');
            params.add(v);
        }
        buff.append(" WHERE ");
        buff.resetCount();
        for (i = 0; i < oldRow.getColumnCount(); ++i) {
            Column col = this.table.getColumn(i);
            buff.appendExceptFirst(" AND ");
            buff.append(col.getSQL());
            Value v = oldRow.getValue(i);
            if (LinkedIndex.isNull(v)) {
                buff.append(" IS NULL");
                continue;
            }
            buff.append('=');
            params.add(v);
            this.addParameter(buff, col);
        }
        String sql = buff.toString();
        try {
            this.link.execute(sql, params, true);
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }
}

