/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.DbException;
import org.h2.util.BitField;
import org.h2.util.New;
import org.h2.value.ValueNull;

public class JdbcCallableStatement
extends JdbcPreparedStatement
implements CallableStatement {
    private BitField outParameters;
    private int maxOutParameters;
    private HashMap<String, Integer> namedParameters;

    JdbcCallableStatement(JdbcConnection conn, String sql, int id, int resultSetType, int resultSetConcurrency) {
        super(conn, sql, id, resultSetType, resultSetConcurrency, false);
        this.setTrace(this.session.getTrace(), 0, id);
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            this.checkClosed();
            if (this.command.isQuery()) {
                super.executeQuery();
                return 0;
            }
            return super.executeUpdate();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.getIndexForName(parameterName), sqlType, typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.getIndexForName(parameterName), sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(this.getIndexForName(parameterName), sqlType);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.getOpenResultSet().wasNull();
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getString(parameterIndex);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getBoolean(parameterIndex);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getByte(parameterIndex);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getShort(parameterIndex);
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getInt(parameterIndex);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getLong(parameterIndex);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getFloat(parameterIndex);
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getDouble(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getBigDecimal(parameterIndex, scale);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getBytes(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getDate(parameterIndex);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getTime(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getTimestamp(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getObject(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getBigDecimal(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getBlob(parameterIndex);
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getClob(parameterIndex);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getArray(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getDate(parameterIndex, cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getTimestamp(parameterIndex, cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.getIndexForName(parameterName), cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getTime(this.getIndexForName(parameterName), cal);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getDate(this.getIndexForName(parameterName), cal);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.getArray(this.getIndexForName(parameterName));
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.getClob(this.getIndexForName(parameterName));
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.getBlob(this.getIndexForName(parameterName));
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getBigDecimal(this.getIndexForName(parameterName));
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.getObject(this.getIndexForName(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getTimestamp(this.getIndexForName(parameterName));
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.getTime(this.getIndexForName(parameterName));
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.getDate(this.getIndexForName(parameterName));
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.getBytes(this.getIndexForName(parameterName));
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.getDouble(this.getIndexForName(parameterName));
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.getFloat(this.getIndexForName(parameterName));
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.getLong(this.getIndexForName(parameterName));
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.getInt(this.getIndexForName(parameterName));
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.getShort(this.getIndexForName(parameterName));
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.getByte(this.getIndexForName(parameterName));
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.getBoolean(this.getIndexForName(parameterName));
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.getString(this.getIndexForName(parameterName));
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getNClob(parameterIndex);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.getNClob(this.getIndexForName(parameterName));
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getNString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getNString(this.getIndexForName(parameterName));
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getNCharacterStream(this.getIndexForName(parameterName));
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        this.checkRegistered(parameterIndex);
        return this.getOpenResultSet().getCharacterStream(parameterIndex);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getCharacterStream(this.getIndexForName(parameterName));
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.getIndexForName(parameterName), sqlType, typeName);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.getIndexForName(parameterName), sqlType);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.getIndexForName(parameterName), x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.getIndexForName(parameterName), x, cal);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.getIndexForName(parameterName), x, cal);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x, int length) throws SQLException {
        this.setCharacterStream(this.getIndexForName(parameterName), x, length);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.getIndexForName(parameterName), x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.getIndexForName(parameterName), x, targetSqlType, scale);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.getIndexForName(parameterName), x, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setAsciiStream(this.getIndexForName(parameterName), x, length);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void setNString(String parameterName, String x) throws SQLException {
        this.setNString(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        this.setNCharacterStream(this.getIndexForName(parameterName), x, length);
    }

    @Override
    public void setNClob(String parameterName, NClob x) throws SQLException {
        this.setNClob(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setClob(String parameterName, Reader x, long length) throws SQLException {
        this.setClob(this.getIndexForName(parameterName), x, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream x, long length) throws SQLException {
        this.setBlob(this.getIndexForName(parameterName), x, length);
    }

    @Override
    public void setNClob(String parameterName, Reader x, long length) throws SQLException {
        this.setNClob(this.getIndexForName(parameterName), x, length);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setBlob(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.setClob(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.setAsciiStream(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.getIndexForName(parameterName), x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.setBinaryStream(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setBinaryStream(this.getIndexForName(parameterName), x, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream x) throws SQLException {
        this.setBlob(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x) throws SQLException {
        this.setCharacterStream(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        this.setCharacterStream(this.getIndexForName(parameterName), x, length);
    }

    @Override
    public void setClob(String parameterName, Reader x) throws SQLException {
        this.setClob(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader x) throws SQLException {
        this.setNCharacterStream(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setNClob(String parameterName, Reader x) throws SQLException {
        this.setNClob(this.getIndexForName(parameterName), x);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML x) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    private ResultSetMetaData getCheckedMetaData() throws SQLException {
        ResultSetMetaData meta = this.getMetaData();
        if (meta == null) {
            throw DbException.getUnsupportedException("Supported only for calling stored procedures");
        }
        return meta;
    }

    private void checkIndexBounds(int parameterIndex) {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.maxOutParameters) {
            throw DbException.getInvalidValueException("parameterIndex", parameterIndex);
        }
    }

    private void registerOutParameter(int parameterIndex) throws SQLException {
        try {
            this.checkClosed();
            if (this.outParameters == null) {
                this.maxOutParameters = Math.min(this.getParameterMetaData().getParameterCount(), this.getCheckedMetaData().getColumnCount());
                this.outParameters = new BitField();
            }
            this.checkIndexBounds(parameterIndex);
            ParameterInterface param = this.command.getParameters().get(--parameterIndex);
            if (param.getParamValue() == null) {
                param.setValue(ValueNull.INSTANCE, false);
            }
            this.outParameters.set(parameterIndex);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void checkRegistered(int parameterIndex) throws SQLException {
        try {
            this.checkIndexBounds(parameterIndex);
            if (!this.outParameters.get(parameterIndex - 1)) {
                throw DbException.getInvalidValueException("parameterIndex", parameterIndex);
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private int getIndexForName(String parameterName) throws SQLException {
        try {
            Integer index;
            this.checkClosed();
            if (this.namedParameters == null) {
                ResultSetMetaData meta = this.getCheckedMetaData();
                int columnCount = meta.getColumnCount();
                HashMap<String, Integer> map = New.hashMap(columnCount);
                for (int i = 1; i <= columnCount; ++i) {
                    map.put(meta.getColumnLabel(i), i);
                }
                this.namedParameters = map;
            }
            if ((index = this.namedParameters.get(parameterName)) == null) {
                throw DbException.getInvalidValueException("parameterName", parameterName);
            }
            return index;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private JdbcResultSet getOpenResultSet() throws SQLException {
        try {
            this.checkClosed();
            if (this.resultSet == null) {
                throw DbException.get(2000);
            }
            if (this.resultSet.isBeforeFirst()) {
                this.resultSet.next();
            }
            return this.resultSet;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }
}

