/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.result.ResultExternal;
import org.h2.result.SortOrder;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.util.New;
import org.h2.value.Value;

class ResultDiskBuffer
implements ResultExternal {
    private static final int READ_AHEAD = 128;
    private final Data rowBuff;
    private final ArrayList<ResultDiskTape> tapes;
    private final ResultDiskTape mainTape;
    private final SortOrder sort;
    private final int columnCount;
    private final int maxBufferSize;
    private FileStore file;
    private int rowCount;
    private final ResultDiskBuffer parent;
    private boolean closed;
    private int childCount;

    ResultDiskBuffer(Session session, SortOrder sort, int columnCount) {
        this.parent = null;
        this.sort = sort;
        this.columnCount = columnCount;
        Database db = session.getDatabase();
        this.rowBuff = Data.create((DataHandler)db, 2048);
        String fileName = db.createTempFile();
        this.file = db.openFile(fileName, "rw", false);
        this.file.setCheckedWriting(false);
        this.file.seek(48L);
        if (sort != null) {
            this.tapes = New.arrayList();
            this.mainTape = null;
        } else {
            this.tapes = null;
            this.mainTape = new ResultDiskTape();
            this.mainTape.pos = 48L;
        }
        this.maxBufferSize = db.getSettings().largeResultBufferSize;
    }

    private ResultDiskBuffer(ResultDiskBuffer parent) {
        this.parent = parent;
        this.rowBuff = Data.create(parent.rowBuff.getHandler(), 2048);
        this.file = parent.file;
        if (parent.tapes != null) {
            this.tapes = New.arrayList();
            for (ResultDiskTape t : parent.tapes) {
                ResultDiskTape t2 = new ResultDiskTape();
                t2.pos = t2.start = t.start;
                t2.end = t.end;
                this.tapes.add(t2);
            }
        } else {
            this.tapes = null;
        }
        if (parent.mainTape != null) {
            this.mainTape = new ResultDiskTape();
            this.mainTape.pos = 48L;
            this.mainTape.start = parent.mainTape.start;
            this.mainTape.end = parent.mainTape.end;
        } else {
            this.mainTape = null;
        }
        this.sort = parent.sort;
        this.columnCount = parent.columnCount;
        this.maxBufferSize = parent.maxBufferSize;
    }

    @Override
    public synchronized ResultDiskBuffer createShallowCopy() {
        if (this.closed || this.parent != null) {
            return null;
        }
        ++this.childCount;
        return new ResultDiskBuffer(this);
    }

    @Override
    public int addRows(ArrayList<Value[]> rows) {
        if (this.sort != null) {
            this.sort.sort(rows);
        }
        Data buff = this.rowBuff;
        long start = this.file.getFilePointer();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int bufferLen = 0;
        for (Value[] row : rows) {
            buff.reset();
            buff.writeInt(0);
            for (int j = 0; j < this.columnCount; ++j) {
                Value v = row[j];
                buff.checkCapacity(buff.getValueLen(v));
                buff.writeValue(v);
            }
            buff.fillAligned();
            int len = buff.length();
            buff.setInt(0, len);
            if (this.maxBufferSize > 0) {
                buffer.write(buff.getBytes(), 0, len);
                if ((bufferLen += len) <= this.maxBufferSize) continue;
                byte[] data = buffer.toByteArray();
                buffer.reset();
                this.file.write(data, 0, data.length);
                bufferLen = 0;
                continue;
            }
            this.file.write(buff.getBytes(), 0, len);
        }
        if (bufferLen > 0) {
            byte[] data = buffer.toByteArray();
            this.file.write(data, 0, data.length);
        }
        if (this.sort != null) {
            ResultDiskTape tape = new ResultDiskTape();
            tape.start = start;
            tape.end = this.file.getFilePointer();
            this.tapes.add(tape);
        } else {
            this.mainTape.end = this.file.getFilePointer();
        }
        this.rowCount += rows.size();
        return this.rowCount;
    }

    @Override
    public void done() {
        this.file.seek(48L);
        this.file.autoDelete();
    }

    @Override
    public void reset() {
        if (this.sort != null) {
            for (ResultDiskTape tape : this.tapes) {
                tape.pos = tape.start;
                tape.buffer = New.arrayList();
            }
        } else {
            this.mainTape.pos = 48L;
            this.mainTape.buffer = New.arrayList();
        }
    }

    private void readRow(ResultDiskTape tape) {
        int min = 16;
        Data buff = this.rowBuff;
        buff.reset();
        this.file.readFully(buff.getBytes(), 0, min);
        int len = buff.readInt();
        buff.checkCapacity(len);
        if (len - min > 0) {
            this.file.readFully(buff.getBytes(), min, len - min);
        }
        tape.pos += (long)len;
        Value[] row = new Value[this.columnCount];
        for (int k = 0; k < this.columnCount; ++k) {
            row[k] = buff.readValue();
        }
        tape.buffer.add(row);
    }

    @Override
    public Value[] next() {
        return this.sort != null ? this.nextSorted() : this.nextUnsorted();
    }

    private Value[] nextUnsorted() {
        this.file.seek(this.mainTape.pos);
        if (this.mainTape.buffer.size() == 0) {
            for (int j = 0; this.mainTape.pos < this.mainTape.end && j < 128; ++j) {
                this.readRow(this.mainTape);
            }
        }
        Value[] row = this.mainTape.buffer.get(0);
        this.mainTape.buffer.remove(0);
        return row;
    }

    private Value[] nextSorted() {
        int next = -1;
        int size = this.tapes.size();
        for (int i = 0; i < size; ++i) {
            ResultDiskTape tape = this.tapes.get(i);
            if (tape.buffer.size() == 0 && tape.pos < tape.end) {
                this.file.seek(tape.pos);
                for (int j = 0; tape.pos < tape.end && j < 128; ++j) {
                    this.readRow(tape);
                }
            }
            if (tape.buffer.size() <= 0) continue;
            if (next == -1) {
                next = i;
                continue;
            }
            if (this.compareTapes(tape, this.tapes.get(next)) >= 0) continue;
            next = i;
        }
        ResultDiskTape t = this.tapes.get(next);
        Value[] row = t.buffer.get(0);
        t.buffer.remove(0);
        return row;
    }

    private int compareTapes(ResultDiskTape a, ResultDiskTape b) {
        Value[] va = a.buffer.get(0);
        Value[] vb = b.buffer.get(0);
        return this.sort.compare(va, vb);
    }

    private synchronized void closeChild() {
        if (--this.childCount == 0 && this.closed) {
            this.file.closeAndDeleteSilently();
            this.file = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.parent != null) {
            this.parent.closeChild();
        } else if (this.file != null && this.childCount == 0) {
            this.file.closeAndDeleteSilently();
            this.file = null;
        }
    }

    @Override
    public int removeRow(Value[] values) {
        throw DbException.throwInternalError();
    }

    @Override
    public boolean contains(Value[] values) {
        throw DbException.throwInternalError();
    }

    @Override
    public int addRow(Value[] values) {
        throw DbException.throwInternalError();
    }

    static class ResultDiskTape {
        long start;
        long end;
        long pos;
        ArrayList<Value[]> buffer = New.arrayList();

        ResultDiskTape() {
        }
    }
}

