/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.schema.Constant;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.RegularTable;
import org.h2.table.Table;
import org.h2.table.TableLink;
import org.h2.util.New;
import org.h2.util.Utils;

public class Schema
extends DbObjectBase {
    private User owner;
    private final boolean system;
    private final HashMap<String, Table> tablesAndViews;
    private final HashMap<String, Index> indexes;
    private final HashMap<String, Sequence> sequences;
    private final HashMap<String, TriggerObject> triggers;
    private final HashMap<String, Constraint> constraints;
    private final HashMap<String, Constant> constants;
    private final HashMap<String, FunctionAlias> functions;
    private final HashSet<String> temporaryUniqueNames = New.hashSet();

    public Schema(Database database, int id, String schemaName, User owner, boolean system) {
        this.tablesAndViews = database.newStringMap();
        this.indexes = database.newStringMap();
        this.sequences = database.newStringMap();
        this.triggers = database.newStringMap();
        this.constraints = database.newStringMap();
        this.constants = database.newStringMap();
        this.functions = database.newStringMap();
        this.initDbObjectBase(database, id, schemaName, "schema");
        this.owner = owner;
        this.system = system;
    }

    public boolean canDrop() {
        return !this.system;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError();
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        if (this.system) {
            return null;
        }
        return "CREATE SCHEMA IF NOT EXISTS " + this.getSQL() + " AUTHORIZATION " + this.owner.getSQL();
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        SchemaObject obj;
        while (this.triggers != null && this.triggers.size() > 0) {
            obj = (TriggerObject)this.triggers.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.constraints != null && this.constraints.size() > 0) {
            obj = (Constraint)this.constraints.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.tablesAndViews != null && this.tablesAndViews.size() > 0) {
            obj = (Table)this.tablesAndViews.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.indexes != null && this.indexes.size() > 0) {
            obj = (Index)this.indexes.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.sequences != null && this.sequences.size() > 0) {
            obj = (Sequence)this.sequences.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.constants != null && this.constants.size() > 0) {
            obj = (Constant)this.constants.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.functions != null && this.functions.size() > 0) {
            obj = (FunctionAlias)this.functions.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        this.database.removeMeta(session, this.getId());
        this.owner = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }

    public User getOwner() {
        return this.owner;
    }

    private HashMap<String, SchemaObject> getMap(int type) {
        HashMap<String, SchemaObject> result;
        switch (type) {
            case 0: {
                result = this.tablesAndViews;
                break;
            }
            case 3: {
                result = this.sequences;
                break;
            }
            case 1: {
                result = this.indexes;
                break;
            }
            case 4: {
                result = this.triggers;
                break;
            }
            case 5: {
                result = this.constraints;
                break;
            }
            case 11: {
                result = this.constants;
                break;
            }
            case 9: {
                result = this.functions;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + type);
            }
        }
        return result;
    }

    public void add(SchemaObject obj) {
        if (SysProperties.CHECK && obj.getSchema() != this) {
            DbException.throwInternalError("wrong schema");
        }
        String name = obj.getName();
        HashMap<String, SchemaObject> map = this.getMap(obj.getType());
        if (SysProperties.CHECK && map.get(name) != null) {
            DbException.throwInternalError("object already exists: " + name);
        }
        map.put(name, obj);
        this.freeUniqueName(name);
    }

    public void rename(SchemaObject obj, String newName) {
        int type = obj.getType();
        HashMap<String, SchemaObject> map = this.getMap(type);
        if (SysProperties.CHECK) {
            if (!map.containsKey(obj.getName())) {
                DbException.throwInternalError("not found: " + obj.getName());
            }
            if (obj.getName().equals(newName) || map.containsKey(newName)) {
                DbException.throwInternalError("object already exists: " + newName);
            }
        }
        obj.checkRename();
        map.remove(obj.getName());
        this.freeUniqueName(obj.getName());
        obj.rename(newName);
        map.put(newName, obj);
        this.freeUniqueName(newName);
    }

    public Table findTableOrView(Session session, String name) {
        Table table = this.tablesAndViews.get(name);
        if (table == null && session != null) {
            table = session.findLocalTempTable(name);
        }
        return table;
    }

    public Index findIndex(Session session, String name) {
        Index index = this.indexes.get(name);
        if (index == null) {
            index = session.findLocalTempTableIndex(name);
        }
        return index;
    }

    public TriggerObject findTrigger(String name) {
        return this.triggers.get(name);
    }

    public Sequence findSequence(String sequenceName) {
        return this.sequences.get(sequenceName);
    }

    public Constraint findConstraint(Session session, String name) {
        Constraint constraint = this.constraints.get(name);
        if (constraint == null) {
            constraint = session.findLocalTempTableConstraint(name);
        }
        return constraint;
    }

    public Constant findConstant(String constantName) {
        return this.constants.get(constantName);
    }

    public FunctionAlias findFunction(String functionAlias) {
        return this.functions.get(functionAlias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUniqueName(String name) {
        if (name != null) {
            HashSet<String> hashSet = this.temporaryUniqueNames;
            synchronized (hashSet) {
                this.temporaryUniqueNames.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUniqueName(DbObject obj, HashMap<String, ? extends SchemaObject> map, String prefix) {
        String hash = Integer.toHexString(obj.getName().hashCode()).toUpperCase();
        String name = null;
        HashSet<String> hashSet = this.temporaryUniqueNames;
        synchronized (hashSet) {
            int i;
            int len = hash.length();
            for (i = 1; i < len && (map.containsKey(name = prefix + hash.substring(0, i)) || this.temporaryUniqueNames.contains(name)); ++i) {
                name = null;
            }
            if (name == null) {
                prefix = prefix + hash + "_";
                i = 0;
                while (map.containsKey(name = prefix + i) || this.temporaryUniqueNames.contains(name)) {
                    ++i;
                }
            }
            this.temporaryUniqueNames.add(name);
        }
        return name;
    }

    public String getUniqueConstraintName(Session session, Table table) {
        HashMap<String, Constraint> tableConstraints = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableConstraints() : this.constraints;
        return this.getUniqueName(table, tableConstraints, "CONSTRAINT_");
    }

    public String getUniqueIndexName(Session session, Table table, String prefix) {
        HashMap<String, Index> tableIndexes = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableIndexes() : this.indexes;
        return this.getUniqueName(table, tableIndexes, prefix);
    }

    public Table getTableOrView(Session session, String name) {
        Table table = this.tablesAndViews.get(name);
        if (table == null) {
            if (session != null) {
                table = session.findLocalTempTable(name);
            }
            if (table == null) {
                throw DbException.get(42102, name);
            }
        }
        return table;
    }

    public Index getIndex(String name) {
        Index index = this.indexes.get(name);
        if (index == null) {
            throw DbException.get(42112, name);
        }
        return index;
    }

    public Constraint getConstraint(String name) {
        Constraint constraint = this.constraints.get(name);
        if (constraint == null) {
            throw DbException.get(90057, name);
        }
        return constraint;
    }

    public Constant getConstant(String constantName) {
        Constant constant = this.constants.get(constantName);
        if (constant == null) {
            throw DbException.get(90115, constantName);
        }
        return constant;
    }

    public Sequence getSequence(String sequenceName) {
        Sequence sequence = this.sequences.get(sequenceName);
        if (sequence == null) {
            throw DbException.get(90036, sequenceName);
        }
        return sequence;
    }

    public ArrayList<SchemaObject> getAll() {
        ArrayList<SchemaObject> all = New.arrayList();
        all.addAll(this.getMap(0).values());
        all.addAll(this.getMap(3).values());
        all.addAll(this.getMap(1).values());
        all.addAll(this.getMap(4).values());
        all.addAll(this.getMap(5).values());
        all.addAll(this.getMap(11).values());
        all.addAll(this.getMap(9).values());
        return all;
    }

    public ArrayList<SchemaObject> getAll(int type) {
        HashMap<String, SchemaObject> map = this.getMap(type);
        return New.arrayList(map.values());
    }

    public ArrayList<Table> getAllTablesAndViews() {
        return New.arrayList(this.tablesAndViews.values());
    }

    public void remove(SchemaObject obj) {
        String objName = obj.getName();
        HashMap<String, SchemaObject> map = this.getMap(obj.getType());
        if (SysProperties.CHECK && !map.containsKey(objName)) {
            DbException.throwInternalError("not found: " + objName);
        }
        map.remove(objName);
        this.freeUniqueName(objName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table createTable(CreateTableData data) {
        Database database = this.database;
        synchronized (database) {
            if (!data.temporary || data.globalTemporary) {
                this.database.lockMeta(data.session);
            }
            data.schema = this;
            if (data.tableEngine != null) {
                TableEngine engine;
                try {
                    engine = (TableEngine)Utils.loadUserClass(data.tableEngine).newInstance();
                }
                catch (Exception e) {
                    throw DbException.convert(e);
                }
                return engine.createTable(data);
            }
            return new RegularTable(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableLink createTableLink(int id, String tableName, String driver, String url, String user, String password, String originalSchema, String originalTable, boolean emitUpdates, boolean force) {
        Database database = this.database;
        synchronized (database) {
            return new TableLink(this, id, tableName, driver, url, user, password, originalSchema, originalTable, emitUpdates, force);
        }
    }
}

