/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security;

import java.util.Arrays;

public class SHA256 {
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    public static byte[] getHashWithSalt(byte[] data, byte[] salt) {
        byte[] buff = new byte[data.length + salt.length];
        System.arraycopy(data, 0, buff, 0, data.length);
        System.arraycopy(salt, 0, buff, data.length, salt.length);
        return SHA256.getHash(buff, true);
    }

    public static byte[] getKeyPasswordHash(String userName, char[] password) {
        String user = userName + "@";
        byte[] buff = new byte[2 * (user.length() + password.length)];
        int n = 0;
        int length = user.length();
        for (int i = 0; i < length; ++i) {
            char c = user.charAt(i);
            buff[n++] = (byte)(c >> 8);
            buff[n++] = (byte)c;
        }
        for (char c : password) {
            buff[n++] = (byte)(c >> 8);
            buff[n++] = (byte)c;
        }
        Arrays.fill(password, '\u0000');
        return SHA256.getHash(buff, true);
    }

    public static byte[] getHash(byte[] data, boolean nullData) {
        int i;
        int byteLen = data.length;
        int intLen = (byteLen + 9 + 63) / 64 * 16;
        byte[] bytes = new byte[intLen * 4];
        System.arraycopy(data, 0, bytes, 0, byteLen);
        if (nullData) {
            Arrays.fill(data, (byte)0);
        }
        bytes[byteLen] = -128;
        int[] buff = new int[intLen];
        int i2 = 0;
        for (int j = 0; j < intLen; ++j) {
            buff[j] = SHA256.readInt(bytes, i2);
            i2 += 4;
        }
        buff[intLen - 2] = byteLen >>> 29;
        buff[intLen - 1] = byteLen << 3;
        int[] w = new int[64];
        int[] hh = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
        for (int block = 0; block < intLen; block += 16) {
            for (i = 0; i < 16; ++i) {
                w[i] = buff[block + i];
            }
            for (i = 16; i < 64; ++i) {
                int x = w[i - 2];
                int theta1 = SHA256.rot(x, 17) ^ SHA256.rot(x, 19) ^ x >>> 10;
                x = w[i - 15];
                int theta0 = SHA256.rot(x, 7) ^ SHA256.rot(x, 18) ^ x >>> 3;
                w[i] = theta1 + w[i - 7] + theta0 + w[i - 16];
            }
            int a = hh[0];
            int b = hh[1];
            int c = hh[2];
            int d = hh[3];
            int e = hh[4];
            int f = hh[5];
            int g = hh[6];
            int h = hh[7];
            for (int i3 = 0; i3 < 64; ++i3) {
                int t1 = h + (SHA256.rot(e, 6) ^ SHA256.rot(e, 11) ^ SHA256.rot(e, 25)) + (e & f ^ ~e & g) + K[i3] + w[i3];
                int t2 = (SHA256.rot(a, 2) ^ SHA256.rot(a, 13) ^ SHA256.rot(a, 22)) + (a & b ^ a & c ^ b & c);
                h = g;
                g = f;
                f = e;
                e = d + t1;
                d = c;
                c = b;
                b = a;
                a = t1 + t2;
            }
            hh[0] = hh[0] + a;
            hh[1] = hh[1] + b;
            hh[2] = hh[2] + c;
            hh[3] = hh[3] + d;
            hh[4] = hh[4] + e;
            hh[5] = hh[5] + f;
            hh[6] = hh[6] + g;
            hh[7] = hh[7] + h;
        }
        byte[] result = new byte[32];
        for (i = 0; i < 8; ++i) {
            SHA256.writeInt(result, i * 4, hh[i]);
        }
        Arrays.fill(w, 0);
        Arrays.fill(buff, 0);
        Arrays.fill(hh, 0);
        Arrays.fill(bytes, (byte)0);
        return result;
    }

    private static int rot(int i, int count) {
        return i << 32 - count | i >>> count;
    }

    private static int readInt(byte[] b, int i) {
        return ((b[i] & 0xFF) << 24) + ((b[i + 1] & 0xFF) << 16) + ((b[i + 2] & 0xFF) << 8) + (b[i + 3] & 0xFF);
    }

    private static void writeInt(byte[] b, int i, int value) {
        b[i] = (byte)(value >> 24);
        b[i + 1] = (byte)(value >> 16);
        b[i + 2] = (byte)(value >> 8);
        b[i + 3] = (byte)value;
    }
}

