/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.util.HashMap;
import java.util.HashSet;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleHead;
import org.h2.bnf.Sentence;
import org.h2.command.Parser;
import org.h2.message.DbException;
import org.h2.server.web.DbColumn;
import org.h2.server.web.DbContents;
import org.h2.server.web.DbSchema;
import org.h2.server.web.DbTableOrView;
import org.h2.util.StringUtils;

public class DbContextRule
implements Rule {
    static final int COLUMN = 0;
    static final int TABLE = 1;
    static final int TABLE_ALIAS = 2;
    static final int NEW_TABLE_ALIAS = 3;
    static final int COLUMN_ALIAS = 4;
    static final int SCHEMA = 5;
    private DbContents contents;
    private int type;

    DbContextRule(DbContents contents, int type) {
        this.contents = contents;
        this.type = type;
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> ruleMap) {
    }

    @Override
    public void accept(BnfVisitor visitor) {
    }

    @Override
    public boolean autoComplete(Sentence sentence) {
        String query;
        String s = query = sentence.getQuery();
        String up = sentence.getQueryUpper();
        switch (this.type) {
            case 5: {
                DbSchema[] schemas = this.contents.schemas;
                String best = null;
                DbSchema bestSchema = null;
                for (DbSchema schema : schemas) {
                    String name = StringUtils.toUpperEnglish(schema.name);
                    if (up.startsWith(name)) {
                        if (best != null && name.length() <= best.length()) continue;
                        best = name;
                        bestSchema = schema;
                        continue;
                    }
                    if (s.length() != 0 && !name.startsWith(up) || s.length() >= name.length()) continue;
                    sentence.add(name, name.substring(s.length()), this.type);
                    sentence.add(schema.quotedName + ".", schema.quotedName.substring(s.length()) + ".", 0);
                }
                if (best == null) break;
                sentence.setLastMatchedSchema(bestSchema);
                s = s.substring(best.length());
                break;
            }
            case 1: {
                DbSchema schema = sentence.getLastMatchedSchema();
                if (schema == null) {
                    schema = this.contents.defaultSchema;
                }
                DbTableOrView[] tables = schema.tables;
                String best = null;
                DbTableOrView bestTable = null;
                for (DbTableOrView table : tables) {
                    String compare = up;
                    String name = StringUtils.toUpperEnglish(table.name);
                    if (table.quotedName.length() > name.length()) {
                        name = table.quotedName;
                        compare = query;
                    }
                    if (compare.startsWith(name)) {
                        if (best != null && name.length() <= best.length()) continue;
                        best = name;
                        bestTable = table;
                        continue;
                    }
                    if (s.length() != 0 && !name.startsWith(compare) || s.length() >= name.length()) continue;
                    sentence.add(table.quotedName, table.quotedName.substring(s.length()), 0);
                }
                if (best == null) break;
                sentence.setLastMatchedTable(bestTable);
                sentence.addTable(bestTable);
                s = s.substring(best.length());
                break;
            }
            case 3: {
                s = DbContextRule.autoCompleteTableAlias(sentence, true);
                break;
            }
            case 2: {
                s = DbContextRule.autoCompleteTableAlias(sentence, false);
                break;
            }
            case 4: {
                String alias;
                char ch;
                int i;
                if (query.indexOf(32) < 0) break;
                for (i = 0; i < up.length() && ((ch = up.charAt(i)) == '_' || Character.isLetterOrDigit(ch)); ++i) {
                }
                if (i == 0 || Parser.isKeyword(alias = up.substring(0, i), true)) break;
                s = s.substring(alias.length());
                break;
            }
            case 0: {
                HashSet<DbTableOrView> set = sentence.getTables();
                String best = null;
                DbTableOrView last = sentence.getLastMatchedTable();
                if (last != null && last.columns != null) {
                    for (DbColumn column : last.columns) {
                        String compare = up;
                        String name = StringUtils.toUpperEnglish(column.name);
                        if (column.quotedName.length() > name.length()) {
                            name = column.quotedName;
                            compare = query;
                        }
                        if (!compare.startsWith(name)) continue;
                        String b = s.substring(name.length());
                        if (best == null || b.length() < best.length()) {
                            best = b;
                            continue;
                        }
                        if (s.length() != 0 && !name.startsWith(compare) || s.length() >= name.length()) continue;
                        sentence.add(column.name, column.name.substring(s.length()), 0);
                    }
                }
                for (DbSchema schema : this.contents.schemas) {
                    for (DbTableOrView table : schema.tables) {
                        if (table != last && set != null && !set.contains(table) || table == null || table.columns == null) continue;
                        for (DbColumn column : table.columns) {
                            String name = StringUtils.toUpperEnglish(column.name);
                            if (up.startsWith(name)) {
                                String b = s.substring(name.length());
                                if (best != null && b.length() >= best.length()) continue;
                                best = b;
                                continue;
                            }
                            if (s.length() != 0 && !name.startsWith(up) || s.length() >= name.length()) continue;
                            sentence.add(column.name, column.name.substring(s.length()), 0);
                        }
                    }
                }
                if (best == null) break;
                s = best;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.type);
            }
        }
        if (!s.equals(query)) {
            while (s.length() > 0 && Character.isSpaceChar(s.charAt(0))) {
                s = s.substring(1);
            }
            sentence.setQuery(s);
            return true;
        }
        return false;
    }

    private static String autoCompleteTableAlias(Sentence sentence, boolean newAlias) {
        HashMap<String, DbTableOrView> map;
        char ch;
        int i;
        String s = sentence.getQuery();
        String up = sentence.getQueryUpper();
        for (i = 0; i < up.length() && ((ch = up.charAt(i)) == '_' || Character.isLetterOrDigit(ch)); ++i) {
        }
        if (i == 0) {
            return s;
        }
        String alias = up.substring(0, i);
        if ("SET".equals(alias) || Parser.isKeyword(alias, true)) {
            return s;
        }
        if (newAlias) {
            sentence.addAlias(alias, sentence.getLastTable());
        }
        if ((map = sentence.getAliases()) != null && map.containsKey(alias) || sentence.getLastTable() == null) {
            if (newAlias && s.length() == alias.length()) {
                return s;
            }
            if ((s = s.substring(alias.length())).length() == 0) {
                sentence.add(alias + ".", ".", 0);
            }
            return s;
        }
        HashSet<DbTableOrView> tables = sentence.getTables();
        if (tables != null) {
            String best = null;
            for (DbTableOrView table : tables) {
                String tableName = StringUtils.toUpperEnglish(table.name);
                if (alias.startsWith(tableName) && (best == null || tableName.length() > best.length())) {
                    sentence.setLastMatchedTable(table);
                    best = tableName;
                    continue;
                }
                if (s.length() != 0 && !tableName.startsWith(alias)) continue;
                sentence.add(tableName + ".", tableName.substring(s.length()) + ".", 0);
            }
            if (best != null) {
                if ((s = s.substring(best.length())).length() == 0) {
                    sentence.add(alias + ".", ".", 0);
                }
                return s;
            }
        }
        return s;
    }
}

