/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.tools.CompressTool;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;

public class LobStorage {
    public static final int TABLE_ID_SESSION_VARIABLE = -1;
    public static final int TABLE_TEMP = -2;
    public static final String LOB_DATA_TABLE = "LOB_DATA";
    private static final String LOB_SCHEMA = "INFORMATION_SCHEMA";
    private static final String LOBS = "INFORMATION_SCHEMA.LOBS";
    private static final String LOB_MAP = "INFORMATION_SCHEMA.LOB_MAP";
    private static final String LOB_DATA = "INFORMATION_SCHEMA.LOB_DATA";
    private static final int BLOCK_LENGTH = 20000;
    private static final int HASH_CACHE_SIZE = 4096;
    private Connection conn;
    private HashMap<String, PreparedStatement> prepared = New.hashMap();
    private long nextBlock;
    private CompressTool compress = CompressTool.getInstance();
    private long[] hashBlocks;
    private final DataHandler handler;
    private boolean init;

    public LobStorage(DataHandler handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.init) {
            return;
        }
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            this.conn = this.handler.getLobConnection();
            this.init = true;
            if (this.conn == null) {
                return;
            }
            try {
                Statement stat = this.conn.createStatement();
                boolean create = true;
                PreparedStatement prep = this.conn.prepareStatement("SELECT ZERO() FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND COLUMN_NAME=?");
                prep.setString(1, LOB_SCHEMA);
                prep.setString(2, "LOB_MAP");
                prep.setString(3, "POS");
                ResultSet rs = prep.executeQuery();
                if (rs.next()) {
                    prep = this.conn.prepareStatement("SELECT ZERO() FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? AND TABLE_NAME=?");
                    prep.setString(1, LOB_SCHEMA);
                    prep.setString(2, LOB_DATA_TABLE);
                    rs = prep.executeQuery();
                    if (rs.next()) {
                        create = false;
                    }
                }
                if (create) {
                    stat.execute("CREATE CACHED TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOBS(ID BIGINT PRIMARY KEY, BYTE_COUNT BIGINT, TABLE INT) HIDDEN");
                    stat.execute("CREATE INDEX IF NOT EXISTS INFORMATION_SCHEMA.INDEX_LOB_TABLE ON INFORMATION_SCHEMA.LOBS(TABLE)");
                    stat.execute("CREATE CACHED TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_MAP(LOB BIGINT, SEQ INT, POS BIGINT, HASH INT, BLOCK BIGINT, PRIMARY KEY(LOB, SEQ)) HIDDEN");
                    stat.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP RENAME TO INFORMATION_SCHEMA.LOB_MAP HIDDEN");
                    stat.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP ADD IF NOT EXISTS POS BIGINT BEFORE HASH");
                    stat.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP DROP COLUMN IF EXISTS \"OFFSET\"");
                    stat.execute("CREATE INDEX IF NOT EXISTS INFORMATION_SCHEMA.INDEX_LOB_MAP_DATA_LOB ON INFORMATION_SCHEMA.LOB_MAP(BLOCK, LOB)");
                    stat.execute("CREATE CACHED TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_DATA(BLOCK BIGINT PRIMARY KEY, COMPRESSED INT, DATA BINARY) HIDDEN");
                }
                rs = stat.executeQuery("SELECT MAX(BLOCK) FROM INFORMATION_SCHEMA.LOB_DATA");
                rs.next();
                this.nextBlock = rs.getLong(1) + 1L;
                stat.close();
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        }
    }

    private long getNextLobId() throws SQLException {
        String sql = "SELECT MAX(LOB) FROM INFORMATION_SCHEMA.LOB_MAP";
        PreparedStatement prep = this.prepare(sql);
        ResultSet rs = prep.executeQuery();
        rs.next();
        long x = rs.getLong(1) + 1L;
        this.reuse(sql, prep);
        sql = "SELECT MAX(ID) FROM INFORMATION_SCHEMA.LOBS";
        prep = this.prepare(sql);
        rs = prep.executeQuery();
        rs.next();
        x = Math.max(x, rs.getLong(1) + 1L);
        this.reuse(sql, prep);
        return x;
    }

    public void removeAllForTable(int tableId) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            try {
                String sql = "SELECT ID FROM INFORMATION_SCHEMA.LOBS WHERE TABLE = ?";
                PreparedStatement prep = this.prepare(sql);
                prep.setInt(1, tableId);
                ResultSet rs = prep.executeQuery();
                while (rs.next()) {
                    this.removeLob(rs.getLong(1));
                }
                this.reuse(sql, prep);
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
            if (tableId == -1) {
                this.removeAllForTable(-2);
            }
        }
        ValueLob.removeAllForTable(this.handler, tableId);
    }

    public static Value createSmallLob(int type, byte[] small) {
        if (SysProperties.LOB_IN_DATABASE) {
            int precision = type == 16 ? StringUtils.utf8Decode(small).length() : small.length;
            return ValueLobDb.createSmallLob(type, small, precision);
        }
        return ValueLob.createSmallLob(type, small);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readBlock(long lob, int seq) throws SQLException {
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            String sql = "SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_MAP M INNER JOIN INFORMATION_SCHEMA.LOB_DATA D ON M.BLOCK = D.BLOCK WHERE M.LOB = ? AND M.SEQ = ?";
            PreparedStatement prep = this.prepare(sql);
            prep.setLong(1, lob);
            prep.setInt(2, seq);
            ResultSet rs = prep.executeQuery();
            if (!rs.next()) {
                throw DbException.get(90028, "Missing lob entry: " + lob + "/" + seq).getSQLException();
            }
            int compressed = rs.getInt(1);
            byte[] buffer = rs.getBytes(2);
            if (compressed != 0) {
                buffer = this.compress.expand(buffer);
            }
            this.reuse(sql, prep);
            return buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] skipBuffer(long lob, long pos) throws SQLException {
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            long[] lArray;
            String sql = "SELECT MAX(SEQ), MAX(POS) FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ? AND POS < ?";
            PreparedStatement prep = this.prepare(sql);
            prep.setLong(1, lob);
            prep.setLong(2, pos);
            ResultSet rs = prep.executeQuery();
            rs.next();
            int seq = rs.getInt(1);
            pos = rs.getLong(2);
            boolean wasNull = rs.wasNull();
            rs.close();
            this.reuse(sql, prep);
            if (wasNull) {
                lArray = null;
            } else {
                long[] lArray2 = new long[2];
                lArray2[0] = seq;
                lArray = lArray2;
                lArray2[1] = pos;
            }
            return lArray;
        }
    }

    private PreparedStatement prepare(String sql) throws SQLException {
        if (SysProperties.CHECK2 && !Thread.holdsLock(this.handler)) {
            throw DbException.throwInternalError();
        }
        PreparedStatement prep = this.prepared.remove(sql);
        if (prep == null) {
            prep = this.conn.prepareStatement(sql);
        }
        return prep;
    }

    private void reuse(String sql, PreparedStatement prep) {
        if (SysProperties.CHECK2 && !Thread.holdsLock(this.handler)) {
            throw DbException.throwInternalError();
        }
        this.prepared.put(sql, prep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLob(long lob) {
        try {
            DataHandler dataHandler = this.handler;
            synchronized (dataHandler) {
                if (this.conn == null) {
                    return;
                }
                String sql = "SELECT BLOCK, HASH FROM INFORMATION_SCHEMA.LOB_MAP D WHERE D.LOB = ? AND NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.LOB_MAP O WHERE O.BLOCK = D.BLOCK AND O.LOB <> ?)";
                PreparedStatement prep = this.prepare(sql);
                prep.setLong(1, lob);
                prep.setLong(2, lob);
                ResultSet rs = prep.executeQuery();
                ArrayList blocks = New.arrayList();
                while (rs.next()) {
                    blocks.add(rs.getLong(1));
                    int hash = rs.getInt(2);
                    this.setHashCacheBlock(hash, -1L);
                }
                this.reuse(sql, prep);
                sql = "DELETE FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?";
                prep = this.prepare(sql);
                prep.setLong(1, lob);
                prep.execute();
                this.reuse(sql, prep);
                sql = "DELETE FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?";
                prep = this.prepare(sql);
                Iterator i$ = blocks.iterator();
                while (i$.hasNext()) {
                    long block = (Long)i$.next();
                    prep.setLong(1, block);
                    prep.execute();
                }
                this.reuse(sql, prep);
                sql = "DELETE FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                prep = this.prepare(sql);
                prep.setLong(1, lob);
                prep.execute();
                this.reuse(sql, prep);
            }
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(long lobId, byte[] hmac, long byteCount) throws IOException {
        this.init();
        if (this.conn == null) {
            if (byteCount < 0L) {
                byteCount = Long.MAX_VALUE;
            }
            return new BufferedInputStream(new RemoteInputStream(this.handler, lobId, hmac, byteCount));
        }
        if (byteCount == -1L) {
            DataHandler dataHandler = this.handler;
            synchronized (dataHandler) {
                try {
                    String sql = "SELECT BYTE_COUNT FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                    PreparedStatement prep = this.prepare(sql);
                    prep.setLong(1, lobId);
                    ResultSet rs = prep.executeQuery();
                    if (!rs.next()) {
                        throw DbException.get(90028, "Missing lob: " + lobId).getSQLException();
                    }
                    byteCount = rs.getLong(1);
                    this.reuse(sql, prep);
                }
                catch (SQLException e) {
                    throw DbException.convertToIOException(e);
                }
            }
        }
        return new LobInputStream(lobId, byteCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueLobDb addLob(InputStream in, long maxLength, int type) {
        try {
            byte[] buff = new byte[20000];
            if (maxLength < 0L) {
                maxLength = Long.MAX_VALUE;
            }
            long length = 0L;
            long lobId = -1L;
            int maxLengthInPlaceLob = this.handler.getMaxLengthInplaceLob();
            String compressAlgorithm = this.handler.getLobCompressionAlgorithm(type);
            try {
                byte[] small = null;
                int seq = 0;
                while (maxLength > 0L) {
                    byte[] b;
                    int len = (int)Math.min(20000L, maxLength);
                    if ((len = IOUtils.readFully(in, buff, 0, len)) <= 0) break;
                    maxLength -= (long)len;
                    if (len != buff.length) {
                        b = new byte[len];
                        System.arraycopy(buff, 0, b, 0, len);
                    } else {
                        b = buff;
                    }
                    if (seq == 0 && b.length < 20000 && b.length <= maxLengthInPlaceLob) {
                        small = b;
                        break;
                    }
                    DataHandler dataHandler = this.handler;
                    synchronized (dataHandler) {
                        if (seq == 0) {
                            lobId = this.getNextLobId();
                        }
                        this.storeBlock(lobId, seq, length, b, compressAlgorithm);
                    }
                    length += (long)len;
                    ++seq;
                }
                if (lobId == -1L && small == null) {
                    small = new byte[]{};
                }
                if (small != null) {
                    ValueLobDb v = ValueLobDb.createSmallLob(type, small, small.length);
                    return v;
                }
                return this.registerLob(type, lobId, -2, length);
            }
            catch (IOException e) {
                if (lobId != -1L) {
                    this.removeLob(lobId);
                }
                throw DbException.convertIOException(e, null);
            }
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    private ValueLobDb registerLob(int type, long lobId, int tableId, long byteCount) {
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            try {
                String sql = "INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, TABLE) VALUES(?, ?, ?)";
                PreparedStatement prep = this.prepare(sql);
                prep.setLong(1, lobId);
                prep.setLong(2, byteCount);
                prep.setInt(3, tableId);
                prep.execute();
                this.reuse(sql, prep);
                ValueLobDb v = ValueLobDb.create(type, this, tableId, lobId, null, byteCount);
                return v;
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        }
    }

    public ValueLobDb copyLob(int type, long oldLobId, int tableId, long length) {
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            try {
                this.init();
                long lobId = this.getNextLobId();
                String sql = "INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, POS, HASH, BLOCK) SELECT ?, SEQ, POS, HASH, BLOCK FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?";
                PreparedStatement prep = this.prepare(sql);
                prep.setLong(1, lobId);
                prep.setLong(2, oldLobId);
                prep.executeUpdate();
                this.reuse(sql, prep);
                sql = "INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, TABLE) SELECT ?, BYTE_COUNT, ? FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                prep = this.prepare(sql);
                prep.setLong(1, lobId);
                prep.setLong(2, tableId);
                prep.setLong(3, oldLobId);
                prep.executeUpdate();
                this.reuse(sql, prep);
                ValueLobDb v = ValueLobDb.create(type, this, tableId, lobId, null, length);
                return v;
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        }
    }

    private long getHashCacheBlock(int hash) {
        this.initHashCache();
        int index = hash & 0xFFF;
        long oldHash = this.hashBlocks[index];
        if (oldHash == (long)hash) {
            return this.hashBlocks[index + 4096];
        }
        return -1L;
    }

    private void setHashCacheBlock(int hash, long block) {
        this.initHashCache();
        int index = hash & 0xFFF;
        this.hashBlocks[index] = hash;
        this.hashBlocks[index + 4096] = block;
    }

    private void initHashCache() {
        if (this.hashBlocks == null) {
            this.hashBlocks = new long[8192];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeBlock(long lobId, int seq, long pos, byte[] b, String compressAlgorithm) throws SQLException {
        boolean blockExists = false;
        if (compressAlgorithm != null) {
            b = this.compress.compress(b, compressAlgorithm);
        }
        int hash = Arrays.hashCode(b);
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            PreparedStatement prep;
            String sql;
            long block = this.getHashCacheBlock(hash);
            if (block != -1L) {
                sql = "SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?";
                prep = this.prepare(sql);
                prep.setLong(1, block);
                ResultSet rs = prep.executeQuery();
                if (rs.next()) {
                    boolean compressed = rs.getInt(1) != 0;
                    byte[] compare = rs.getBytes(2);
                    if (compressed == (compressAlgorithm != null) && Arrays.equals(b, compare)) {
                        blockExists = true;
                    }
                }
                this.reuse(sql, prep);
            }
            if (!blockExists) {
                block = this.nextBlock++;
                this.setHashCacheBlock(hash, block);
                sql = "INSERT INTO INFORMATION_SCHEMA.LOB_DATA(BLOCK, COMPRESSED, DATA) VALUES(?, ?, ?)";
                prep = this.prepare(sql);
                prep.setLong(1, block);
                prep.setInt(2, compressAlgorithm == null ? 0 : 1);
                prep.setBytes(3, b);
                prep.execute();
                this.reuse(sql, prep);
            }
            sql = "INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, POS, HASH, BLOCK) VALUES(?, ?, ?, ?, ?)";
            prep = this.prepare(sql);
            prep.setLong(1, lobId);
            prep.setInt(2, seq);
            prep.setLong(3, pos);
            prep.setLong(4, hash);
            prep.setLong(5, block);
            prep.execute();
            this.reuse(sql, prep);
        }
    }

    public Value createBlob(InputStream in, long maxLength) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            if (this.conn == null) {
                return ValueLobDb.createTempBlob(in, maxLength, this.handler);
            }
            return this.addLob(in, maxLength, 15);
        }
        return ValueLob.createBlob(in, maxLength, this.handler);
    }

    public Value createClob(Reader reader, long maxLength) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            if (this.conn == null) {
                return ValueLobDb.createTempClob(reader, maxLength, this.handler);
            }
            long max = maxLength == -1L ? Long.MAX_VALUE : maxLength;
            CountingReaderInputStream in = new CountingReaderInputStream(reader, max);
            ValueLobDb lob = this.addLob(in, Long.MAX_VALUE, 16);
            lob.setPrecision(in.getLength());
            return lob;
        }
        return ValueLob.createClob(reader, maxLength, this.handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(long lobId, int table) {
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            try {
                this.init();
                String sql = "UPDATE INFORMATION_SCHEMA.LOBS SET TABLE = ? WHERE ID = ?";
                PreparedStatement prep = this.prepare(sql);
                prep.setInt(1, table);
                prep.setLong(2, lobId);
                prep.executeUpdate();
                this.reuse(sql, prep);
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        }
    }

    static class CountingReaderInputStream
    extends InputStream {
        private final Reader reader;
        private long length;
        private long remaining;
        private int pos;
        private char[] charBuffer = new char[4096];
        private byte[] buffer;

        CountingReaderInputStream(Reader reader, long maxLength) {
            this.reader = reader;
            this.remaining = maxLength;
            this.buffer = Utils.EMPTY_BYTES;
        }

        @Override
        public int read(byte[] buff, int offset, int len) throws IOException {
            if (this.buffer == null) {
                return -1;
            }
            if (this.pos >= this.buffer.length) {
                this.fillBuffer();
                if (this.buffer == null) {
                    return -1;
                }
            }
            len = Math.min(len, this.buffer.length - this.pos);
            System.arraycopy(this.buffer, this.pos, buff, offset, len);
            this.pos += len;
            return len;
        }

        @Override
        public int read() throws IOException {
            if (this.buffer == null) {
                return -1;
            }
            if (this.pos >= this.buffer.length) {
                this.fillBuffer();
                if (this.buffer == null) {
                    return -1;
                }
            }
            return this.buffer[this.pos++];
        }

        private void fillBuffer() throws IOException {
            int len = (int)Math.min((long)this.charBuffer.length, this.remaining);
            len = len > 0 ? this.reader.read(this.charBuffer, 0, len) : -1;
            if (len < 0) {
                this.buffer = null;
            } else {
                this.buffer = StringUtils.utf8Encode(new String(this.charBuffer, 0, len));
                this.length += (long)len;
                this.remaining -= (long)len;
            }
            this.pos = 0;
        }

        public long getLength() {
            return this.length;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    public class LobInputStream
    extends InputStream {
        private long length;
        private long remainingBytes;
        private byte[] buffer;
        private int pos;
        private long lob;
        private int seq;

        public LobInputStream(long lob, long byteCount) {
            this.lob = lob;
            this.remainingBytes = byteCount;
            this.length = byteCount;
        }

        @Override
        public int read() throws IOException {
            this.fillBuffer();
            if (this.remainingBytes <= 0L) {
                return -1;
            }
            --this.remainingBytes;
            return this.buffer[this.pos++] & 0xFF;
        }

        @Override
        public long skip(long n) throws IOException {
            long remaining = n;
            if ((remaining -= (long)this.skipSmall(remaining)) > 20000L) {
                long toPos = this.length - this.remainingBytes + remaining;
                try {
                    long[] seqPos = LobStorage.this.skipBuffer(this.lob, toPos);
                    if (seqPos == null) {
                        remaining -= super.skip(remaining);
                        return n - remaining;
                    }
                    this.seq = (int)seqPos[0];
                    long p = seqPos[1];
                    this.remainingBytes = this.length - p;
                    remaining = toPos - p;
                }
                catch (SQLException e) {
                    throw DbException.convertToIOException(e);
                }
                this.pos = 0;
                this.buffer = null;
            }
            this.fillBuffer();
            remaining -= (long)this.skipSmall(remaining);
            remaining -= super.skip(remaining);
            return n - remaining;
        }

        private int skipSmall(long n) {
            if (n > 0L && this.buffer != null && this.pos < this.buffer.length) {
                int x = MathUtils.convertLongToInt(Math.min(n, (long)(this.buffer.length - this.pos)));
                n -= (long)x;
                this.pos += x;
                this.remainingBytes -= (long)x;
                return x;
            }
            return 0;
        }

        @Override
        public int read(byte[] buff) throws IOException {
            return this.readFully(buff, 0, buff.length);
        }

        @Override
        public int read(byte[] buff, int off, int length) throws IOException {
            return this.readFully(buff, off, length);
        }

        private int readFully(byte[] buff, int off, int length) throws IOException {
            if (length == 0) {
                return 0;
            }
            int read = 0;
            while (length > 0) {
                this.fillBuffer();
                if (this.remainingBytes <= 0L) break;
                int len = (int)Math.min((long)length, this.remainingBytes);
                len = Math.min(len, this.buffer.length - this.pos);
                System.arraycopy(this.buffer, this.pos, buff, off, len);
                this.pos += len;
                read += len;
                this.remainingBytes -= (long)len;
                off += len;
                length -= len;
            }
            return read == 0 ? -1 : read;
        }

        private void fillBuffer() throws IOException {
            if (this.buffer != null && this.pos < this.buffer.length) {
                return;
            }
            if (this.remainingBytes <= 0L) {
                return;
            }
            try {
                this.buffer = LobStorage.this.readBlock(this.lob, this.seq++);
                this.pos = 0;
            }
            catch (SQLException e) {
                throw DbException.convertToIOException(e);
            }
        }
    }

    public static class RemoteInputStream
    extends InputStream {
        private final DataHandler handler;
        private final long lob;
        private final byte[] hmac;
        private long pos;
        private long remainingBytes;

        public RemoteInputStream(DataHandler handler, long lob, byte[] hmac, long byteCount) {
            this.handler = handler;
            this.lob = lob;
            this.hmac = hmac;
            this.remainingBytes = byteCount;
        }

        @Override
        public int read() throws IOException {
            byte[] buff = new byte[1];
            int len = this.read(buff, 0, 1);
            return len < 0 ? len : buff[0] & 0xFF;
        }

        @Override
        public int read(byte[] buff) throws IOException {
            return this.read(buff, 0, buff.length);
        }

        @Override
        public int read(byte[] buff, int off, int length) throws IOException {
            if (length == 0) {
                return 0;
            }
            if ((length = (int)Math.min((long)length, this.remainingBytes)) == 0) {
                return -1;
            }
            length = this.handler.readLob(this.lob, this.hmac, this.pos, buff, off, length);
            this.remainingBytes -= (long)length;
            if (length == 0) {
                return -1;
            }
            this.pos += (long)length;
            return length;
        }

        @Override
        public long skip(long n) {
            this.remainingBytes -= n;
            this.pos += n;
            return n;
        }
    }
}

