/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileDisk;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.util.Utils;

public class FilePathDisk
extends FilePath {
    private static final String CLASSPATH_PREFIX = "classpath:";

    @Override
    public FilePathDisk getPath(String path) {
        FilePathDisk p = new FilePathDisk();
        p.name = FilePathDisk.translateFileName(path);
        return p;
    }

    @Override
    public long size() {
        return new File(this.name).length();
    }

    protected static String translateFileName(String fileName) {
        if ((fileName = fileName.replace('\\', '/')).startsWith("file:")) {
            fileName = fileName.substring("file:".length());
        }
        return FilePathDisk.expandUserHomeDirectory(fileName);
    }

    public static String expandUserHomeDirectory(String fileName) {
        if (fileName.startsWith("~") && (fileName.length() == 1 || fileName.startsWith("~/"))) {
            String userDir = SysProperties.USER_HOME;
            fileName = userDir + fileName.substring(1);
        }
        return fileName;
    }

    @Override
    public void moveTo(FilePath newName) {
        File oldFile = new File(this.name);
        File newFile = new File(newName.name);
        if (oldFile.getAbsolutePath().equals(newFile.getAbsolutePath())) {
            return;
        }
        if (!oldFile.exists()) {
            throw DbException.get(90024, this.name + " (not found)", newName.name);
        }
        if (newFile.exists()) {
            throw DbException.get(90024, this.name, newName + " (exists)");
        }
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            IOUtils.trace("rename", this.name + " >" + newName, null);
            boolean ok = oldFile.renameTo(newFile);
            if (ok) {
                return;
            }
            FilePathDisk.wait(i);
        }
        throw DbException.get(90024, this.name, newName.name);
    }

    private static void wait(int i) {
        if (i == 8) {
            System.gc();
        }
        try {
            long sleep = Math.min(256, i * i);
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean createFile() {
        File file = new File(this.name);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                FilePathDisk.wait(i);
                continue;
            }
        }
        return false;
    }

    @Override
    public boolean exists() {
        return new File(this.name).exists();
    }

    @Override
    public void delete() {
        File file = new File(this.name);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            IOUtils.trace("delete", this.name, null);
            boolean ok = file.delete();
            if (ok || !file.exists()) {
                return;
            }
            FilePathDisk.wait(i);
        }
        throw DbException.get(90025, this.name);
    }

    @Override
    public List<FilePath> newDirectoryStream() {
        ArrayList<FilePath> list = New.arrayList();
        File f = new File(this.name);
        try {
            String[] files = f.list();
            if (files != null) {
                String base = f.getCanonicalPath();
                if (!base.endsWith(SysProperties.FILE_SEPARATOR)) {
                    base = base + SysProperties.FILE_SEPARATOR;
                }
                int len = files.length;
                for (int i = 0; i < len; ++i) {
                    list.add(this.getPath(base + files[i]));
                }
            }
            return list;
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.name);
        }
    }

    @Override
    public boolean canWrite() {
        return FilePathDisk.canWriteInternal(new File(this.name));
    }

    @Override
    public boolean setReadOnly() {
        File f = new File(this.name);
        return f.setReadOnly();
    }

    @Override
    public FilePathDisk toRealPath() {
        try {
            String fileName = new File(this.name).getCanonicalPath();
            return this.getPath(fileName);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.name);
        }
    }

    @Override
    public FilePath getParent() {
        String p = new File(this.name).getParent();
        return p == null ? null : this.getPath(p);
    }

    @Override
    public boolean isDirectory() {
        return new File(this.name).isDirectory();
    }

    @Override
    public boolean isAbsolute() {
        return new File(this.name).isAbsolute();
    }

    @Override
    public long lastModified() {
        return new File(this.name).lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWriteInternal(File file) {
        try {
            if (!file.canWrite()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        RandomAccessFile r = null;
        try {
            r = new RandomAccessFile(file, "rw");
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void createDirectory() {
        File f = new File(this.name);
        if (f.exists()) {
            if (f.isDirectory()) {
                return;
            }
            throw DbException.get(90062, this.name + " (a file with this name already exists)");
        }
        File dir = new File(this.name);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            if (dir.exists() && dir.isDirectory() || dir.mkdir()) {
                return;
            }
            FilePathDisk.wait(i);
        }
        throw DbException.get(90062, this.name);
    }

    @Override
    public OutputStream newOutputStream(boolean append) {
        try {
            File file = new File(this.name);
            File parent = file.getParentFile();
            if (parent != null) {
                FileUtils.createDirectories(parent.getAbsolutePath());
            }
            FileOutputStream out = new FileOutputStream(this.name, append);
            IOUtils.trace("openFileOutputStream", this.name, out);
            return out;
        }
        catch (IOException e) {
            FilePathDisk.freeMemoryAndFinalize();
            try {
                return new FileOutputStream(this.name);
            }
            catch (IOException e2) {
                throw DbException.convertIOException(e, this.name);
            }
        }
    }

    @Override
    public InputStream newInputStream() throws IOException {
        int index = this.name.indexOf(58);
        if (index > 1 && index < 20) {
            if (this.name.startsWith(CLASSPATH_PREFIX)) {
                InputStream in;
                String fileName = this.name.substring(CLASSPATH_PREFIX.length());
                if (!fileName.startsWith("/")) {
                    fileName = "/" + fileName;
                }
                if ((in = this.getClass().getResourceAsStream(fileName)) == null) {
                    in = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
                }
                if (in == null) {
                    throw new FileNotFoundException("resource " + fileName);
                }
                return in;
            }
            URL url = new URL(this.name);
            InputStream in = url.openStream();
            return in;
        }
        FileInputStream in = new FileInputStream(this.name);
        IOUtils.trace("openFileInputStream", this.name, in);
        return in;
    }

    static void freeMemoryAndFinalize() {
        IOUtils.trace("freeMemoryAndFinalize", null, null);
        Runtime rt = Runtime.getRuntime();
        long mem = rt.freeMemory();
        for (int i = 0; i < 16; ++i) {
            rt.gc();
            long now = rt.freeMemory();
            rt.runFinalization();
            if (now == mem) break;
            mem = now;
        }
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        FileDisk f;
        try {
            f = new FileDisk(this.name, mode);
            IOUtils.trace("open", this.name, f);
        }
        catch (IOException e) {
            FilePathDisk.freeMemoryAndFinalize();
            try {
                f = new FileDisk(this.name, mode);
            }
            catch (IOException e2) {
                throw e;
            }
        }
        return f;
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public FilePath createTempFile(String suffix, boolean deleteOnExit, boolean inTempDir) throws IOException {
        File f;
        String fileName = this.name + ".";
        String prefix = new File(fileName).getName();
        File dir = inTempDir ? new File(Utils.getProperty("java.io.tmpdir", ".")) : new File(fileName).getAbsoluteFile().getParentFile();
        FileUtils.createDirectories(dir.getAbsolutePath());
        while ((f = new File(dir, prefix + FilePathDisk.getNextTempFileNamePart(false) + suffix)).exists() || !f.createNewFile()) {
            FilePathDisk.getNextTempFileNamePart(true);
        }
        if (deleteOnExit) {
            try {
                f.deleteOnExit();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return FilePathDisk.get(f.getCanonicalPath());
    }
}

