/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.h2.message.DbException;
import org.h2.store.fs.FilePath;
import org.h2.util.IOUtils;
import org.h2.util.New;

public class FileUtils {
    public static boolean exists(String fileName) {
        return FilePath.get(fileName).exists();
    }

    public static void createDirectory(String directoryName) {
        FilePath.get(directoryName).createDirectory();
    }

    public static boolean createFile(String fileName) {
        return FilePath.get(fileName).createFile();
    }

    public static void delete(String path) {
        FilePath.get(path).delete();
    }

    public static String toRealPath(String fileName) {
        return FilePath.get(fileName).toRealPath().toString();
    }

    public static String getParent(String fileName) {
        FilePath p = FilePath.get(fileName).getParent();
        return p == null ? null : p.toString();
    }

    public static boolean isAbsolute(String fileName) {
        return FilePath.get(fileName).isAbsolute();
    }

    public static void moveTo(String oldName, String newName) {
        FilePath.get(oldName).moveTo(FilePath.get(newName));
    }

    public static String getName(String path) {
        return FilePath.get(path).getName();
    }

    public static List<String> newDirectoryStream(String path) {
        List<FilePath> list = FilePath.get(path).newDirectoryStream();
        int len = list.size();
        ArrayList<String> result = New.arrayList(len);
        for (int i = 0; i < len; ++i) {
            result.add(list.get(i).toString());
        }
        return result;
    }

    public static long lastModified(String fileName) {
        return FilePath.get(fileName).lastModified();
    }

    public static long size(String fileName) {
        return FilePath.get(fileName).size();
    }

    public static boolean isDirectory(String fileName) {
        return FilePath.get(fileName).isDirectory();
    }

    public static FileChannel open(String fileName, String mode) throws IOException {
        return FilePath.get(fileName).open(mode);
    }

    public static InputStream newInputStream(String fileName) throws IOException {
        return FilePath.get(fileName).newInputStream();
    }

    public static OutputStream newOutputStream(String fileName, boolean append) {
        return FilePath.get(fileName).newOutputStream(append);
    }

    public static boolean canWrite(String fileName) {
        return FilePath.get(fileName).canWrite();
    }

    public static boolean setReadOnly(String fileName) {
        return FilePath.get(fileName).setReadOnly();
    }

    public static String unwrap(String fileName) {
        return FilePath.get(fileName).unwrap().toString();
    }

    public static void deleteRecursive(String path, boolean tryOnly) {
        if (FileUtils.exists(path)) {
            if (FileUtils.isDirectory(path)) {
                for (String s : FileUtils.newDirectoryStream(path)) {
                    FileUtils.deleteRecursive(s, tryOnly);
                }
            }
            if (tryOnly) {
                FileUtils.tryDelete(path);
            } else {
                FileUtils.delete(path);
            }
        }
    }

    public static void createDirectories(String dir) {
        if (dir != null) {
            if (FileUtils.exists(dir)) {
                if (!FileUtils.isDirectory(dir)) {
                    DbException.get(90062, "Could not create directory, because a file with the same name already exists: " + dir);
                }
            } else {
                String parent = FileUtils.getParent(dir);
                FileUtils.createDirectories(parent);
                FileUtils.createDirectory(dir);
            }
        }
    }

    public static void copy(String original, String copy) throws IOException {
        InputStream in = FileUtils.newInputStream(original);
        OutputStream out = FileUtils.newOutputStream(copy, false);
        IOUtils.copyAndClose(in, out);
    }

    public static boolean tryDelete(String fileName) {
        try {
            FilePath.get(fileName).delete();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String createTempFile(String prefix, String suffix, boolean deleteOnExit, boolean inTempDir) throws IOException {
        return FilePath.get(prefix).createTempFile(suffix, deleteOnExit, inTempDir).toString();
    }

    public static void readFully(FileChannel channel, ByteBuffer dst) throws IOException {
        do {
            int r;
            if ((r = channel.read(dst)) >= 0) continue;
            throw new EOFException();
        } while (dst.remaining() > 0);
    }

    public static void writeFully(FileChannel channel, ByteBuffer src) throws IOException {
        do {
            channel.write(src);
        } while (src.remaining() > 0);
    }
}

