/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.h2.command.ddl.Analyze;
import org.h2.command.ddl.CreateTableData;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.HashIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionIndex;
import org.h2.index.NonUniqueHashIndex;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDelegateIndex;
import org.h2.index.ScanIndex;
import org.h2.index.TreeIndex;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class RegularTable
extends TableBase {
    private Index scanIndex;
    private long rowCount;
    private volatile Session lockExclusive;
    private HashSet<Session> lockShared = New.hashSet();
    private Trace traceLock;
    private final ArrayList<Index> indexes = New.arrayList();
    private long lastModificationId;
    private boolean containsLargeObject;
    private PageDataIndex mainIndex;
    private int changesSinceAnalyze;
    private int nextAnalyze;
    private Column rowIdColumn;
    private boolean waitForLock;

    public RegularTable(CreateTableData data) {
        super(data);
        this.nextAnalyze = this.database.getSettings().analyzeAuto;
        this.isHidden = data.isHidden;
        for (Column col : this.getColumns()) {
            if (!DataType.isLargeObject(col.getType())) continue;
            this.containsLargeObject = true;
        }
        if (data.persistData && this.database.isPersistent()) {
            this.mainIndex = new PageDataIndex(this, data.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(data.persistData), data.create, data.session);
            this.scanIndex = this.mainIndex;
        } else {
            this.scanIndex = new ScanIndex(this, data.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(data.persistData));
        }
        this.indexes.add(this.scanIndex);
        this.traceLock = this.database.getTrace("lock");
    }

    @Override
    public void close(Session session) {
        for (Index index : this.indexes) {
            index.close(session);
        }
    }

    public Row getRow(Session session, long key) {
        return this.scanIndex.getRow(session, key);
    }

    @Override
    public void addRow(Session session, Row row) {
        int i = 0;
        this.lastModificationId = this.database.getNextModificationDataId();
        if (this.database.isMultiVersion()) {
            row.setSessionId(session.getId());
        }
        try {
            int size = this.indexes.size();
            while (i < size) {
                Index index = this.indexes.get(i);
                index.add(session, row);
                this.checkRowCount(session, index, 1);
                ++i;
            }
            ++this.rowCount;
        }
        catch (Throwable e) {
            try {
                while (--i >= 0) {
                    Index index = this.indexes.get(i);
                    index.remove(session, row);
                    this.checkRowCount(session, index, 0);
                }
            }
            catch (DbException e2) {
                this.trace.error(e2, "could not undo operation");
                throw e2;
            }
            DbException de = DbException.convert(e);
            if (de.getErrorCode() == 23505) {
                for (int j = 0; j < this.indexes.size(); ++j) {
                    MultiVersionIndex mv;
                    Index index = this.indexes.get(j);
                    if (!index.getIndexType().isUnique() || !(index instanceof MultiVersionIndex) || !(mv = (MultiVersionIndex)index).isUncommittedFromOtherSession(session, row)) continue;
                    throw DbException.get(90131, index.getName());
                }
            }
            throw de;
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public void commit(short operation, Row row) {
        this.lastModificationId = this.database.getNextModificationDataId();
        int size = this.indexes.size();
        for (int i = 0; i < size; ++i) {
            Index index = this.indexes.get(i);
            index.commit(operation, row);
        }
    }

    private void checkRowCount(Session session, Index index, int offset) {
        long rc;
        if (SysProperties.CHECK && !this.database.isMultiVersion() && !(index instanceof PageDelegateIndex) && (rc = index.getRowCount(session)) != this.rowCount + (long)offset) {
            DbException.throwInternalError("rowCount expected " + (this.rowCount + (long)offset) + " got " + rc + " " + this.getName() + "." + index.getName());
        }
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.indexes.get(0);
    }

    @Override
    public Index getUniqueIndex() {
        for (Index idx : this.indexes) {
            if (!idx.getIndexType().isUnique()) continue;
            return idx;
        }
        return null;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        Index index;
        boolean isSessionTemporary;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn c : cols) {
                Column column = c.column;
                if (column.isNullable()) {
                    throw DbException.get(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        boolean bl = isSessionTemporary = this.isTemporary() && !this.isGlobalTemporary();
        if (!isSessionTemporary) {
            this.database.lockMeta(session);
        }
        if (this.isPersistIndexes() && indexType.isPersistent()) {
            int mainIndexColumn = this.database.isStarting() && this.database.getPageStore().getRootPageId(indexId) != 0 ? -1 : (!this.database.isStarting() && this.mainIndex.getRowCount(session) != 0L ? -1 : this.getMainIndexColumn(indexType, cols));
            if (mainIndexColumn != -1) {
                this.mainIndex.setMainIndexColumn(mainIndexColumn);
                index = new PageDelegateIndex(this, indexId, indexName, indexType, this.mainIndex, create, session);
            } else {
                index = new PageBtreeIndex(this, indexId, indexName, cols, indexType, create, session);
            }
        } else {
            index = indexType.isHash() && cols.length <= 1 ? (indexType.isUnique() ? new HashIndex(this, indexId, indexName, cols, indexType) : new NonUniqueHashIndex(this, indexId, indexName, cols, indexType)) : new TreeIndex(this, indexId, indexName, cols, indexType);
        }
        if (this.database.isMultiVersion()) {
            index = new MultiVersionIndex(index, this);
        }
        if (index.needRebuild() && this.rowCount > 0L) {
            try {
                long remaining;
                Index scan = this.getScanIndex(session);
                long total = remaining = scan.getRowCount(session);
                Cursor cursor = scan.find(session, null, null);
                long i = 0L;
                int bufferSize = (int)Math.min(this.rowCount, 10000L);
                ArrayList<Row> buffer = New.arrayList(bufferSize);
                String n = this.getName() + ":" + index.getName();
                int t = MathUtils.convertLongToInt(total);
                while (cursor.next()) {
                    this.database.setProgress(1, n, MathUtils.convertLongToInt(i++), t);
                    Row row = cursor.get();
                    buffer.add(row);
                    if (buffer.size() >= bufferSize) {
                        RegularTable.addRowsToIndex(session, buffer, index);
                    }
                    --remaining;
                }
                RegularTable.addRowsToIndex(session, buffer, index);
                if (SysProperties.CHECK && remaining != 0L) {
                    DbException.throwInternalError("rowcount remaining=" + remaining + " " + this.getName());
                }
            }
            catch (DbException e) {
                this.getSchema().freeUniqueName(indexName);
                try {
                    index.remove(session);
                }
                catch (DbException e2) {
                    this.trace.error(e2, "could not remove index");
                    throw e2;
                }
                throw e;
            }
        }
        index.setTemporary(this.isTemporary());
        if (index.getCreateSQL() != null) {
            index.setComment(indexComment);
            if (isSessionTemporary) {
                session.addLocalTempTableIndex(index);
            } else {
                this.database.addSchemaObject(session, index);
            }
        }
        this.indexes.add(index);
        this.setModified();
        return index;
    }

    private int getMainIndexColumn(IndexType indexType, IndexColumn[] cols) {
        if (this.mainIndex.getMainIndexColumn() != -1) {
            return -1;
        }
        if (!indexType.isPrimaryKey() || cols.length != 1) {
            return -1;
        }
        IndexColumn first = cols[0];
        if (first.sortType != 0) {
            return -1;
        }
        switch (first.column.getType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return -1;
            }
        }
        return first.column.getColumnId();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    private static void addRowsToIndex(Session session, ArrayList<Row> list, Index index) {
        final Index idx = index;
        Collections.sort(list, new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                return idx.compareRows(r1, r2);
            }
        });
        for (Row row : list) {
            index.add(session, row);
        }
        list.clear();
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            return this.getScanIndex(session).getRowCount(session);
        }
        return this.rowCount;
    }

    @Override
    public void removeRow(Session session, Row row) {
        int i;
        if (this.database.isMultiVersion()) {
            if (row.isDeleted()) {
                throw DbException.get(90131, this.getName());
            }
            int old = row.getSessionId();
            int newId = session.getId();
            if (old == 0) {
                row.setSessionId(newId);
            } else if (old != newId) {
                throw DbException.get(90131, this.getName());
            }
        }
        this.lastModificationId = this.database.getNextModificationDataId();
        try {
            for (i = this.indexes.size() - 1; i >= 0; --i) {
                Index index = this.indexes.get(i);
                index.remove(session, row);
                this.checkRowCount(session, index, -1);
            }
            --this.rowCount;
        }
        catch (Throwable e) {
            try {
                while (++i < this.indexes.size()) {
                    Index index = this.indexes.get(i);
                    index.add(session, row);
                    this.checkRowCount(session, index, 0);
                }
            }
            catch (DbException e2) {
                this.trace.error(e2, "could not undo operation");
                throw e2;
            }
            throw DbException.convert(e);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public void truncate(Session session) {
        this.lastModificationId = this.database.getNextModificationDataId();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            Index index = this.indexes.get(i);
            index.truncate(session);
        }
        this.rowCount = 0L;
        this.changesSinceAnalyze = 0;
    }

    private void analyzeIfRequired(Session session) {
        if (this.nextAnalyze == 0 || this.nextAnalyze > this.changesSinceAnalyze++) {
            return;
        }
        this.changesSinceAnalyze = 0;
        int n = 2 * this.nextAnalyze;
        if (n > 0) {
            this.nextAnalyze = n;
        }
        int rows = session.getDatabase().getSettings().analyzeSample;
        Analyze.analyzeTable(session, this, rows, false);
    }

    @Override
    public boolean isLockedExclusivelyBy(Session session) {
        return this.lockExclusive == session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Session session, boolean exclusive, boolean force) {
        int lockMode = this.database.getLockMode();
        if (lockMode == 0) {
            return;
        }
        if (!force && this.database.isMultiVersion()) {
            if (exclusive) {
                exclusive = false;
            } else if (this.lockExclusive == null) {
                return;
            }
        }
        if (this.lockExclusive == session) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            try {
                this.doLock(session, lockMode, exclusive);
            }
            finally {
                session.setWaitForLock(null);
            }
        }
    }

    private void doLock(Session session, int lockMode, boolean exclusive) {
        this.traceLock(session, exclusive, "requesting for");
        long max = 0L;
        boolean checkDeadlock = false;
        while (this.lockExclusive != session) {
            if (exclusive) {
                if (this.lockExclusive == null) {
                    if (this.lockShared.isEmpty()) {
                        this.traceLock(session, exclusive, "added for");
                        session.addLock(this);
                        this.lockExclusive = session;
                        return;
                    }
                    if (this.lockShared.size() == 1 && this.lockShared.contains(session)) {
                        this.traceLock(session, exclusive, "add (upgraded) for ");
                        this.lockExclusive = session;
                        return;
                    }
                }
            } else if (this.lockExclusive == null) {
                if (lockMode == 3 && !this.database.isMultiThreaded() && !this.database.isMultiVersion()) {
                    return;
                }
                if (!this.lockShared.contains(session)) {
                    this.traceLock(session, exclusive, "ok");
                    session.addLock(this);
                    this.lockShared.add(session);
                }
                return;
            }
            session.setWaitForLock(this);
            if (checkDeadlock) {
                ArrayList<Session> sessions = this.checkDeadlock(session, null, null);
                if (sessions != null) {
                    throw DbException.get(40001, RegularTable.getDeadlockDetails(sessions));
                }
            } else {
                checkDeadlock = true;
            }
            long now = System.currentTimeMillis();
            if (max == 0L) {
                max = now + (long)session.getLockTimeout();
            } else if (now >= max) {
                this.traceLock(session, exclusive, "timeout after " + session.getLockTimeout());
                throw DbException.get(50200, this.getName());
            }
            try {
                long sleep;
                this.traceLock(session, exclusive, "waiting for");
                if (this.database.getLockMode() == 2) {
                    for (int i = 0; i < 20; ++i) {
                        long free = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long free2 = Runtime.getRuntime().freeMemory();
                        if (free == free2) break;
                    }
                }
                if ((sleep = Math.min(100L, max - now)) == 0L) {
                    sleep = 1L;
                }
                this.waitForLock = true;
                this.database.wait(sleep);
            }
            catch (InterruptedException e) {
            }
        }
        return;
    }

    private static String getDeadlockDetails(ArrayList<Session> sessions) {
        StringBuilder buff = new StringBuilder();
        for (Session s : sessions) {
            Table lock = s.getWaitForLock();
            buff.append("\nSession ").append(s.toString()).append(" is waiting to lock ").append(lock.toString()).append(" while locking ");
            int i = 0;
            for (Table t : s.getLocks()) {
                if (i++ > 0) {
                    buff.append(", ");
                }
                buff.append(t.toString());
                if (!(t instanceof RegularTable)) continue;
                if (((RegularTable)t).lockExclusive == s) {
                    buff.append(" (exclusive)");
                    continue;
                }
                buff.append(" (shared)");
            }
            buff.append('.');
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Session> checkDeadlock(Session session, Session clash, Set<Session> visited) {
        Class<RegularTable> clazz = RegularTable.class;
        synchronized (RegularTable.class) {
            Table t;
            if (clash == null) {
                clash = session;
                visited = New.hashSet();
            } else {
                if (clash == session) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return New.arrayList();
                }
                if (visited.contains(session)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
            }
            visited.add(session);
            ArrayList<Session> error = null;
            for (Session s : this.lockShared) {
                Table t2;
                if (s == session || (t2 = s.getWaitForLock()) == null || (error = t2.checkDeadlock(s, clash, visited)) == null) continue;
                error.add(session);
                break;
            }
            if (error == null && this.lockExclusive != null && (t = this.lockExclusive.getWaitForLock()) != null && (error = t.checkDeadlock(this.lockExclusive, clash, visited)) != null) {
                error.add(session);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return error;
        }
    }

    private void traceLock(Session session, boolean exclusive, String s) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug("{0} {1} {2} {3}", session.getId(), exclusive ? "exclusive write lock" : "shared read lock", s, this.getName());
        }
    }

    @Override
    public boolean isLockedExclusively() {
        return this.lockExclusive != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Session s) {
        if (this.database != null) {
            this.traceLock(s, this.lockExclusive == s, "unlock");
            if (this.lockExclusive == s) {
                this.lockExclusive = null;
            }
            if (this.lockShared.size() > 0) {
                this.lockShared.remove(s);
            }
            Database database = this.database;
            synchronized (database) {
                if (this.database.getSessionCount() > 1 && this.waitForLock) {
                    this.database.notifyAll();
                }
            }
        }
    }

    public static Row createRow(Value[] data) {
        return new Row(data, -1);
    }

    public void setRowCount(long count) {
        this.rowCount = count;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        if (this.containsLargeObject) {
            this.truncate(session);
            this.database.getLobStorage().removeAllForTable(this.getId());
            this.database.lockMeta(session);
        }
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            if (index.getName() == null) continue;
            this.database.removeSchemaObject(session, index);
        }
        if (SysProperties.CHECK) {
            for (SchemaObject obj : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)obj;
                if (index.getTable() != this) continue;
                DbException.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.scanIndex.remove(session);
        this.database.removeMeta(session, this.getId());
        this.scanIndex = null;
        this.lockExclusive = null;
        this.lockShared = null;
        this.invalidate();
    }

    @Override
    public String toString() {
        return this.getSQL();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void checkSupportAlter() {
    }

    @Override
    public boolean canTruncate() {
        ArrayList<Constraint> constraints;
        if (this.getCheckForeignKeyConstraints() && this.database.getReferentialIntegrity() && (constraints = this.getConstraints()) != null) {
            int size = constraints.size();
            for (int i = 0; i < size; ++i) {
                ConstraintReferential ref;
                Constraint c = constraints.get(i);
                if (!c.getConstraintType().equals("REFERENTIAL") || (ref = (ConstraintReferential)c).getRefTable() != this) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getTableType() {
        return "TABLE";
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId;
    }

    public boolean getContainsLargeObject() {
        return this.containsLargeObject;
    }

    @Override
    public long getRowCountApproximation() {
        return this.scanIndex.getRowCountApproximation();
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public Column getRowIdColumn() {
        if (this.rowIdColumn == null) {
            this.rowIdColumn = new Column("_ROWID_", 5);
            this.rowIdColumn.setTable(this, -1);
        }
        return this.rowIdColumn;
    }
}

