/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.store.fs.FileUtils;
import org.h2.util.Tool;

public class ChangeFileEncryption
extends Tool {
    private String directory;
    private String cipherType;
    private byte[] decrypt;
    private byte[] encrypt;

    public static void main(String ... args) throws SQLException {
        new ChangeFileEncryption().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String dir = ".";
        String cipher = null;
        char[] decryptPassword = null;
        char[] encryptPassword = null;
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (arg.equals("-cipher")) {
                cipher = args[++i];
                continue;
            }
            if (arg.equals("-db")) {
                db = args[++i];
                continue;
            }
            if (arg.equals("-decrypt")) {
                decryptPassword = args[++i].toCharArray();
                continue;
            }
            if (arg.equals("-encrypt")) {
                encryptPassword = args[++i].toCharArray();
                continue;
            }
            if (arg.equals("-quiet")) {
                quiet = true;
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(arg);
        }
        if (encryptPassword == null && decryptPassword == null || cipher == null) {
            this.showUsage();
            throw new SQLException("Encryption or decryption password not set, or cipher not set");
        }
        try {
            this.process(dir, db, cipher, decryptPassword, encryptPassword, quiet);
        }
        catch (Exception e) {
            throw DbException.toSQLException(e);
        }
    }

    private static byte[] getFileEncryptionKey(char[] password) {
        if (password == null) {
            return null;
        }
        return SHA256.getKeyPasswordHash("file", password);
    }

    public static void execute(String dir, String db, String cipher, char[] decryptPassword, char[] encryptPassword, boolean quiet) throws SQLException {
        try {
            new ChangeFileEncryption().process(dir, db, cipher, decryptPassword, encryptPassword, quiet);
        }
        catch (Exception e) {
            throw DbException.toSQLException(e);
        }
    }

    private void process(String dir, String db, String cipher, char[] decryptPassword, char[] encryptPassword, boolean quiet) throws SQLException {
        dir = FileLister.getDir(dir);
        ChangeFileEncryption change = new ChangeFileEncryption();
        if (encryptPassword != null) {
            for (char c : encryptPassword) {
                if (c != ' ') continue;
                throw new SQLException("The file password may not contain spaces");
            }
        }
        change.out = this.out;
        change.directory = dir;
        change.cipherType = cipher;
        change.decrypt = ChangeFileEncryption.getFileEncryptionKey(decryptPassword);
        change.encrypt = ChangeFileEncryption.getFileEncryptionKey(encryptPassword);
        ArrayList<String> files = FileLister.getDatabaseFiles(dir, db, true);
        FileLister.tryUnlockDatabase(files, "encryption");
        files = FileLister.getDatabaseFiles(dir, db, false);
        if (files.size() == 0 && !quiet) {
            this.printNoDatabaseFilesFound(dir, db);
        }
        for (String fileName : files) {
            String temp = dir + "/temp.db";
            FileUtils.delete(temp);
            FileUtils.moveTo(fileName, temp);
            FileUtils.moveTo(temp, fileName);
        }
        for (String fileName : files) {
            if (FileUtils.isDirectory(fileName)) continue;
            change.process(fileName);
        }
    }

    private void process(String fileName) {
        FileStore in = this.decrypt == null ? FileStore.open(null, fileName, "r") : FileStore.open(null, fileName, "r", this.cipherType, this.decrypt);
        in.init();
        this.copy(fileName, in, this.encrypt);
    }

    private void copy(String fileName, FileStore in, byte[] key) {
        long remaining;
        if (FileUtils.isDirectory(fileName)) {
            return;
        }
        String temp = this.directory + "/temp.db";
        FileUtils.delete(temp);
        FileStore fileOut = key == null ? FileStore.open(null, temp, "rw") : FileStore.open(null, temp, "rw", this.cipherType, key);
        fileOut.init();
        byte[] buffer = new byte[4096];
        long total = remaining = in.length() - 48L;
        in.seek(48L);
        fileOut.seek(48L);
        long time = System.currentTimeMillis();
        while (remaining > 0L) {
            if (System.currentTimeMillis() - time > 1000L) {
                this.out.println(fileName + ": " + (100L - 100L * remaining / total) + "%");
                time = System.currentTimeMillis();
            }
            int len = (int)Math.min((long)buffer.length, remaining);
            in.readFully(buffer, 0, len);
            fileOut.write(buffer, 0, len);
            remaining -= (long)len;
        }
        in.close();
        fileOut.close();
        FileUtils.delete(fileName);
        FileUtils.moveTo(temp, fileName);
    }
}

