/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.util.StringUtils;

public class IOUtils {
    private IOUtils() {
    }

    public static void closeSilently(OutputStream out) {
        if (out != null) {
            try {
                IOUtils.trace("closeSilently", null, out);
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void skipFully(InputStream in, long skip) throws IOException {
        try {
            while (skip > 0L) {
                long skipped = in.skip(skip);
                if (skipped <= 0L) {
                    throw new EOFException();
                }
                skip -= skipped;
            }
        }
        catch (Exception e) {
            throw DbException.convertToIOException(e);
        }
    }

    public static void skipFully(Reader reader, long skip) throws IOException {
        try {
            while (skip > 0L) {
                long skipped = reader.skip(skip);
                if (skipped <= 0L) {
                    throw new EOFException();
                }
                skip -= skipped;
            }
        }
        catch (Exception e) {
            throw DbException.convertToIOException(e);
        }
    }

    public static long copyAndClose(InputStream in, OutputStream out) throws IOException {
        try {
            long len = IOUtils.copyAndCloseInput(in, out);
            out.close();
            long l = len;
            return l;
        }
        catch (Exception e) {
            throw DbException.convertToIOException(e);
        }
        finally {
            IOUtils.closeSilently(out);
        }
    }

    public static long copyAndCloseInput(InputStream in, OutputStream out) throws IOException {
        try {
            long l = IOUtils.copy(in, out);
            return l;
        }
        catch (Exception e) {
            throw DbException.convertToIOException(e);
        }
        finally {
            IOUtils.closeSilently(in);
        }
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return IOUtils.copy(in, out, Long.MAX_VALUE);
    }

    public static long copy(InputStream in, OutputStream out, long length) throws IOException {
        try {
            long copied = 0L;
            int len = (int)Math.min(length, 4096L);
            byte[] buffer = new byte[len];
            while (length > 0L && (len = in.read(buffer, 0, len)) >= 0) {
                if (out != null) {
                    out.write(buffer, 0, len);
                }
                copied += (long)len;
                length -= (long)len;
                len = (int)Math.min(length, 4096L);
            }
            return copied;
        }
        catch (Exception e) {
            throw DbException.convertToIOException(e);
        }
    }

    public static long copyAndCloseInput(Reader in, Writer out, long length) throws IOException {
        try {
            long copied = 0L;
            int len = (int)Math.min(length, 4096L);
            char[] buffer = new char[len];
            while (length > 0L && (len = in.read(buffer, 0, len)) >= 0) {
                if (out != null) {
                    out.write(buffer, 0, len);
                }
                length -= (long)len;
                len = (int)Math.min(length, 4096L);
                copied += (long)len;
            }
            long l = copied;
            return l;
        }
        catch (Exception e) {
            throw DbException.convertToIOException(e);
        }
        finally {
            in.close();
        }
    }

    public static void closeSilently(InputStream in) {
        if (in != null) {
            try {
                IOUtils.trace("closeSilently", null, in);
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Writer writer) {
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static byte[] readBytesAndClose(InputStream in, int length) throws IOException {
        try {
            if (length <= 0) {
                length = Integer.MAX_VALUE;
            }
            int block = Math.min(4096, length);
            ByteArrayOutputStream out = new ByteArrayOutputStream(block);
            IOUtils.copy(in, out, length);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw DbException.convertToIOException(e);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringAndClose(Reader in, int length) throws IOException {
        try {
            if (length <= 0) {
                length = Integer.MAX_VALUE;
            }
            int block = Math.min(4096, length);
            StringWriter out = new StringWriter(block);
            IOUtils.copyAndCloseInput(in, out, length);
            String string = out.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public static int readFully(InputStream in, byte[] buffer, int off, int max) throws IOException {
        try {
            int l;
            int result = 0;
            for (int len = Math.min(max, buffer.length); len > 0 && (l = in.read(buffer, off, len)) >= 0; len -= l) {
                result += l;
                off += l;
            }
            return result;
        }
        catch (Exception e) {
            throw DbException.convertToIOException(e);
        }
    }

    public static int readFully(Reader in, char[] buffer, int max) throws IOException {
        try {
            int l;
            int off = 0;
            int len = Math.min(max, buffer.length);
            if (len == 0) {
                return 0;
            }
            while ((l = len - off) > 0 && (l = in.read(buffer, off, l)) >= 0) {
                off += l;
            }
            return off <= 0 ? -1 : off;
        }
        catch (Exception e) {
            throw DbException.convertToIOException(e);
        }
    }

    public static Reader getBufferedReader(InputStream in) {
        try {
            return in == null ? null : new BufferedReader(new InputStreamReader(in, "UTF8"));
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
    }

    public static Reader getReader(InputStream in) {
        try {
            return in == null ? null : new BufferedReader(new InputStreamReader(in, "UTF8"));
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
    }

    public static Writer getBufferedWriter(OutputStream out) {
        try {
            return out == null ? null : new BufferedWriter(new OutputStreamWriter(out, "UTF8"));
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
    }

    public static Reader getReaderFromString(String s) {
        return s == null ? null : new StringReader(s);
    }

    public static Reader getAsciiReader(InputStream in) {
        try {
            return in == null ? null : new InputStreamReader(in, "US-ASCII");
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
    }

    public static void trace(String method, String fileName, Object o) {
        if (SysProperties.TRACE_IO) {
            System.out.println("IOUtils." + method + " " + fileName + " " + o);
        }
    }

    public static InputStream getInputStreamFromString(String s) {
        if (s == null) {
            return null;
        }
        return new ByteArrayInputStream(StringUtils.utf8Encode(s));
    }
}

