/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.engine.SessionInterface;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.security.SHA256;
import org.h2.store.Data;
import org.h2.store.DataReader;
import org.h2.tools.SimpleResultSet;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class Transfer {
    private static final int BUFFER_SIZE = 16384;
    private static final int LOB_MAGIC = 4660;
    private static final int LOB_MAC_SALT_LENGTH = 16;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private SessionInterface session;
    private boolean ssl;
    private int version;
    private byte[] lobMacSalt;

    public Transfer(SessionInterface session) {
        this.session = session;
    }

    public void setSocket(Socket s) {
        this.socket = s;
    }

    public synchronized void init() throws IOException {
        if (this.socket != null) {
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 16384));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 16384));
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public Transfer writeBoolean(boolean x) throws IOException {
        this.out.writeByte((byte)(x ? 1 : 0));
        return this;
    }

    public boolean readBoolean() throws IOException {
        return this.in.readByte() == 1;
    }

    private Transfer writeByte(byte x) throws IOException {
        this.out.writeByte(x);
        return this;
    }

    private byte readByte() throws IOException {
        return this.in.readByte();
    }

    public Transfer writeInt(int x) throws IOException {
        this.out.writeInt(x);
        return this;
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public Transfer writeLong(long x) throws IOException {
        this.out.writeLong(x);
        return this;
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    private Transfer writeDouble(double i) throws IOException {
        this.out.writeDouble(i);
        return this;
    }

    private Transfer writeFloat(float i) throws IOException {
        this.out.writeFloat(i);
        return this;
    }

    private double readDouble() throws IOException {
        return this.in.readDouble();
    }

    private float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public Transfer writeString(String s) throws IOException {
        if (s == null) {
            this.out.writeInt(-1);
        } else {
            int len = s.length();
            this.out.writeInt(len);
            for (int i = 0; i < len; ++i) {
                this.out.writeChar(s.charAt(i));
            }
        }
        return this;
    }

    public String readString() throws IOException {
        int len = this.in.readInt();
        if (len == -1) {
            return null;
        }
        StringBuilder buff = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            buff.append(this.in.readChar());
        }
        String s = buff.toString();
        s = StringUtils.cache(s);
        return s;
    }

    public Transfer writeBytes(byte[] data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.length);
            this.out.write(data);
        }
        return this;
    }

    public Transfer writeBytes(byte[] buff, int off, int len) throws IOException {
        this.out.write(buff, off, len);
        return this;
    }

    public byte[] readBytes() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        byte[] b = Utils.newBytes(len);
        this.in.readFully(b);
        return b;
    }

    public void readBytes(byte[] buff, int off, int len) throws IOException {
        this.in.readFully(buff, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.socket != null) {
            try {
                if (this.out != null) {
                    this.out.flush();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                TraceSystem.traceThrowable(e);
            }
            finally {
                this.socket = null;
            }
        }
    }

    public void writeValue(Value v) throws IOException {
        int type = v.getType();
        this.writeInt(type);
        switch (type) {
            case 0: {
                break;
            }
            case 12: 
            case 19: {
                this.writeBytes(v.getBytesNoCopy());
                break;
            }
            case 20: {
                ValueUuid uuid = (ValueUuid)v;
                this.writeLong(uuid.getHigh());
                this.writeLong(uuid.getLow());
                break;
            }
            case 1: {
                this.writeBoolean(v.getBoolean());
                break;
            }
            case 2: {
                this.writeByte(v.getByte());
                break;
            }
            case 9: {
                if (this.version >= 9) {
                    this.writeLong(((ValueTime)v).getNanos());
                    break;
                }
                if (this.version >= 7) {
                    this.writeLong(DateTimeUtils.getTimeLocalWithoutDst(v.getTime()));
                    break;
                }
                this.writeLong(v.getTime().getTime());
                break;
            }
            case 10: {
                if (this.version >= 9) {
                    this.writeLong(((ValueDate)v).getDateValue());
                    break;
                }
                if (this.version >= 7) {
                    this.writeLong(DateTimeUtils.getTimeLocalWithoutDst(v.getDate()));
                    break;
                }
                this.writeLong(v.getDate().getTime());
                break;
            }
            case 11: {
                if (this.version >= 9) {
                    ValueTimestamp ts = (ValueTimestamp)v;
                    this.writeLong(ts.getDateValue());
                    this.writeLong(ts.getNanos());
                    break;
                }
                if (this.version >= 7) {
                    Timestamp ts = v.getTimestamp();
                    this.writeLong(DateTimeUtils.getTimeLocalWithoutDst(ts));
                    this.writeInt(ts.getNanos());
                    break;
                }
                Timestamp ts = v.getTimestamp();
                this.writeLong(ts.getTime());
                this.writeInt(ts.getNanos());
                break;
            }
            case 6: {
                this.writeString(v.getString());
                break;
            }
            case 7: {
                this.writeDouble(v.getDouble());
                break;
            }
            case 8: {
                this.writeFloat(v.getFloat());
                break;
            }
            case 4: {
                this.writeInt(v.getInt());
                break;
            }
            case 5: {
                this.writeLong(v.getLong());
                break;
            }
            case 3: {
                this.writeInt(v.getShort());
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                this.writeString(v.getString());
                break;
            }
            case 15: {
                ValueLobDb lob;
                if (this.version >= 11 && v instanceof ValueLobDb && (lob = (ValueLobDb)v).isStored()) {
                    this.writeLong(-1L);
                    this.writeInt(lob.getTableId());
                    this.writeLong(lob.getLobId());
                    if (this.version >= 12) {
                        this.writeBytes(this.calculateLobMac(lob.getLobId()));
                    }
                    this.writeLong(lob.getPrecision());
                    break;
                }
                long length = v.getPrecision();
                if (length < 0L) {
                    throw DbException.get(90067, "length=" + length);
                }
                this.writeLong(length);
                long written = IOUtils.copyAndCloseInput(v.getInputStream(), this.out);
                if (written != length) {
                    throw DbException.get(90067, "length:" + length + " written:" + written);
                }
                this.writeInt(4660);
                break;
            }
            case 16: {
                ValueLobDb lob;
                if (this.version >= 11 && v instanceof ValueLobDb && (lob = (ValueLobDb)v).isStored()) {
                    this.writeLong(-1L);
                    this.writeInt(lob.getTableId());
                    this.writeLong(lob.getLobId());
                    if (this.version >= 12) {
                        this.writeBytes(this.calculateLobMac(lob.getLobId()));
                    }
                    this.writeLong(lob.getPrecision());
                    break;
                }
                long length = v.getPrecision();
                if (length < 0L) {
                    throw DbException.get(90067, "length=" + length);
                }
                this.writeLong(length);
                Reader reader = v.getReader();
                Data.copyString(reader, this.out);
                this.writeInt(4660);
                break;
            }
            case 17: {
                ValueArray va = (ValueArray)v;
                Value[] list = va.getList();
                int len = list.length;
                Class<?> componentType = va.getComponentType();
                if (componentType == Object.class) {
                    this.writeInt(len);
                } else {
                    this.writeInt(-(len + 1));
                    this.writeString(componentType.getName());
                }
                for (Value value : list) {
                    this.writeValue(value);
                }
                break;
            }
            case 18: {
                try {
                    int i;
                    ResultSet rs = ((ValueResultSet)v).getResultSet();
                    rs.beforeFirst();
                    ResultSetMetaData meta = rs.getMetaData();
                    int columnCount = meta.getColumnCount();
                    this.writeInt(columnCount);
                    for (i = 0; i < columnCount; ++i) {
                        this.writeString(meta.getColumnName(i + 1));
                        this.writeInt(meta.getColumnType(i + 1));
                        this.writeInt(meta.getPrecision(i + 1));
                        this.writeInt(meta.getScale(i + 1));
                    }
                    while (rs.next()) {
                        this.writeBoolean(true);
                        for (i = 0; i < columnCount; ++i) {
                            int t = DataType.convertSQLTypeToValueType(meta.getColumnType(i + 1));
                            Value val = DataType.readValue(this.session, rs, i + 1, t);
                            this.writeValue(val);
                        }
                    }
                    this.writeBoolean(false);
                    rs.beforeFirst();
                    break;
                }
                catch (SQLException e) {
                    throw DbException.convertToIOException(e);
                }
            }
            default: {
                throw DbException.get(90067, "type=" + type);
            }
        }
    }

    public Value readValue() throws IOException {
        int type = this.readInt();
        switch (type) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 12: {
                return ValueBytes.getNoCopy(this.readBytes());
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 19: {
                return ValueJavaObject.getNoCopy(null, this.readBytes());
            }
            case 1: {
                return ValueBoolean.get(this.readBoolean());
            }
            case 2: {
                return ValueByte.get(this.readByte());
            }
            case 10: {
                if (this.version >= 9) {
                    return ValueDate.fromDateValue(this.readLong());
                }
                if (this.version >= 7) {
                    return ValueDate.get(new Date(DateTimeUtils.getTimeUTCWithoutDst(this.readLong())));
                }
                return ValueDate.get(new Date(this.readLong()));
            }
            case 9: {
                if (this.version >= 9) {
                    return ValueTime.fromNanos(this.readLong());
                }
                if (this.version >= 7) {
                    return ValueTime.get(new Time(DateTimeUtils.getTimeUTCWithoutDst(this.readLong())));
                }
                return ValueTime.get(new Time(this.readLong()));
            }
            case 11: {
                if (this.version >= 9) {
                    return ValueTimestamp.fromDateValueAndNanos(this.readLong(), this.readLong());
                }
                if (this.version >= 7) {
                    Timestamp ts = new Timestamp(DateTimeUtils.getTimeUTCWithoutDst(this.readLong()));
                    ts.setNanos(this.readInt());
                    return ValueTimestamp.get(ts);
                }
                Timestamp ts = new Timestamp(this.readLong());
                ts.setNanos(this.readInt());
                return ValueTimestamp.get(ts);
            }
            case 6: {
                return ValueDecimal.get(new BigDecimal(this.readString()));
            }
            case 7: {
                return ValueDouble.get(this.readDouble());
            }
            case 8: {
                return ValueFloat.get(this.readFloat());
            }
            case 4: {
                return ValueInt.get(this.readInt());
            }
            case 5: {
                return ValueLong.get(this.readLong());
            }
            case 3: {
                return ValueShort.get((short)this.readInt());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 15: {
                long length = this.readLong();
                if (this.version >= 11) {
                    if (length == -1L) {
                        int tableId = this.readInt();
                        long id = this.readLong();
                        byte[] hmac = this.version >= 12 ? this.readBytes() : null;
                        long precision = this.readLong();
                        return ValueLobDb.create(15, this.session.getDataHandler().getLobStorage(), tableId, id, hmac, precision);
                    }
                    int len = (int)length;
                    byte[] small = new byte[len];
                    IOUtils.readFully(this.in, small, 0, len);
                    int magic = this.readInt();
                    if (magic != 4660) {
                        throw DbException.get(90067, "magic=" + magic);
                    }
                    return ValueLobDb.createSmallLob(15, small, length);
                }
                Value v = this.session.getDataHandler().getLobStorage().createBlob(this.in, length);
                int magic = this.readInt();
                if (magic != 4660) {
                    throw DbException.get(90067, "magic=" + magic);
                }
                return v;
            }
            case 16: {
                long length = this.readLong();
                if (this.version >= 11) {
                    if (length == -1L) {
                        int tableId = this.readInt();
                        long id = this.readLong();
                        byte[] hmac = this.version >= 12 ? this.readBytes() : null;
                        long precision = this.readLong();
                        return ValueLobDb.create(16, this.session.getDataHandler().getLobStorage(), tableId, id, hmac, precision);
                    }
                    DataReader reader = new DataReader(this.in);
                    int len = (int)length;
                    char[] buff = new char[len];
                    IOUtils.readFully(reader, buff, len);
                    int magic = this.readInt();
                    if (magic != 4660) {
                        throw DbException.get(90067, "magic=" + magic);
                    }
                    byte[] small = new String(buff).getBytes("UTF-8");
                    return ValueLobDb.createSmallLob(16, small, length);
                }
                Value v = this.session.getDataHandler().getLobStorage().createClob(new DataReader(this.in), length);
                int magic = this.readInt();
                if (magic != 4660) {
                    throw DbException.get(90067, "magic=" + magic);
                }
                return v;
            }
            case 17: {
                int len = this.readInt();
                Class componentType = Object.class;
                if (len < 0) {
                    len = -(len + 1);
                    componentType = Utils.loadUserClass(this.readString());
                }
                Value[] list = new Value[len];
                for (int i = 0; i < len; ++i) {
                    list[i] = this.readValue();
                }
                return ValueArray.get(componentType, list);
            }
            case 18: {
                SimpleResultSet rs = new SimpleResultSet();
                int columns = this.readInt();
                for (int i = 0; i < columns; ++i) {
                    rs.addColumn(this.readString(), this.readInt(), this.readInt(), this.readInt());
                }
                while (this.readBoolean()) {
                    Object[] o = new Object[columns];
                    for (int i = 0; i < columns; ++i) {
                        o[i] = this.readValue().getObject();
                    }
                    rs.addRow(o);
                }
                return ValueResultSet.get(rs);
            }
        }
        throw DbException.get(90067, "type=" + type);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSession(SessionInterface session) {
        this.session = session;
    }

    public void setSSL(boolean ssl) {
        this.ssl = ssl;
    }

    public Transfer openNewConnection() throws IOException {
        InetAddress address = this.socket.getInetAddress();
        int port = this.socket.getPort();
        Socket s2 = NetUtils.createSocket(address, port, this.ssl);
        Transfer trans = new Transfer(null);
        trans.setSocket(s2);
        trans.setSSL(this.ssl);
        return trans;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public synchronized boolean isClosed() {
        return this.socket == null || this.socket.isClosed();
    }

    public void verifyLobMac(byte[] hmac, long lobId) {
        byte[] result = this.calculateLobMac(lobId);
        if (!Utils.compareSecure(hmac, result)) {
            throw DbException.get(90117);
        }
    }

    private byte[] calculateLobMac(long lobId) {
        if (this.lobMacSalt == null) {
            this.lobMacSalt = MathUtils.secureRandomBytes(16);
        }
        byte[] data = new byte[8];
        Utils.writeLong(data, 0, lobId);
        byte[] hmacData = SHA256.getHashWithSalt(data, this.lobMacSalt);
        return hmacData;
    }
}

