/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class LogFileResourceDefinition
extends SimpleResourceDefinition {
    static final AccessConstraintDefinition VIEW_SERVER_LOGS = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("logging", "view-server-logs", false, false, false));
    static final String LOG_FILE = "log-file";
    static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    static final SimpleAttributeDefinition FILE_SIZE = SimpleAttributeDefinitionBuilder.create((String)"file-size", (ModelType)ModelType.LONG, (boolean)false).setStorageRuntime().setAllowExpression(false).build();
    static final SimpleAttributeDefinition LAST_MODIFIED_TIME = SimpleAttributeDefinitionBuilder.create((String)"last-modified-time", (ModelType)ModelType.LONG, (boolean)false).setStorageRuntime().setAllowExpression(false).build();
    static final SimpleAttributeDefinition LAST_MODIFIED_TIMESTAMP = SimpleAttributeDefinitionBuilder.create((String)"last-modified-timestamp", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime().setAllowExpression(false).build();
    static final SimpleAttributeDefinition STREAM = SimpleAttributeDefinitionBuilder.create((String)"stream", (ModelType)ModelType.LONG).setStorageRuntime().setAllowNull(true).build();
    static final SimpleAttributeDefinition LINES = SimpleAttributeDefinitionBuilder.create((String)"lines", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(10)).setValidator((ParameterValidator)new IntRangeValidator(-1, true)).build();
    static final SimpleAttributeDefinition SKIP = SimpleAttributeDefinitionBuilder.create((String)"skip", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(0)).setValidator((ParameterValidator)new IntRangeValidator(0, true)).build();
    static final SimpleAttributeDefinition TAIL = SimpleAttributeDefinitionBuilder.create((String)"tail", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(true)).build();
    static final SimpleOperationDefinition READ_LOG_FILE = new SimpleOperationDefinitionBuilder("read-log-file", (ResourceDescriptionResolver)LoggingExtension.getResourceDescriptionResolver("log-file")).addAccessConstraint(VIEW_SERVER_LOGS).setParameters(new AttributeDefinition[]{CommonAttributes.ENCODING, LINES, SKIP, TAIL}).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).setReadOnly().setRuntimeOnly().build();
    static final PathElement LOG_FILE_PATH = PathElement.pathElement((String)"log-file");
    private final PathManager pathManager;

    protected LogFileResourceDefinition(PathManager pathManager) {
        super(LOG_FILE_PATH, (ResourceDescriptionResolver)LoggingExtension.getResourceDescriptionResolver(LOG_FILE), null, null, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_NONE);
        assert (pathManager != null) : "PathManager cannot be null";
        this.pathManager = pathManager;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)READ_LOG_FILE, (OperationStepHandler)new ReadLogFileOperation(this.pathManager));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)FILE_SIZE, (OperationStepHandler)new ReadAttributeOperationStepHandler(){

            @Override
            protected void updateModel(File path, ModelNode model) throws IOException {
                model.set(path.length());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LAST_MODIFIED_TIME, (OperationStepHandler)new ReadAttributeOperationStepHandler(){

            @Override
            protected void updateModel(File path, ModelNode model) throws IOException {
                model.set(path.lastModified());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LAST_MODIFIED_TIMESTAMP, (OperationStepHandler)new ReadAttributeOperationStepHandler(){

            @Override
            protected void updateModel(File path, ModelNode model) throws IOException {
                SimpleDateFormat sdf = new SimpleDateFormat(LogFileResourceDefinition.ISO_8601_FORMAT);
                model.set(sdf.format(new Date(path.lastModified())));
            }
        });
        OperationStepHandler streamHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                File path = new File(LogFileResourceDefinition.this.pathManager.resolveRelativePathEntry(LoggingOperations.getAddressName(operation), "jboss.server.log.dir"));
                try {
                    String uuid = context.attachResultStream("text/plain", (InputStream)new FileInputStream(path));
                    context.getResult().set(uuid);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                context.stepCompleted();
            }
        };
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)STREAM, streamHandler);
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return Collections.singletonList(VIEW_SERVER_LOGS);
    }

    static final class LifoFileInputStream
    extends InputStream {
        private final RandomAccessFile raf;
        private final long len;
        private long start;
        private long end;
        private long pos;

        LifoFileInputStream(File file) throws IOException {
            this.raf = new RandomAccessFile(file, "r");
            this.start = this.len = this.raf.length();
            this.pos = this.end = this.len;
        }

        private void positionFile() throws IOException {
            this.end = this.start;
            if (this.end == 0L) {
                this.end = -1L;
                this.start = -1L;
                this.pos = -1L;
                return;
            }
            long filePointer = this.start - 1L;
            while (--filePointer >= 0L) {
                this.raf.seek(filePointer);
                byte readByte = this.raf.readByte();
                if (readByte != 10 || filePointer == this.len - 1L) continue;
                break;
            }
            this.pos = this.start = filePointer + 1L;
        }

        @Override
        public int read() throws IOException {
            if (this.pos < this.end) {
                this.raf.seek(this.pos++);
                return this.raf.readByte();
            }
            if (this.pos < 0L) {
                return -1;
            }
            this.positionFile();
            return this.read();
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }
    }

    static class ReadLogFileOperation
    implements OperationStepHandler {
        private final PathManager pathManager;

        private ReadLogFileOperation(PathManager pathManager) {
            this.pathManager = pathManager;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            for (AttributeDefinition attribute : READ_LOG_FILE.getParameters()) {
                attribute.validateOperation(operation);
            }
            int numberOfLines = LINES.resolveModelAttribute(context, operation).asInt();
            int skip = SKIP.resolveModelAttribute(context, operation).asInt();
            boolean tail = TAIL.resolveModelAttribute(context, operation).asBoolean();
            ModelNode encodingModel = CommonAttributes.ENCODING.resolveModelAttribute(context, operation);
            String encoding = encodingModel.isDefined() ? encodingModel.asString() : null;
            String fileName = LoggingOperations.getAddressName(operation);
            File path = new File(this.pathManager.resolveRelativePathEntry(fileName, "jboss.server.log.dir"));
            if (!path.exists()) {
                throw LoggingMessages.MESSAGES.logFileNotFound(LoggingOperations.getAddress(operation).getLastElement(), fileName, "jboss.server.log.dir");
            }
            try {
                List<Object> lines = numberOfLines == 0 ? Collections.emptyList() : this.readLines(path, encoding, tail, skip, numberOfLines);
                ModelNode result = context.getResult().setEmptyList();
                for (String line : lines) {
                    result.add(line);
                }
            }
            catch (IOException e) {
                throw LoggingMessages.MESSAGES.failedToReadLogFile(e, fileName);
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> readLines(File file, String encoding, boolean tail, int skip, int numberOfLines) throws IOException {
            ArrayList<String> arrayList;
            ArrayList<String> lines = numberOfLines < 0 ? new ArrayList<String>() : new ArrayList(numberOfLines);
            InputStream in = null;
            InputStreamReader isr = null;
            BufferedReader reader = null;
            try {
                String line;
                in = tail ? new LifoFileInputStream(file) : new FileInputStream(file);
                isr = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
                reader = new BufferedReader(isr);
                int lineCount = 0;
                while ((line = reader.readLine()) != null) {
                    if (++lineCount <= skip) continue;
                    if (lines.size() == numberOfLines) break;
                    lines.add(line);
                }
                if (tail) {
                    Collections.reverse(lines);
                }
                arrayList = lines;
            }
            catch (Throwable throwable) {
                ReadLogFileOperation.safeClose(in);
                ReadLogFileOperation.safeClose(isr);
                ReadLogFileOperation.safeClose(reader);
                throw throwable;
            }
            ReadLogFileOperation.safeClose(in);
            ReadLogFileOperation.safeClose(isr);
            ReadLogFileOperation.safeClose(reader);
            return arrayList;
        }

        static void safeClose(Closeable closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    LoggingLogger.ROOT_LOGGER.debug("Failed to close stream", e);
                }
            }
        }
    }

    private abstract class ReadAttributeOperationStepHandler
    implements OperationStepHandler {
        private ReadAttributeOperationStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.getResult();
            String name = LoggingOperations.getAddressName(operation);
            String logDir = LogFileResourceDefinition.this.pathManager.getPathEntry("jboss.server.log.dir").resolvePath();
            File path = new File(logDir, name);
            if (!path.exists()) {
                throw LoggingMessages.MESSAGES.logFileNotFound(LoggingOperations.getAddress(operation).getLastElement(), name, logDir);
            }
            try {
                this.updateModel(path, model);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }

        protected abstract void updateModel(File var1, ModelNode var2) throws IOException;
    }
}

