/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain.impl;

import org.jboss.as.controller.client.ControllerClientMessages;
import org.jboss.as.controller.client.helpers.domain.AddDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.DeployDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ReplaceDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.impl.DeployDeploymentPlanBuilderImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentActionImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentPlanBuilderImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentSetPlanImpl;

class AddDeploymentPlanBuilderImpl
extends DeploymentPlanBuilderImpl
implements AddDeploymentPlanBuilder {
    private final String newContentKey;

    AddDeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, DeploymentSetPlanImpl setPlan) {
        super(existing, setPlan);
        this.newContentKey = setPlan.getLastAction().getDeploymentUnitUniqueName();
    }

    @Override
    public DeployDeploymentPlanBuilder andDeploy() {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        if (currentSet.hasServerGroupPlans()) {
            throw ControllerClientMessages.MESSAGES.cannotAddDeploymentAction();
        }
        DeploymentActionImpl mod = DeploymentActionImpl.getDeployAction(this.newContentKey);
        DeploymentSetPlanImpl newSet = currentSet.addAction(mod);
        return new DeployDeploymentPlanBuilderImpl((DeploymentPlanBuilderImpl)this, newSet);
    }

    @Override
    public ReplaceDeploymentPlanBuilder andReplace(String toReplace) {
        return this.replace(this.newContentKey, toReplace);
    }

    @Override
    public ServerGroupDeploymentPlanBuilder toServerGroup(String serverGroupName) {
        return super.toServerGroup(serverGroupName);
    }
}

