/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.MountedDeploymentOverlay;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.as.service.SarMessages;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;

public class SarStructureProcessor
implements DeploymentUnitProcessor {
    private static final String SAR_EXTENSION = ".sar";
    private static final String JAR_EXTENSION = ".jar";
    private static final SuffixMatchFilter CHILD_ARCHIVE_FILTER = new SuffixMatchFilter(".jar", VisitorAttributes.RECURSE_LEAVES_ONLY);
    private static Closeable NO_OP_CLOSEABLE = new Closeable(){

        @Override
        public void close() throws IOException {
        }
    };

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot resourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (resourceRoot == null) {
            return;
        }
        VirtualFile deploymentRoot = resourceRoot.getRoot();
        if (deploymentRoot == null || !deploymentRoot.exists()) {
            return;
        }
        String deploymentRootName = deploymentRoot.getName().toLowerCase(Locale.ENGLISH);
        if (!deploymentRootName.endsWith(SAR_EXTENSION)) {
            return;
        }
        ModuleRootMarker.mark((ResourceRoot)resourceRoot, (boolean)true);
        Map overlays = (Map)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_OVERLAY_LOCATIONS);
        try {
            List childArchives = deploymentRoot.getChildren((VirtualFileFilter)CHILD_ARCHIVE_FILTER);
            for (VirtualFile child : childArchives) {
                String relativeName = child.getPathNameRelativeTo(deploymentRoot);
                MountedDeploymentOverlay overlay = (MountedDeploymentOverlay)overlays.get(relativeName);
                Closeable closable = NO_OP_CLOSEABLE;
                if (overlay != null) {
                    overlay.remountAsZip(false);
                } else if (child.isFile()) {
                    closable = VFS.mountZip((VirtualFile)child, (VirtualFile)child, (TempFileProvider)TempFileProviderService.provider());
                }
                MountHandle mountHandle = new MountHandle(closable);
                ResourceRoot childResource = new ResourceRoot(child, mountHandle);
                ModuleRootMarker.mark((ResourceRoot)childResource);
                deploymentUnit.addToAttachmentList(Attachments.RESOURCE_ROOTS, (Object)childResource);
                resourceRoot.addToAttachmentList(Attachments.INDEX_IGNORE_PATHS, (Object)child.getPathNameRelativeTo(deploymentRoot));
            }
        }
        catch (IOException e) {
            SarMessages.MESSAGES.failedToProcessSarChild(e, deploymentRoot);
        }
    }

    public void undeploy(DeploymentUnit context) {
        List childRoots = (List)context.removeAttachment(Attachments.RESOURCE_ROOTS);
        if (childRoots != null) {
            for (ResourceRoot childRoot : childRoots) {
                VFSUtils.safeClose((Closeable)childRoot.getMountHandle());
            }
        }
    }
}

