/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class SolrException
extends RuntimeException {
    @Deprecated
    public boolean logged = false;
    int code = 0;
    public static Set<String> ignorePatterns;

    public SolrException(ErrorCode code, String msg) {
        this(code, msg, null, false);
    }

    @Deprecated
    public SolrException(ErrorCode code, String msg, boolean alreadyLogged) {
        this(code, msg, null, alreadyLogged);
    }

    @Deprecated
    public SolrException(ErrorCode code, String msg, Throwable th, boolean alreadyLogged) {
        super(msg, th);
        this.code = code.code;
        this.logged = alreadyLogged;
    }

    public SolrException(ErrorCode code, String msg, Throwable th) {
        this(code, msg, th, th instanceof SolrException ? ((SolrException)th).logged : false);
    }

    public SolrException(ErrorCode code, Throwable th) {
        this(code, null, th, th instanceof SolrException ? ((SolrException)th).logged : false);
    }

    @Deprecated
    public SolrException(int code, String msg) {
        super(msg);
        this.code = code;
    }

    @Deprecated
    public SolrException(int code, String msg, boolean alreadyLogged) {
        super(msg);
        this.code = code;
        this.logged = alreadyLogged;
    }

    @Deprecated
    public SolrException(int code, String msg, Throwable th, boolean alreadyLogged) {
        super(msg, th);
        this.code = code;
        this.logged = alreadyLogged;
    }

    @Deprecated
    public SolrException(int code, String msg, Throwable th) {
        this(code, msg, th, true);
    }

    @Deprecated
    public SolrException(int code, Throwable th) {
        super(th);
        this.code = code;
        this.logged = true;
    }

    public int code() {
        return this.code;
    }

    public void log(Logger log) {
        SolrException.log(log, this);
    }

    public static void log(Logger log, Throwable e) {
        String stackTrace;
        String ignore;
        if (e instanceof SolrException) {
            ((SolrException)e).logged = true;
            if (((SolrException)e).code() == ErrorCode.SERVICE_UNAVAILABLE.code) {
                return;
            }
        }
        if ((ignore = SolrException.doIgnore(stackTrace = SolrException.toStr(e))) != null) {
            log.info(ignore);
            return;
        }
        log.error(stackTrace);
    }

    public static void log(Logger log, String msg, Throwable e) {
        String stackTrace;
        String ignore;
        if (e instanceof SolrException) {
            ((SolrException)e).logged = true;
            if (((SolrException)e).code() == ErrorCode.SERVICE_UNAVAILABLE.code) {
                return;
            }
        }
        if ((ignore = SolrException.doIgnore(stackTrace = msg + ':' + SolrException.toStr(e))) != null) {
            log.info(ignore);
            return;
        }
        log.error(stackTrace);
    }

    public static void logOnce(Logger log, String msg, Throwable e) {
        if (e instanceof SolrException) {
            if (((SolrException)e).logged) {
                return;
            }
            if (((SolrException)e).code() == ErrorCode.SERVICE_UNAVAILABLE.code) {
                return;
            }
        }
        if (msg != null) {
            SolrException.log(log, msg, e);
        } else {
            SolrException.log(log, e);
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static String toStr(Throwable e) {
        CharArrayWriter cw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(cw);
        e.printStackTrace(pw);
        pw.flush();
        return cw.toString();
    }

    public static String doIgnore(String m) {
        if (ignorePatterns == null || m == null) {
            return null;
        }
        for (String regex : ignorePatterns) {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(m);
            if (!matcher.find()) continue;
            return "Ignoring exception matching " + regex;
        }
        return null;
    }

    public static enum ErrorCode {
        BAD_REQUEST(400),
        UNAUTHORIZED(401),
        FORBIDDEN(403),
        NOT_FOUND(404),
        SERVER_ERROR(500),
        SERVICE_UNAVAILABLE(503),
        UNKNOWN(0);

        public final int code;

        private ErrorCode(int c) {
            this.code = c;
        }

        public static ErrorCode getErrorCode(int c) {
            for (ErrorCode err : ErrorCode.values()) {
                if (err.code != c) continue;
                return err;
            }
            return UNKNOWN;
        }
    }
}

