/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrInputField;

public class SolrInputDocument
implements Map<String, SolrInputField>,
Iterable<SolrInputField>,
Serializable {
    private final Map<String, SolrInputField> _fields;
    private float _documentBoost = 1.0f;

    public SolrInputDocument() {
        this._fields = new LinkedHashMap<String, SolrInputField>();
    }

    public SolrInputDocument(Map<String, SolrInputField> fields) {
        this._fields = fields;
    }

    @Override
    public void clear() {
        if (this._fields != null) {
            this._fields.clear();
        }
    }

    public void addField(String name, Object value) {
        this.addField(name, value, 1.0f);
    }

    public Object getFieldValue(String name) {
        SolrInputField field = this.getField(name);
        Object o = null;
        if (field != null) {
            o = field.getFirstValue();
        }
        return o;
    }

    public Collection<Object> getFieldValues(String name) {
        SolrInputField field = this.getField(name);
        if (field != null) {
            return field.getValues();
        }
        return null;
    }

    public Collection<String> getFieldNames() {
        return this._fields.keySet();
    }

    public void setField(String name, Object value) {
        this.setField(name, value, 1.0f);
    }

    public void setField(String name, Object value, float boost) {
        SolrInputField field = new SolrInputField(name);
        this._fields.put(name, field);
        field.setValue(value, boost);
    }

    public void addField(String name, Object value, float boost) {
        SolrInputField field = this._fields.get(name);
        if (field == null || field.value == null) {
            this.setField(name, value, boost);
        } else {
            field.addValue(value, boost);
        }
    }

    public SolrInputField removeField(String name) {
        return this._fields.remove(name);
    }

    public SolrInputField getField(String field) {
        return this._fields.get(field);
    }

    @Override
    public Iterator<SolrInputField> iterator() {
        return this._fields.values().iterator();
    }

    public float getDocumentBoost() {
        return this._documentBoost;
    }

    public void setDocumentBoost(float documentBoost) {
        this._documentBoost = documentBoost;
    }

    public String toString() {
        return "SolrInputDocument[" + this._fields + "]";
    }

    @Override
    public boolean containsKey(Object key) {
        return this._fields.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._fields.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, SolrInputField>> entrySet() {
        return this._fields.entrySet();
    }

    @Override
    public SolrInputField get(Object key) {
        return this._fields.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this._fields.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this._fields.keySet();
    }

    @Override
    public SolrInputField put(String key, SolrInputField value) {
        return this._fields.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends SolrInputField> t) {
        this._fields.putAll(t);
    }

    @Override
    public SolrInputField remove(Object key) {
        return this._fields.remove(key);
    }

    @Override
    public int size() {
        return this._fields.size();
    }

    @Override
    public Collection<SolrInputField> values() {
        return this._fields.values();
    }
}

