/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportConflictBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeCollisionException;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.CompoundNameVector;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.HashtableOfType;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.compiler.util.SimpleNameVector;

public class CompilationUnitScope
extends Scope {
    public LookupEnvironment environment;
    public CompilationUnitDeclaration referenceContext;
    public char[][] currentPackageName;
    public PackageBinding fPackage;
    public ImportBinding[] imports;
    public int importPtr;
    public HashtableOfObject typeOrPackageCache;
    public SourceTypeBinding[] topLevelTypes;
    private CompoundNameVector qualifiedReferences;
    private SimpleNameVector simpleNameReferences;
    private SimpleNameVector rootReferences;
    private ObjectVector referencedTypes;
    private ObjectVector referencedSuperTypes;
    HashtableOfType constantPoolNameUsage;
    private int captureID = 1;
    private ImportBinding[] tempImports;
    public boolean suppressImportErrors;
    private boolean skipCachingImports;
    boolean connectingHierarchy;

    public CompilationUnitScope(CompilationUnitDeclaration unit, LookupEnvironment environment) {
        super(4, null);
        this.environment = environment;
        this.referenceContext = unit;
        unit.scope = this;
        char[][] cArray = this.currentPackageName = unit.currentPackage == null ? CharOperation.NO_CHAR_CHAR : unit.currentPackage.tokens;
        if (this.compilerOptions().produceReferenceInfo) {
            this.qualifiedReferences = new CompoundNameVector();
            this.simpleNameReferences = new SimpleNameVector();
            this.rootReferences = new SimpleNameVector();
            this.referencedTypes = new ObjectVector();
            this.referencedSuperTypes = new ObjectVector();
        } else {
            this.qualifiedReferences = null;
            this.simpleNameReferences = null;
            this.rootReferences = null;
            this.referencedTypes = null;
            this.referencedSuperTypes = null;
        }
    }

    void buildFieldsAndMethods() {
        int length = this.topLevelTypes.length;
        for (int i = 0; i < length; ++i) {
            this.topLevelTypes[i].scope.buildFieldsAndMethods();
        }
    }

    void buildTypeBindings(AccessRestriction accessRestriction) {
        char[][] expectedPackageName;
        this.topLevelTypes = new SourceTypeBinding[0];
        boolean firstIsSynthetic = false;
        if (this.referenceContext.compilationResult.compilationUnit != null && (expectedPackageName = this.referenceContext.compilationResult.compilationUnit.getPackageName()) != null && !CharOperation.equals(this.currentPackageName, expectedPackageName)) {
            if (this.referenceContext.currentPackage != null || this.referenceContext.types != null || this.referenceContext.imports != null) {
                this.problemReporter().packageIsNotExpectedPackage(this.referenceContext);
            }
            char[][] cArray = this.currentPackageName = expectedPackageName.length == 0 ? CharOperation.NO_CHAR_CHAR : expectedPackageName;
        }
        if (this.currentPackageName == CharOperation.NO_CHAR_CHAR) {
            this.fPackage = this.environment.defaultPackage;
        } else {
            this.fPackage = this.environment.createPackage(this.currentPackageName);
            if (this.fPackage == null) {
                if (this.referenceContext.currentPackage != null) {
                    this.problemReporter().packageCollidesWithType(this.referenceContext);
                }
                this.fPackage = this.environment.defaultPackage;
                return;
            }
            if (this.referenceContext.isPackageInfo()) {
                if (this.referenceContext.types == null || this.referenceContext.types.length == 0) {
                    this.referenceContext.types = new TypeDeclaration[1];
                    this.referenceContext.createPackageInfoType();
                    firstIsSynthetic = true;
                }
                if (this.referenceContext.currentPackage != null && this.referenceContext.currentPackage.annotations != null) {
                    this.referenceContext.types[0].annotations = this.referenceContext.currentPackage.annotations;
                }
            }
            this.recordQualifiedReference(this.currentPackageName);
        }
        TypeDeclaration[] types = this.referenceContext.types;
        int typeLength = types == null ? 0 : types.length;
        this.topLevelTypes = new SourceTypeBinding[typeLength];
        int count = 0;
        for (int i = 0; i < typeLength; ++i) {
            char[] mainTypeName;
            TypeDeclaration typeDecl = types[i];
            if (this.environment.isProcessingAnnotations && this.environment.isMissingType(typeDecl.name)) {
                throw new SourceTypeCollisionException();
            }
            ReferenceBinding typeBinding = this.fPackage.getType0(typeDecl.name);
            this.recordSimpleReference(typeDecl.name);
            if (typeBinding != null && typeBinding.isValidBinding() && !(typeBinding instanceof UnresolvedReferenceBinding)) {
                if (this.environment.isProcessingAnnotations) {
                    throw new SourceTypeCollisionException();
                }
                this.problemReporter().duplicateTypes(this.referenceContext, typeDecl);
                continue;
            }
            if (this.fPackage != this.environment.defaultPackage && this.fPackage.getPackage(typeDecl.name) != null) {
                this.problemReporter().typeCollidesWithPackage(this.referenceContext, typeDecl);
            }
            if ((typeDecl.modifiers & 1) != 0 && (mainTypeName = this.referenceContext.getMainTypeName()) != null && !CharOperation.equals(mainTypeName, typeDecl.name)) {
                this.problemReporter().publicClassMustMatchFileName(this.referenceContext, typeDecl);
            }
            ClassScope child = new ClassScope(this, typeDecl);
            SourceTypeBinding type = child.buildType(null, this.fPackage, accessRestriction);
            if (firstIsSynthetic && i == 0) {
                type.modifiers |= 0x1000;
            }
            if (type == null) continue;
            this.topLevelTypes[count++] = type;
        }
        if (count != this.topLevelTypes.length) {
            this.topLevelTypes = new SourceTypeBinding[count];
            System.arraycopy(this.topLevelTypes, 0, this.topLevelTypes, 0, count);
        }
    }

    void checkAndSetImports() {
        if (this.referenceContext.imports == null) {
            this.imports = this.getDefaultImports();
            return;
        }
        int numberOfStatements = this.referenceContext.imports.length;
        int numberOfImports = numberOfStatements + 1;
        for (int i = 0; i < numberOfStatements; ++i) {
            ImportReference importReference = this.referenceContext.imports[i];
            if ((importReference.bits & 0x20000) == 0 || !CharOperation.equals(TypeConstants.JAVA_LANG, importReference.tokens) || importReference.isStatic()) continue;
            --numberOfImports;
            break;
        }
        ImportBinding[] resolvedImports = new ImportBinding[numberOfImports];
        resolvedImports[0] = this.getDefaultImports()[0];
        int index = 1;
        block1: for (int i = 0; i < numberOfStatements; ++i) {
            ImportReference importReference = this.referenceContext.imports[i];
            char[][] compoundName = importReference.tokens;
            for (int j = 0; j < index; ++j) {
                ImportBinding resolved = resolvedImports[j];
                if (resolved.onDemand == ((importReference.bits & 0x20000) != 0) && resolved.isStatic() == importReference.isStatic() && CharOperation.equals(compoundName, resolvedImports[j].compoundName)) continue block1;
            }
            if ((importReference.bits & 0x20000) != 0) {
                Binding importBinding;
                if (CharOperation.equals(compoundName, this.currentPackageName) || !(importBinding = this.findImport(compoundName, compoundName.length)).isValidBinding() || importReference.isStatic() && importBinding instanceof PackageBinding) continue;
                resolvedImports[index++] = new ImportBinding(compoundName, true, importBinding, importReference);
                continue;
            }
            resolvedImports[index++] = new ImportBinding(compoundName, false, null, importReference);
        }
        if (resolvedImports.length > index) {
            ImportBinding[] importBindingArray = resolvedImports;
            resolvedImports = new ImportBinding[index];
            System.arraycopy(importBindingArray, 0, resolvedImports, 0, index);
        }
        this.imports = resolvedImports;
    }

    void checkParameterizedTypes() {
        if (this.compilerOptions().sourceLevel < 0x310000L) {
            return;
        }
        int length = this.topLevelTypes.length;
        for (int i = 0; i < length; ++i) {
            ClassScope scope = this.topLevelTypes[i].scope;
            scope.checkParameterizedTypeBounds();
            scope.checkParameterizedSuperTypeCollisions();
        }
    }

    public char[] computeConstantPoolName(LocalTypeBinding localType) {
        char[] candidateName;
        boolean isCompliant15;
        if (localType.constantPoolName != null) {
            return localType.constantPoolName;
        }
        if (this.constantPoolNameUsage == null) {
            this.constantPoolNameUsage = new HashtableOfType();
        }
        SourceTypeBinding outerMostEnclosingType = localType.scope.outerMostClassScope().enclosingSourceType();
        int index = 0;
        boolean bl = isCompliant15 = this.compilerOptions().complianceLevel >= 0x310000L;
        while (true) {
            candidateName = localType.isMemberType() ? (index == 0 ? CharOperation.concat(localType.enclosingType().constantPoolName(), localType.sourceName, '$') : CharOperation.concat(localType.enclosingType().constantPoolName(), '$', String.valueOf(index).toCharArray(), '$', localType.sourceName)) : (localType.isAnonymousType() ? (isCompliant15 ? CharOperation.concat(localType.enclosingType.constantPoolName(), String.valueOf(index + 1).toCharArray(), '$') : CharOperation.concat(outerMostEnclosingType.constantPoolName(), String.valueOf(index + 1).toCharArray(), '$')) : (isCompliant15 ? CharOperation.concat(CharOperation.concat(localType.enclosingType().constantPoolName(), String.valueOf(index + 1).toCharArray(), '$'), localType.sourceName) : CharOperation.concat(outerMostEnclosingType.constantPoolName(), '$', String.valueOf(index + 1).toCharArray(), '$', localType.sourceName)));
            if (this.constantPoolNameUsage.get(candidateName) == null) break;
            ++index;
        }
        this.constantPoolNameUsage.put(candidateName, localType);
        return candidateName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectTypeHierarchy() {
        this.connectingHierarchy = true;
        try {
            int length = this.topLevelTypes.length;
            for (int i = 0; i < length; ++i) {
                this.topLevelTypes[i].scope.connectTypeHierarchy();
            }
        }
        finally {
            this.connectingHierarchy = false;
        }
    }

    void faultInImports() {
        int i;
        boolean reportUnresolved;
        boolean unresolvedFound = false;
        boolean bl = reportUnresolved = !this.suppressImportErrors;
        if (this.typeOrPackageCache != null && !this.skipCachingImports) {
            return;
        }
        if (this.referenceContext.imports == null) {
            this.typeOrPackageCache = new HashtableOfObject(1);
            return;
        }
        int numberOfStatements = this.referenceContext.imports.length;
        HashtableOfType typesBySimpleNames = null;
        for (int i2 = 0; i2 < numberOfStatements; ++i2) {
            if ((this.referenceContext.imports[i2].bits & 0x20000) != 0) continue;
            typesBySimpleNames = new HashtableOfType(this.topLevelTypes.length + numberOfStatements);
            int length = this.topLevelTypes.length;
            for (int j = 0; j < length; ++j) {
                typesBySimpleNames.put(this.topLevelTypes[j].sourceName, this.topLevelTypes[j]);
            }
            break;
        }
        int numberOfImports = numberOfStatements + 1;
        for (i = 0; i < numberOfStatements; ++i) {
            ImportReference importReference = this.referenceContext.imports[i];
            if ((importReference.bits & 0x20000) == 0 || !CharOperation.equals(TypeConstants.JAVA_LANG, importReference.tokens) || importReference.isStatic()) continue;
            --numberOfImports;
            break;
        }
        this.tempImports = new ImportBinding[numberOfImports];
        this.tempImports[0] = this.getDefaultImports()[0];
        this.importPtr = 1;
        block3: for (i = 0; i < numberOfStatements; ++i) {
            ImportReference importReference = this.referenceContext.imports[i];
            char[][] compoundName = importReference.tokens;
            for (int j = 0; j < this.importPtr; ++j) {
                ImportBinding resolved = this.tempImports[j];
                if (resolved.onDemand != ((importReference.bits & 0x20000) != 0) || resolved.isStatic() != importReference.isStatic() || !CharOperation.equals(compoundName, resolved.compoundName)) continue;
                this.problemReporter().unusedImport(importReference);
                continue block3;
            }
            if ((importReference.bits & 0x20000) != 0) {
                if (CharOperation.equals(compoundName, this.currentPackageName)) {
                    this.problemReporter().unusedImport(importReference);
                    continue;
                }
                Binding importBinding = this.findImport(compoundName, compoundName.length);
                if (!importBinding.isValidBinding()) {
                    this.problemReporter().importProblem(importReference, importBinding);
                    continue;
                }
                if (importReference.isStatic() && importBinding instanceof PackageBinding) {
                    this.problemReporter().cannotImportPackage(importReference);
                    continue;
                }
                this.recordImportBinding(new ImportBinding(compoundName, true, importBinding, importReference));
                continue;
            }
            Binding importBinding = this.findSingleImport(compoundName, 13, importReference.isStatic());
            if (!importBinding.isValidBinding() && importBinding.problemId() != 3) {
                unresolvedFound = true;
                if (!reportUnresolved) continue;
                this.problemReporter().importProblem(importReference, importBinding);
                continue;
            }
            if (importBinding instanceof PackageBinding) {
                this.problemReporter().cannotImportPackage(importReference);
                continue;
            }
            if (this.checkAndRecordImportBinding(importBinding, typesBySimpleNames, importReference, compoundName) == -1 || !importReference.isStatic()) continue;
            if (importBinding.kind() == 1) {
                this.checkMoreStaticBindings(compoundName, typesBySimpleNames, 12, importReference);
                continue;
            }
            if (importBinding.kind() != 8) continue;
            this.checkMoreStaticBindings(compoundName, typesBySimpleNames, 4, importReference);
        }
        if (this.tempImports.length > this.importPtr) {
            this.tempImports = new ImportBinding[this.importPtr];
            System.arraycopy(this.tempImports, 0, this.tempImports, 0, this.importPtr);
        }
        this.imports = this.tempImports;
        int length = this.imports.length;
        this.typeOrPackageCache = new HashtableOfObject(length);
        for (int i3 = 0; i3 < length; ++i3) {
            ImportBinding binding = this.imports[i3];
            if ((binding.onDemand || !(binding.resolvedImport instanceof ReferenceBinding)) && !(binding instanceof ImportConflictBinding)) continue;
            this.typeOrPackageCache.put(binding.compoundName[binding.compoundName.length - 1], binding);
        }
        this.skipCachingImports = this.suppressImportErrors && unresolvedFound;
    }

    public void faultInTypes() {
        this.faultInImports();
        int length = this.topLevelTypes.length;
        for (int i = 0; i < length; ++i) {
            this.topLevelTypes[i].faultInTypesForFieldsAndMethods();
        }
    }

    public Binding findImport(char[][] compoundName, boolean findStaticImports, boolean onDemand) {
        if (onDemand) {
            return this.findImport(compoundName, compoundName.length);
        }
        return this.findSingleImport(compoundName, 13, findStaticImports);
    }

    private Binding findImport(char[][] compoundName, int length) {
        ReferenceBinding type;
        int i;
        Binding binding;
        block12: {
            this.recordQualifiedReference(compoundName);
            binding = this.environment.getTopLevelPackage(compoundName[0]);
            i = 1;
            if (binding != null) {
                PackageBinding packageBinding = binding;
                while (i < length) {
                    if ((binding = packageBinding.getTypeOrPackage(compoundName[i++])) == null || !binding.isValidBinding()) {
                        binding = null;
                    } else if (binding instanceof PackageBinding) {
                        packageBinding = (PackageBinding)binding;
                        continue;
                    }
                    break block12;
                }
                return packageBinding;
            }
        }
        if (binding == null) {
            if (this.compilerOptions().complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), null, 1);
            }
            type = this.findType(compoundName[0], this.environment.defaultPackage, this.environment.defaultPackage);
            if (type == null || !type.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), null, 1);
            }
            i = 1;
        } else {
            type = (ReferenceBinding)binding;
        }
        while (i < length) {
            char[] name;
            if (!(type = (ReferenceBinding)this.environment.convertToRawType(type, false)).canBeSeenBy(this.fPackage)) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), type, 2);
            }
            if ((type = type.getMemberType(name = compoundName[i++])) != null) continue;
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), null, 1);
        }
        if (!type.canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(compoundName, type, 2);
        }
        return type;
    }

    private Binding findSingleImport(char[][] compoundName, int mask, boolean findStaticImports) {
        if (compoundName.length == 1) {
            if (this.compilerOptions().complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(compoundName, null, 1);
            }
            ReferenceBinding typeBinding = this.findType(compoundName[0], this.environment.defaultPackage, this.fPackage);
            if (typeBinding == null) {
                return new ProblemReferenceBinding(compoundName, null, 1);
            }
            return typeBinding;
        }
        if (findStaticImports) {
            return this.findSingleStaticImport(compoundName, mask);
        }
        return this.findImport(compoundName, compoundName.length);
    }

    private Binding findSingleStaticImport(char[][] compoundName, int mask) {
        MethodBinding method;
        FieldBinding field;
        Binding binding = this.findImport(compoundName, compoundName.length - 1);
        if (!binding.isValidBinding()) {
            return binding;
        }
        char[] name = compoundName[compoundName.length - 1];
        if (binding instanceof PackageBinding) {
            Binding temp = ((PackageBinding)binding).getTypeOrPackage(name);
            if (temp != null && temp instanceof ReferenceBinding) {
                return new ProblemReferenceBinding(compoundName, (ReferenceBinding)temp, 14);
            }
            return binding;
        }
        ReferenceBinding type = (ReferenceBinding)binding;
        FieldBinding fieldBinding = field = (mask & 1) != 0 ? this.findField(type, name, null, true) : null;
        if (field != null) {
            if (field.problemId() == 3 && ((ProblemFieldBinding)field).closestMatch.isStatic()) {
                return field;
            }
            if (field.isValidBinding() && field.isStatic() && field.canBeSeenBy(type, null, this)) {
                return field;
            }
        }
        MethodBinding methodBinding = method = (mask & 8) != 0 ? this.findStaticMethod(type, name) : null;
        if (method != null) {
            return method;
        }
        if ((type = this.findMemberType(name, type)) == null || !type.isStatic()) {
            if (field != null && !field.isValidBinding() && field.problemId() != 1) {
                return field;
            }
            return new ProblemReferenceBinding(compoundName, type, 1);
        }
        if (type.isValidBinding() && !type.canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(compoundName, type, 2);
        }
        if (type.problemId() == 2) {
            return new ProblemReferenceBinding(compoundName, ((ProblemReferenceBinding)type).closestMatch, 2);
        }
        return type;
    }

    private MethodBinding findStaticMethod(ReferenceBinding currentType, char[] selector) {
        if (!currentType.canBeSeenBy(this)) {
            return null;
        }
        do {
            currentType.initializeForStaticImports();
            MethodBinding[] methods = currentType.getMethods(selector);
            if (methods == Binding.NO_METHODS) continue;
            int i = methods.length;
            while (--i >= 0) {
                MethodBinding method = methods[i];
                if (!method.isStatic() || !method.canBeSeenBy(this.fPackage)) continue;
                return method;
            }
        } while ((currentType = currentType.superclass()) != null);
        return null;
    }

    ImportBinding[] getDefaultImports() {
        if (this.environment.defaultImports != null) {
            return this.environment.defaultImports;
        }
        Binding importBinding = this.environment.getTopLevelPackage(TypeConstants.JAVA);
        if (importBinding != null) {
            importBinding = importBinding.getTypeOrPackage(TypeConstants.JAVA_LANG[1]);
        }
        if (importBinding == null || !importBinding.isValidBinding()) {
            this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_OBJECT, this.referenceContext, this.environment.missingClassFileLocation);
            MissingTypeBinding missingObject = this.environment.createMissingType(null, TypeConstants.JAVA_LANG_OBJECT);
            importBinding = missingObject.fPackage;
        }
        this.environment.defaultImports = new ImportBinding[]{new ImportBinding(TypeConstants.JAVA_LANG, true, importBinding, null)};
        return this.environment.defaultImports;
    }

    public final Binding getImport(char[][] compoundName, boolean onDemand, boolean isStaticImport) {
        if (onDemand) {
            return this.findImport(compoundName, compoundName.length);
        }
        return this.findSingleImport(compoundName, 13, isStaticImport);
    }

    public int nextCaptureID() {
        return this.captureID++;
    }

    @Override
    public ProblemReporter problemReporter() {
        ProblemReporter problemReporter = this.referenceContext.problemReporter;
        problemReporter.referenceContext = this.referenceContext;
        return problemReporter;
    }

    void recordQualifiedReference(char[][] qualifiedName) {
        if (this.qualifiedReferences == null) {
            return;
        }
        int length = ((char[][])qualifiedName).length;
        if (length > 1) {
            this.recordRootReference(qualifiedName[0]);
            while (!this.qualifiedReferences.contains((char[][])qualifiedName)) {
                this.qualifiedReferences.add((char[][])qualifiedName);
                if (length == 2) {
                    this.recordSimpleReference(qualifiedName[0]);
                    this.recordSimpleReference(qualifiedName[1]);
                    return;
                }
                this.recordSimpleReference(qualifiedName[--length]);
                char[][] cArray = qualifiedName;
                char[][] cArrayArray = new char[length][];
                qualifiedName = cArrayArray;
                System.arraycopy(cArray, 0, cArrayArray, 0, length);
            }
        } else if (length == 1) {
            this.recordRootReference(qualifiedName[0]);
            this.recordSimpleReference(qualifiedName[0]);
        }
    }

    void recordReference(char[][] qualifiedEnclosingName, char[] simpleName) {
        this.recordQualifiedReference(qualifiedEnclosingName);
        if (qualifiedEnclosingName.length == 0) {
            this.recordRootReference(simpleName);
        }
        this.recordSimpleReference(simpleName);
    }

    void recordReference(ReferenceBinding type, char[] simpleName) {
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null) {
            this.recordReference(actualType.compoundName, simpleName);
        }
    }

    void recordRootReference(char[] simpleName) {
        if (this.rootReferences == null) {
            return;
        }
        if (!this.rootReferences.contains(simpleName)) {
            this.rootReferences.add(simpleName);
        }
    }

    void recordSimpleReference(char[] simpleName) {
        if (this.simpleNameReferences == null) {
            return;
        }
        if (!this.simpleNameReferences.contains(simpleName)) {
            this.simpleNameReferences.add(simpleName);
        }
    }

    void recordSuperTypeReference(TypeBinding type) {
        if (this.referencedSuperTypes == null) {
            return;
        }
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null && !this.referencedSuperTypes.containsIdentical(actualType)) {
            this.referencedSuperTypes.add(actualType);
        }
    }

    public void recordTypeConversion(TypeBinding superType, TypeBinding subType) {
        this.recordSuperTypeReference(subType);
    }

    void recordTypeReference(TypeBinding type) {
        if (this.referencedTypes == null) {
            return;
        }
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null && !this.referencedTypes.containsIdentical(actualType)) {
            this.referencedTypes.add(actualType);
        }
    }

    void recordTypeReferences(TypeBinding[] types) {
        if (this.referencedTypes == null) {
            return;
        }
        if (types == null || types.length == 0) {
            return;
        }
        int max = types.length;
        for (int i = 0; i < max; ++i) {
            ReferenceBinding actualType = this.typeToRecord(types[i]);
            if (actualType == null || this.referencedTypes.containsIdentical(actualType)) continue;
            this.referencedTypes.add(actualType);
        }
    }

    Binding resolveSingleImport(ImportBinding importBinding, int mask) {
        if (importBinding.resolvedImport == null) {
            importBinding.resolvedImport = this.findSingleImport(importBinding.compoundName, mask, importBinding.isStatic());
            if (!importBinding.resolvedImport.isValidBinding() || importBinding.resolvedImport instanceof PackageBinding) {
                if (importBinding.resolvedImport.problemId() == 3) {
                    return importBinding.resolvedImport;
                }
                if (this.imports != null) {
                    ImportBinding[] newImports = new ImportBinding[this.imports.length - 1];
                    int n = 0;
                    int max = this.imports.length;
                    for (int i = 0; i < max; ++i) {
                        if (this.imports[i] == importBinding) continue;
                        newImports[n++] = this.imports[i];
                    }
                    this.imports = newImports;
                }
                return null;
            }
        }
        return importBinding.resolvedImport;
    }

    public void storeDependencyInfo() {
        int i;
        for (i = 0; i < this.referencedSuperTypes.size; ++i) {
            ReferenceBinding[] interfaces;
            ReferenceBinding superclass;
            ReferenceBinding enclosing;
            ReferenceBinding type = (ReferenceBinding)this.referencedSuperTypes.elementAt(i);
            if (!this.referencedTypes.containsIdentical(type)) {
                this.referencedTypes.add(type);
            }
            if (!type.isLocalType() && (enclosing = type.enclosingType()) != null) {
                this.recordSuperTypeReference(enclosing);
            }
            if ((superclass = type.superclass()) != null) {
                this.recordSuperTypeReference(superclass);
            }
            if ((interfaces = type.superInterfaces()) == null) continue;
            int length = interfaces.length;
            for (int j = 0; j < length; ++j) {
                this.recordSuperTypeReference(interfaces[j]);
            }
        }
        int l = this.referencedTypes.size;
        for (i = 0; i < l; ++i) {
            ReferenceBinding type = (ReferenceBinding)this.referencedTypes.elementAt(i);
            if (type.isLocalType()) continue;
            this.recordQualifiedReference(type.isMemberType() ? CharOperation.splitOn('.', type.readableName()) : type.compoundName);
        }
        int size = this.qualifiedReferences.size;
        char[][][] qualifiedRefs = new char[size][][];
        for (int i2 = 0; i2 < size; ++i2) {
            qualifiedRefs[i2] = this.qualifiedReferences.elementAt(i2);
        }
        this.referenceContext.compilationResult.qualifiedReferences = qualifiedRefs;
        size = this.simpleNameReferences.size;
        char[][] simpleRefs = new char[size][];
        for (int i3 = 0; i3 < size; ++i3) {
            simpleRefs[i3] = this.simpleNameReferences.elementAt(i3);
        }
        this.referenceContext.compilationResult.simpleNameReferences = simpleRefs;
        size = this.rootReferences.size;
        char[][] rootRefs = new char[size][];
        for (int i4 = 0; i4 < size; ++i4) {
            rootRefs[i4] = this.rootReferences.elementAt(i4);
        }
        this.referenceContext.compilationResult.rootReferences = rootRefs;
    }

    public String toString() {
        return "--- CompilationUnit Scope : " + new String(this.referenceContext.getFileName());
    }

    private ReferenceBinding typeToRecord(TypeBinding type) {
        while (type.isArrayType()) {
            type = ((ArrayBinding)type).leafComponentType();
        }
        switch (type.kind()) {
            case 132: 
            case 516: 
            case 4100: 
            case 8196: 
            case 32772: 
            case 65540: {
                return null;
            }
            case 260: 
            case 1028: {
                type = type.erasure();
            }
        }
        ReferenceBinding refType = (ReferenceBinding)type;
        if (refType.isLocalType()) {
            return null;
        }
        return refType;
    }

    public void verifyMethods(MethodVerifier verifier) {
        int length = this.topLevelTypes.length;
        for (int i = 0; i < length; ++i) {
            this.topLevelTypes[i].verifyMethods(verifier);
        }
    }

    private void recordImportBinding(ImportBinding bindingToAdd) {
        if (this.tempImports.length == this.importPtr) {
            this.tempImports = new ImportBinding[this.importPtr + 1];
            System.arraycopy(this.tempImports, 0, this.tempImports, 0, this.importPtr);
        }
        this.tempImports[this.importPtr++] = bindingToAdd;
    }

    private void checkMoreStaticBindings(char[][] compoundName, HashtableOfType typesBySimpleNames, int mask, ImportReference importReference) {
        Binding importBinding = this.findSingleStaticImport(compoundName, mask);
        if (!importBinding.isValidBinding()) {
            if (importBinding.problemId() == 3) {
                this.checkAndRecordImportBinding(importBinding, typesBySimpleNames, importReference, compoundName);
            }
        } else {
            this.checkAndRecordImportBinding(importBinding, typesBySimpleNames, importReference, compoundName);
        }
        if ((mask & 8) != 0 && importBinding.kind() == 8) {
            this.checkMoreStaticBindings(compoundName, typesBySimpleNames, mask &= 0xFFFFFFF7, importReference);
        }
    }

    private int checkAndRecordImportBinding(Binding importBinding, HashtableOfType typesBySimpleNames, ImportReference importReference, char[][] compoundName) {
        ReferenceBinding conflictingType = null;
        if (importBinding instanceof MethodBinding && (!(conflictingType = (ReferenceBinding)this.getType(compoundName, compoundName.length)).isValidBinding() || importReference.isStatic() && !conflictingType.isStatic())) {
            conflictingType = null;
        }
        char[] name = compoundName[compoundName.length - 1];
        if (importBinding instanceof ReferenceBinding || conflictingType != null) {
            ReferenceBinding existingType;
            ReferenceBinding typeToCheck;
            ReferenceBinding referenceBinding = conflictingType == null ? (ReferenceBinding)importBinding : conflictingType;
            ReferenceBinding referenceBinding2 = typeToCheck = referenceBinding.problemId() == 3 ? ((ProblemReferenceBinding)referenceBinding).closestMatch : referenceBinding;
            if (importReference.isTypeUseDeprecated(typeToCheck, this)) {
                this.problemReporter().deprecatedType(typeToCheck, importReference);
            }
            if ((existingType = typesBySimpleNames.get(name)) != null) {
                int j;
                if (TypeBinding.equalsEquals(existingType, referenceBinding)) {
                    for (int j2 = 0; j2 < this.importPtr; ++j2) {
                        ImportBinding resolved = this.tempImports[j2];
                        if (resolved instanceof ImportConflictBinding) {
                            ImportConflictBinding importConflictBinding = (ImportConflictBinding)resolved;
                            if (!TypeBinding.equalsEquals(importConflictBinding.conflictingTypeBinding, referenceBinding) || importReference.isStatic()) continue;
                            this.problemReporter().duplicateImport(importReference);
                            this.recordImportBinding(new ImportBinding(compoundName, false, importBinding, importReference));
                            continue;
                        }
                        if (resolved.resolvedImport != referenceBinding || importReference.isStatic() == resolved.isStatic()) continue;
                        this.problemReporter().duplicateImport(importReference);
                        this.recordImportBinding(new ImportBinding(compoundName, false, importBinding, importReference));
                    }
                    return -1;
                }
                int length = this.topLevelTypes.length;
                for (j = 0; j < length; ++j) {
                    if (!CharOperation.equals(this.topLevelTypes[j].sourceName, existingType.sourceName)) continue;
                    this.problemReporter().conflictingImport(importReference);
                    return -1;
                }
                if (importReference.isStatic() && importBinding instanceof ReferenceBinding && this.compilerOptions().sourceLevel >= 0x340000L) {
                    for (j = 0; j < this.importPtr; ++j) {
                        ImportBinding resolved = this.tempImports[j];
                        if (!resolved.isStatic() || !(resolved.resolvedImport instanceof ReferenceBinding) || importBinding == resolved.resolvedImport || !CharOperation.equals(name, resolved.compoundName[resolved.compoundName.length - 1])) continue;
                        ReferenceBinding type = (ReferenceBinding)resolved.resolvedImport;
                        resolved.resolvedImport = new ProblemReferenceBinding(new char[][]{name}, type, 3);
                        return -1;
                    }
                }
                this.problemReporter().duplicateImport(importReference);
                return -1;
            }
            typesBySimpleNames.put(name, referenceBinding);
        } else if (importBinding instanceof FieldBinding) {
            for (int j = 0; j < this.importPtr; ++j) {
                ImportBinding resolved = this.tempImports[j];
                if (!resolved.isStatic() || !(resolved.resolvedImport instanceof FieldBinding) || importBinding == resolved.resolvedImport || !CharOperation.equals(name, resolved.compoundName[resolved.compoundName.length - 1])) continue;
                if (this.compilerOptions().sourceLevel >= 0x340000L) {
                    FieldBinding field = (FieldBinding)resolved.resolvedImport;
                    resolved.resolvedImport = new ProblemFieldBinding(field, field.declaringClass, name, 3);
                    return -1;
                }
                this.problemReporter().duplicateImport(importReference);
                return -1;
            }
        }
        if (conflictingType == null) {
            this.recordImportBinding(new ImportBinding(compoundName, false, importBinding, importReference));
        } else {
            this.recordImportBinding(new ImportConflictBinding(compoundName, importBinding, conflictingType, importReference));
        }
        return this.importPtr;
    }

    @Override
    public boolean hasDefaultNullnessFor(int location) {
        if (this.fPackage != null) {
            return (this.fPackage.defaultNullness & location) != 0;
        }
        return false;
    }
}

