/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding.source;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLStreamDataWriter
implements DataWriter<XMLStreamWriter> {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLStreamDataWriter.class);
    private Schema schema;

    public void write(Object obj, MessagePartInfo part, XMLStreamWriter output) {
        this.write(obj, output);
    }

    public void write(Object obj, XMLStreamWriter writer) {
        try {
            XMLStreamReader reader = null;
            if (obj instanceof DataSource) {
                DataSource ds = (DataSource)obj;
                if (this.schema != null) {
                    DOMSource domSource = new DOMSource(StaxUtils.read((InputStream)ds.getInputStream()));
                    this.schema.newValidator().validate(domSource);
                    StaxUtils.copy((Source)domSource, (XMLStreamWriter)writer);
                } else {
                    reader = StaxUtils.createXMLStreamReader((InputStream)ds.getInputStream());
                    StaxUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
                    reader.close();
                }
            } else if (obj instanceof Node) {
                if (this.schema != null) {
                    this.schema.newValidator().validate(new DOMSource((Node)obj));
                }
                Node nd = (Node)obj;
                this.writeNode(nd, writer);
            } else {
                Source s = (Source)obj;
                if (this.schema != null) {
                    if (!(s instanceof DOMSource)) {
                        s = new DOMSource(StaxUtils.read((Source)s));
                    }
                    this.schema.newValidator().validate(s);
                }
                if (s instanceof DOMSource && ((DOMSource)s).getNode() == null) {
                    return;
                }
                StaxUtils.copy((Source)s, (XMLStreamWriter)writer);
            }
        }
        catch (XMLStreamException e) {
            throw new Fault("COULD_NOT_WRITE_XML_STREAM_CAUSED_BY", LOG, (Throwable)e, new Object[]{e.getClass().getCanonicalName(), e.getMessage()});
        }
        catch (IOException e) {
            throw new Fault(new Message("COULD_NOT_WRITE_XML_STREAM", LOG, new Object[0]), (Throwable)e);
        }
        catch (SAXException e) {
            throw new Fault("COULD_NOT_WRITE_XML_STREAM_CAUSED_BY", LOG, (Throwable)e, new Object[]{e.getClass().getCanonicalName(), e.getMessage()});
        }
    }

    private void writeNode(Node nd, XMLStreamWriter writer) throws XMLStreamException {
        if (writer instanceof W3CDOMStreamWriter) {
            W3CDOMStreamWriter dw = (W3CDOMStreamWriter)writer;
            if (dw.getCurrentNode() != null) {
                if (nd instanceof DocumentFragment && nd.getOwnerDocument() == dw.getCurrentNode().getOwnerDocument()) {
                    Node ch = nd.getFirstChild();
                    while (ch != null) {
                        nd.removeChild(ch);
                        dw.getCurrentNode().appendChild(ch);
                        ch = nd.getFirstChild();
                    }
                } else {
                    if (nd.getOwnerDocument() == dw.getCurrentNode().getOwnerDocument()) {
                        dw.getCurrentNode().appendChild(nd);
                        return;
                    }
                    if (nd instanceof DocumentFragment) {
                        nd = dw.getDocument().importNode(nd, true);
                        dw.getCurrentNode().appendChild(nd);
                        return;
                    }
                }
            } else if (dw.getCurrentFragment() != null) {
                if (nd.getOwnerDocument() == dw.getCurrentFragment().getOwnerDocument()) {
                    dw.getCurrentFragment().appendChild(nd);
                    return;
                }
                if (nd instanceof DocumentFragment) {
                    nd = dw.getDocument().importNode(nd, true);
                    dw.getCurrentFragment().appendChild(nd);
                    return;
                }
            }
        }
        if (nd instanceof Document) {
            StaxUtils.writeDocument((Document)((Document)nd), (XMLStreamWriter)writer, (boolean)false, (boolean)true);
        } else {
            StaxUtils.writeNode((Node)nd, (XMLStreamWriter)writer, (boolean)true);
        }
    }

    public void setSchema(Schema s) {
        this.schema = s;
    }

    public void setAttachments(Collection<Attachment> attachments) {
    }

    public void setProperty(String key, Object value) {
    }
}

