/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.ThreadBindingListener;
import org.apache.catalina.authenticator.Constants;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.web.CatalinaMessages;

public class SingleSignOn
extends ValveBase
implements Lifecycle,
SessionListener {
    protected Map<String, SingleSignOnEntry> cache = new HashMap<String, SingleSignOnEntry>();
    protected static String info = "org.apache.catalina.authenticator.SingleSignOn";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected boolean requireReauthentication = false;
    protected Map<Session, String> reverse = new HashMap<Session, String>();
    protected boolean started = false;
    protected String cookieDomain;
    protected boolean cookieHttpOnly = true;

    public boolean isCookieHttpOnly() {
        return this.cookieHttpOnly;
    }

    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        if (cookieDomain != null && cookieDomain.trim().length() == 0) {
            cookieDomain = null;
        }
        this.cookieDomain = cookieDomain;
    }

    public boolean getRequireReauthentication() {
        return this.requireReauthentication;
    }

    public void setRequireReauthentication(boolean required) {
        this.requireReauthentication = required;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(CatalinaMessages.MESSAGES.valveAlreadyStarted());
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(CatalinaMessages.MESSAGES.valveNotStarted());
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType()) && !"passivateSession".equals(event.getType())) {
            return;
        }
        if ("passivateSession".equals(event.getType()) && event.getData() != null && event.getData().equals("REPLICATION")) {
            return;
        }
        Session session = event.getSession();
        String ssoId = null;
        Map<Session, String> map = this.reverse;
        synchronized (map) {
            ssoId = this.reverse.get(session);
        }
        if (ssoId == null) {
            return;
        }
        if (session.getMaxInactiveInterval() > 0 && System.currentTimeMillis() - session.getLastAccessedTimeInternal() >= (long)(session.getMaxInactiveInterval() * 1000) || "passivateSession".equals(event.getType())) {
            this.removeSession(ssoId, session);
        } else {
            this.deregister(ssoId);
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        request.removeNote("org.apache.catalina.request.SSOID");
        if (request.getUserPrincipal() != null) {
            this.getNext().invoke(request, response);
            return;
        }
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!Constants.SINGLE_SIGN_ON_COOKIE.equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            this.getNext().invoke(request, response);
            return;
        }
        SingleSignOnEntry entry = this.lookup(cookie.getValue());
        if (entry != null) {
            request.setNote("org.apache.catalina.request.SSOID", cookie.getValue());
            if (!this.getRequireReauthentication()) {
                request.setAuthType(entry.getAuthType());
                request.setUserPrincipal(entry.getPrincipal());
            }
        } else {
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
        this.getNext().invoke(request, response);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SingleSignOn[");
        if (this.container == null) {
            sb.append("Container is null");
        } else {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associate(String ssoId, Session session) {
        SingleSignOnEntry sso = this.lookup(ssoId);
        if (sso != null) {
            sso.addSession(this, session);
        }
        Map<Session, String> map = this.reverse;
        synchronized (map) {
            this.reverse.put(session, ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, Session session) {
        Map<Session, String> map = this.reverse;
        synchronized (map) {
            this.reverse.remove(session);
        }
        SingleSignOnEntry sso = this.lookup(ssoId);
        if (sso == null) {
            return;
        }
        sso.removeSession(session);
        Session[] sessions = sso.findSessions();
        if (sessions == null || sessions.length == 0) {
            Map<String, SingleSignOnEntry> map2 = this.cache;
            synchronized (map2) {
                sso = this.cache.remove(ssoId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String ssoId) {
        SingleSignOnEntry sso = null;
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            sso = this.cache.remove(ssoId);
        }
        if (sso == null) {
            return;
        }
        Session[] sessions = sso.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Map<Session, String> map2 = this.reverse;
            synchronized (map2) {
                this.reverse.remove(sessions[i]);
            }
            ClassLoader oldContextClassLoader = null;
            try {
                oldContextClassLoader = this.bindThread(sessions[i]);
                sessions[i].expire();
                continue;
            }
            finally {
                if (oldContextClassLoader != null) {
                    this.unbindThread(sessions[i], oldContextClassLoader);
                }
            }
        }
    }

    protected ClassLoader bindThread(Session session) {
        Manager manager = session.getManager();
        Container context = null;
        ClassLoader contextClassLoader = null;
        ThreadBindingListener threadBindingListener = null;
        if (manager != null && manager.getContainer() != null && manager.getContainer() instanceof Context) {
            context = (Context)manager.getContainer();
        }
        if (context != null) {
            if (context.getLoader() != null && context.getLoader().getClassLoader() != null) {
                contextClassLoader = context.getLoader().getClassLoader();
            }
            threadBindingListener = context.getThreadBindingListener();
        }
        if (threadBindingListener == null || contextClassLoader == null) {
            return null;
        }
        if (Globals.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(new PrivilegedBind(contextClassLoader, threadBindingListener));
        }
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(contextClassLoader);
        threadBindingListener.bind();
        return oldContextClassLoader;
    }

    protected void unbindThread(Session session, ClassLoader oldContextClassLoader) {
        Manager manager = session.getManager();
        Context context = null;
        ThreadBindingListener threadBindingListener = null;
        if (manager != null && manager.getContainer() != null && manager.getContainer() instanceof Context) {
            context = (Context)manager.getContainer();
        }
        if (context != null) {
            threadBindingListener = context.getThreadBindingListener();
        }
        if (threadBindingListener == null) {
            return;
        }
        if (Globals.IS_SECURITY_ENABLED) {
            AccessController.doPrivileged(new PrivilegedUnbind(oldContextClassLoader, threadBindingListener));
        } else {
            threadBindingListener.unbind();
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogin(String ssoId) {
        Session[] sessions;
        SingleSignOnEntry sso = null;
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            sso = this.cache.get(ssoId);
        }
        if (sso == null) {
            return;
        }
        for (Session session : sessions = sso.findSessions()) {
            session.setAuthType(null);
            session.setPrincipal(null);
            session.removeNote("org.apache.catalina.session.USERNAME");
            session.removeNote("org.apache.catalina.session.PASSWORD");
        }
        sso.updateCredentials(null, null, null, null);
    }

    public boolean reauthenticate(String ssoId, Realm realm, Request request) {
        Principal reauthPrincipal;
        String username;
        if (ssoId == null || realm == null) {
            return false;
        }
        boolean reauthenticated = false;
        SingleSignOnEntry entry = this.lookup(ssoId);
        if (entry != null && entry.getCanReauthenticate() && (username = entry.getUsername()) != null && (reauthPrincipal = realm.authenticate(username, entry.getPassword())) != null) {
            reauthenticated = true;
            request.setAuthType(entry.getAuthType());
            request.setUserPrincipal(reauthPrincipal);
        }
        return reauthenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String ssoId, Principal principal, String authType, String username, String password) {
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            this.cache.put(ssoId, new SingleSignOnEntry(principal, authType, username, password));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String ssoId, Principal principal, String authType, String username, String password) {
        SingleSignOnEntry sso = this.lookup(ssoId);
        if (sso != null && !sso.getCanReauthenticate()) {
            SingleSignOnEntry singleSignOnEntry = sso;
            synchronized (singleSignOnEntry) {
                sso.updateCredentials(principal, authType, username, password);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry lookup(String ssoId) {
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            return this.cache.get(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(String ssoId, Session session) {
        SingleSignOnEntry entry = this.lookup(ssoId);
        if (entry == null) {
            return;
        }
        entry.removeSession(session);
        Map<Session, String> map = this.reverse;
        synchronized (map) {
            this.reverse.remove(session);
        }
        if (entry.findSessions().length == 0) {
            this.deregister(ssoId);
        }
    }

    protected class PrivilegedUnbind
    implements PrivilegedAction<Void> {
        private ClassLoader oldContextClassLoader;
        private ThreadBindingListener threadBindingListener;

        PrivilegedUnbind(ClassLoader oldContextClassLoader, ThreadBindingListener threadBindingListener) {
            this.oldContextClassLoader = oldContextClassLoader;
            this.threadBindingListener = threadBindingListener;
        }

        @Override
        public Void run() {
            this.threadBindingListener.unbind();
            Thread.currentThread().setContextClassLoader(this.oldContextClassLoader);
            return null;
        }
    }

    protected class PrivilegedBind
    implements PrivilegedAction<ClassLoader> {
        private ClassLoader contextClassLoader;
        private ThreadBindingListener threadBindingListener;

        PrivilegedBind(ClassLoader contextClassLoader, ThreadBindingListener threadBindingListener) {
            this.contextClassLoader = contextClassLoader;
            this.threadBindingListener = threadBindingListener;
        }

        @Override
        public ClassLoader run() {
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
            this.threadBindingListener.bind();
            return oldContextClassLoader;
        }
    }
}

