/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletSecurityElement;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.DummyRequest;
import org.apache.catalina.core.DummyResponse;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapperFacade;
import org.apache.catalina.core.StandardWrapperValve;
import org.apache.catalina.deploy.Multipart;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.InstanceSupport;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.PeriodicEventListener;
import org.apache.tomcat.util.Constants;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.web.CatalinaLogger;
import org.jboss.web.CatalinaMessages;

public class StandardWrapper
extends ContainerBase
implements ServletConfig,
Wrapper,
NotificationEmitter {
    protected static final String[] DEFAULT_SERVLET_METHODS = new String[]{"GET", "HEAD", "POST"};
    protected boolean asyncSupported = false;
    protected boolean dynamic = false;
    protected boolean enabled = true;
    protected long available = 0L;
    protected NotificationBroadcasterSupport broadcaster = null;
    protected int countAllocated = 0;
    protected String description = null;
    protected StandardWrapperFacade facade = new StandardWrapperFacade(this);
    protected static final String info = "org.apache.catalina.core.StandardWrapper/1.0";
    protected Servlet instance = null;
    protected Servlet servletInstance = null;
    protected InstanceSupport instanceSupport = new InstanceSupport(this);
    protected String jspFile = null;
    protected int loadOnStartup = -1;
    protected Multipart multipartConfig = null;
    protected ArrayList mappings = new ArrayList();
    protected HashMap parameters = new HashMap();
    protected HashMap references = new HashMap();
    protected String runAs = null;
    protected ServletSecurityElement servletSecurity = null;
    protected long sequenceNumber = 0L;
    protected String servletClass = null;
    protected boolean singleThreadModel = false;
    protected boolean unloading = false;
    protected int maxInstances = 20;
    protected int nInstances = 0;
    protected Stack instancePool = null;
    protected long unloadDelay = 2000L;
    protected boolean isJspServlet;
    protected ObjectName jspMonitorON;
    protected StandardWrapperValve swValve = new StandardWrapperValve();
    protected long loadTime = 0L;
    protected int classLoadTime = 0;
    protected static Class[] classType = new Class[]{ServletConfig.class};
    protected static Class[] classTypeUsedInService = new Class[]{ServletRequest.class, ServletResponse.class};
    protected MBeanNotificationInfo[] notificationInfo;

    public StandardWrapper() {
        this.pipeline.setBasic(this.swValve);
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    @Override
    public boolean getAsyncSupported() {
        return this.asyncSupported;
    }

    @Override
    public void setAsyncSupported(boolean value) {
        boolean oldAsyncSupported = this.asyncSupported;
        this.asyncSupported = value;
        this.support.firePropertyChange("asyncSupported", oldAsyncSupported, this.asyncSupported);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        String oldDescription = this.description;
        this.description = description;
        this.support.firePropertyChange("description", oldDescription, description);
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
        if (dynamic) {
            this.facade = new StandardWrapperFacade.Dynamic(this);
        }
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        boolean oldEnabled = this.enabled;
        this.enabled = value;
        this.support.firePropertyChange("enabled", oldEnabled, this.enabled);
    }

    @Override
    public long getAvailable() {
        return this.available;
    }

    @Override
    public void setAvailable(long available) {
        long oldAvailable = this.available;
        this.available = available > System.currentTimeMillis() ? available : 0L;
        this.support.firePropertyChange("available", new Long(oldAvailable), new Long(this.available));
    }

    public int getCountAllocated() {
        return this.countAllocated;
    }

    public String getEngineName() {
        return ((StandardContext)this.getParent()).getEngineName();
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public InstanceSupport getInstanceSupport() {
        return this.instanceSupport;
    }

    @Override
    public String getJspFile() {
        return this.jspFile;
    }

    @Override
    public void setJspFile(String jspFile) {
        String oldJspFile = this.jspFile;
        this.jspFile = jspFile;
        this.support.firePropertyChange("jspFile", oldJspFile, this.jspFile);
        this.isJspServlet = true;
    }

    @Override
    public int getLoadOnStartup() {
        if (this.isJspServlet && this.loadOnStartup < 0) {
            return Integer.MAX_VALUE;
        }
        return this.loadOnStartup;
    }

    @Override
    public void setLoadOnStartup(int value) {
        int oldLoadOnStartup = this.loadOnStartup;
        this.loadOnStartup = value;
        this.support.firePropertyChange("loadOnStartup", new Integer(oldLoadOnStartup), new Integer(this.loadOnStartup));
    }

    public void setLoadOnStartupString(String value) {
        try {
            this.setLoadOnStartup(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            this.setLoadOnStartup(0);
        }
    }

    public String getLoadOnStartupString() {
        return Integer.toString(this.getLoadOnStartup());
    }

    @Override
    public Multipart getMultipartConfig() {
        return this.multipartConfig;
    }

    @Override
    public void setMultipartConfig(Multipart multipartConfig) {
        this.multipartConfig = multipartConfig;
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public void setMaxInstances(int maxInstances) {
        int oldMaxInstances = this.maxInstances;
        this.maxInstances = maxInstances;
        this.support.firePropertyChange("maxInstances", oldMaxInstances, this.maxInstances);
    }

    @Override
    public void setParent(Container container) {
        if (container != null && !(container instanceof Context)) {
            throw CatalinaMessages.MESSAGES.wrapperParentMustBeContext();
        }
        if (container instanceof StandardContext) {
            this.unloadDelay = ((StandardContext)container).getUnloadDelay();
        }
        super.setParent(container);
    }

    @Override
    public String getRunAs() {
        return this.runAs;
    }

    @Override
    public void setRunAs(String runAs) {
        String oldRunAs = this.runAs;
        this.runAs = runAs;
        this.support.firePropertyChange("runAs", oldRunAs, this.runAs);
    }

    @Override
    public ServletSecurityElement getServletSecurity() {
        return this.servletSecurity;
    }

    @Override
    public Set<String> setServletSecurity(ServletSecurityElement servletSecurity) {
        SecurityConstraint[] constraints;
        ServletSecurityElement oldServletSecurity = this.servletSecurity;
        this.servletSecurity = servletSecurity;
        this.support.firePropertyChange("servletSecurity", oldServletSecurity, this.servletSecurity);
        HashSet<String> ignoredPatterns = new HashSet<String>();
        HashSet<String> currentMappings = new HashSet<String>();
        for (String mapping : this.findMappings()) {
            currentMappings.add(mapping);
        }
        for (SecurityConstraint constraint : constraints = ((Context)this.getParent()).findConstraints()) {
            for (SecurityCollection collection : constraint.findCollections()) {
                for (String pattern : collection.findPatterns()) {
                    if (!currentMappings.contains(pattern)) continue;
                    ignoredPatterns.add(pattern);
                }
            }
        }
        return ignoredPatterns;
    }

    @Override
    public String getServletClass() {
        return this.servletClass;
    }

    @Override
    public void setServletClass(String servletClass) {
        String oldServletClass = this.servletClass;
        this.servletClass = servletClass;
        this.support.firePropertyChange("servletClass", oldServletClass, this.servletClass);
        if ("org.apache.jasper.servlet.JspServlet".equals(servletClass)) {
            this.isJspServlet = true;
        }
    }

    public void setServletName(String name) {
        this.setName(name);
    }

    public boolean isSingleThreadModel() {
        try {
            this.loadServlet();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.singleThreadModel;
    }

    @Override
    public boolean isUnavailable() {
        if (this.available == 0L) {
            return false;
        }
        if (this.available <= System.currentTimeMillis()) {
            this.available = 0L;
            return false;
        }
        return true;
    }

    @Override
    public ServletRegistration getFacade() {
        return this.facade;
    }

    @Override
    public String[] getServletMethods() throws ServletException {
        Class<?> servletClazz = this.loadServlet().getClass();
        if (!HttpServlet.class.isAssignableFrom(servletClazz)) {
            return DEFAULT_SERVLET_METHODS;
        }
        HashSet<String> allow = new HashSet<String>();
        allow.add("TRACE");
        allow.add("OPTIONS");
        Method[] methods = this.getAllDeclaredMethods(servletClazz);
        for (int i = 0; methods != null && i < methods.length; ++i) {
            Method m = methods[i];
            if (m.getName().equals("doGet")) {
                allow.add("GET");
                allow.add("HEAD");
                continue;
            }
            if (m.getName().equals("doPost")) {
                allow.add("POST");
                continue;
            }
            if (m.getName().equals("doPut")) {
                allow.add("PUT");
                continue;
            }
            if (!m.getName().equals("doDelete")) continue;
            allow.add("DELETE");
        }
        String[] methodNames = new String[allow.size()];
        return allow.toArray(methodNames);
    }

    @Override
    public void backgroundProcess() {
        super.backgroundProcess();
        if (!this.started) {
            return;
        }
        if (this.getServlet() != null && this.getServlet() instanceof PeriodicEventListener) {
            ((PeriodicEventListener)this.getServlet()).periodicEvent();
        }
    }

    public static Throwable getRootCause(ServletException e) {
        Object rootCause = e;
        Throwable rootCauseCheck = null;
        int loops = 0;
        do {
            ++loops;
            rootCauseCheck = rootCause.getCause();
            if (rootCauseCheck == null) continue;
            rootCause = rootCauseCheck;
        } while (rootCauseCheck != null && loops < 20);
        return rootCause;
    }

    @Override
    public void addChild(Container child) {
        throw CatalinaMessages.MESSAGES.wrapperHasNoChild();
    }

    @Override
    public void addInitParameter(String name, String value) {
        if (!this.parameters.containsKey(name)) {
            this.parameters.put(name, value);
        }
        this.fireContainerEvent("addInitParameter", name);
    }

    @Override
    public void addInstanceListener(InstanceListener listener) {
        this.instanceSupport.addInstanceListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMapping(String mapping) {
        ArrayList arrayList = this.mappings;
        synchronized (arrayList) {
            this.mappings.add(mapping);
        }
        this.fireContainerEvent("addMapping", mapping);
    }

    @Override
    public void addSecurityReference(String name, String link) {
        this.references.put(name, link);
        this.fireContainerEvent("addSecurityReference", name);
    }

    @Override
    public Servlet getServlet() {
        return this.servletInstance != null ? this.servletInstance : this.instance;
    }

    @Override
    public void setServlet(Servlet servlet) {
        this.servletInstance = servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Servlet allocate() throws ServletException {
        Object object;
        if (this.unloading) {
            throw new ServletException(CatalinaMessages.MESSAGES.cannotAllocateServletWhileUnloading(this.getName()));
        }
        if (this.instance == null) {
            object = this;
            synchronized (object) {
                if (this.instance == null) {
                    try {
                        this.instance = this.loadServlet();
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new ServletException(CatalinaMessages.MESSAGES.cannotAllocateServletInstance(), e);
                    }
                }
            }
        }
        if (!this.singleThreadModel) {
            return this.instance;
        }
        object = this.instancePool;
        synchronized (object) {
            while (this.countAllocated >= this.nInstances) {
                if (this.nInstances < this.maxInstances) {
                    try {
                        this.instancePool.push(this.loadServlet());
                        ++this.nInstances;
                        continue;
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new ServletException(CatalinaMessages.MESSAGES.cannotAllocateServletInstance(), e);
                    }
                }
                try {
                    this.instancePool.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.countAllocated;
            return (Servlet)this.instancePool.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deallocate(Servlet servlet) throws ServletException {
        if (!this.singleThreadModel) {
            return;
        }
        Stack stack = this.instancePool;
        synchronized (stack) {
            --this.countAllocated;
            this.instancePool.push(servlet);
            this.instancePool.notify();
        }
    }

    @Override
    public String findInitParameter(String name) {
        return (String)this.parameters.get(name);
    }

    @Override
    public String[] findInitParameters() {
        String[] results = new String[this.parameters.size()];
        return this.parameters.keySet().toArray(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findMappings() {
        ArrayList arrayList = this.mappings;
        synchronized (arrayList) {
            return this.mappings.toArray(new String[this.mappings.size()]);
        }
    }

    @Override
    public String findSecurityReference(String name) {
        return (String)this.references.get(name);
    }

    @Override
    public String[] findSecurityReferences() {
        String[] results = new String[this.references.size()];
        return this.references.keySet().toArray(results);
    }

    public Wrapper findMappingObject() {
        return (Wrapper)this.getMappingObject();
    }

    @Override
    public synchronized void load() throws ServletException {
        this.instance = this.loadServlet();
    }

    public synchronized Servlet loadServlet() throws ServletException {
        Servlet servlet;
        Wrapper jspWrapper;
        if (!this.singleThreadModel && this.instance != null) {
            return this.instance;
        }
        Throwable throwable = null;
        long t1 = System.currentTimeMillis();
        String actualClass = this.servletClass;
        if (actualClass == null && this.jspFile != null && (jspWrapper = (Wrapper)((Context)this.getParent()).findChild("jsp")) != null) {
            actualClass = jspWrapper.getServletClass();
            String[] paramNames = jspWrapper.findInitParameters();
            for (int i = 0; i < paramNames.length; ++i) {
                if (this.parameters.get(paramNames[i]) != null) continue;
                this.parameters.put(paramNames[i], jspWrapper.findInitParameter(paramNames[i]));
            }
        }
        if (actualClass == null) {
            this.unavailable(null);
            throw new ServletException(CatalinaMessages.MESSAGES.noClassSpecifiedForServlet(this.getName()));
        }
        if (this.servletInstance == null) {
            InstanceManager instanceManager = ((Context)this.getParent()).getInstanceManager();
            try {
                servlet = (Servlet)instanceManager.newInstance(actualClass);
            }
            catch (ClassCastException e) {
                this.unavailable(null);
                throw new ServletException(CatalinaMessages.MESSAGES.specifiedClassIsNotServlet(actualClass), (Throwable)e);
            }
            catch (Throwable e) {
                this.unavailable(null);
                CatalinaLogger.CORE_LOGGER.errorInstantiatingServletClass(actualClass, e);
                throw new ServletException(CatalinaMessages.MESSAGES.errorInstantiatingServletClass(actualClass), e);
            }
        } else {
            servlet = this.servletInstance;
            this.servletInstance = null;
        }
        if (servlet instanceof ContainerServlet && (this.isContainerProvidedServlet(actualClass) || ((Context)this.getParent()).getPrivileged())) {
            ((ContainerServlet)servlet).setWrapper(this);
        }
        this.classLoadTime = (int)(System.currentTimeMillis() - t1);
        try {
            this.instanceSupport.fireInstanceEvent("beforeInit", servlet);
            if (Globals.IS_SECURITY_ENABLED) {
                Object[] args = new Object[]{this.facade};
                SecurityUtil.doAsPrivilege("init", servlet, classType, args);
                args = null;
            } else {
                servlet.init((ServletConfig)this.facade);
            }
            if (this.loadOnStartup >= 0 && this.jspFile != null) {
                DummyRequest req = new DummyRequest();
                req.setServletPath(this.jspFile);
                req.setQueryString("jsp_precompile=true");
                DummyResponse res = new DummyResponse();
                if (Globals.IS_SECURITY_ENABLED) {
                    Object[] args = new Object[]{req, res};
                    SecurityUtil.doAsPrivilege("service", servlet, classTypeUsedInService, args);
                    args = null;
                } else {
                    servlet.service((ServletRequest)req, (ServletResponse)res);
                }
            }
        }
        catch (UnavailableException f) {
            throwable = f;
            this.unavailable(f);
            throw f;
        }
        catch (ServletException f) {
            throwable = f;
            throw f;
        }
        catch (Throwable f) {
            throwable = f;
            throw new ServletException(CatalinaMessages.MESSAGES.errorInitializingServlet(this.getName()), f);
        }
        finally {
            this.instanceSupport.fireInstanceEvent("afterInit", servlet, throwable);
        }
        this.singleThreadModel = servlet instanceof SingleThreadModel;
        if (this.singleThreadModel && this.instancePool == null) {
            this.instancePool = new Stack();
        }
        this.fireContainerEvent("load", this);
        this.loadTime = System.currentTimeMillis() - t1;
        return servlet;
    }

    @Override
    public void removeInitParameter(String name) {
        this.parameters.remove(name);
        this.fireContainerEvent("removeInitParameter", name);
    }

    @Override
    public void removeInstanceListener(InstanceListener listener) {
        this.instanceSupport.removeInstanceListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMapping(String mapping) {
        ArrayList arrayList = this.mappings;
        synchronized (arrayList) {
            this.mappings.remove(mapping);
        }
        this.fireContainerEvent("removeMapping", mapping);
    }

    @Override
    public void removeSecurityReference(String name) {
        this.references.remove(name);
        this.fireContainerEvent("removeSecurityReference", name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardWrapper[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void unavailable(UnavailableException unavailable) {
        this.getServletContext().log(CatalinaMessages.MESSAGES.markingServletUnavailable(this.getName()));
        if (unavailable == null) {
            this.setAvailable(Long.MAX_VALUE);
        } else if (unavailable.isPermanent()) {
            this.setAvailable(Long.MAX_VALUE);
        } else {
            int unavailableSeconds = unavailable.getUnavailableSeconds();
            if (unavailableSeconds <= 0) {
                unavailableSeconds = 60;
            }
            this.setAvailable(System.currentTimeMillis() + (long)unavailableSeconds * 1000L);
        }
    }

    @Override
    public synchronized void unload() throws ServletException {
        if (!this.singleThreadModel && this.instance == null) {
            return;
        }
        this.unloading = true;
        PrintStream out = System.out;
        try {
            this.instanceSupport.fireInstanceEvent("beforeDestroy", this.instance);
            if (Globals.IS_SECURITY_ENABLED) {
                SecurityUtil.doAsPrivilege("destroy", this.instance);
                SecurityUtil.remove(this.instance);
            } else {
                this.instance.destroy();
            }
            this.instanceSupport.fireInstanceEvent("afterDestroy", this.instance);
            ((Context)this.getParent()).getInstanceManager().destroyInstance(this.instance);
        }
        catch (Throwable t) {
            this.instanceSupport.fireInstanceEvent("afterDestroy", this.instance, t);
            this.instance = null;
            this.instancePool = null;
            this.nInstances = 0;
            this.fireContainerEvent("unload", this);
            this.unloading = false;
            throw new ServletException(CatalinaMessages.MESSAGES.errorDestroyingServlet(this.getName()), t);
        }
        this.instance = null;
        if (this.singleThreadModel && this.instancePool != null) {
            try {
                while (!this.instancePool.isEmpty()) {
                    Servlet s = (Servlet)this.instancePool.pop();
                    if (Globals.IS_SECURITY_ENABLED) {
                        SecurityUtil.doAsPrivilege("destroy", s);
                        SecurityUtil.remove(this.instance);
                    } else {
                        s.destroy();
                    }
                    ((Context)this.getParent()).getInstanceManager().destroyInstance(s);
                }
            }
            catch (Throwable t) {
                this.instancePool = null;
                this.nInstances = 0;
                this.unloading = false;
                this.fireContainerEvent("unload", this);
                throw new ServletException(CatalinaMessages.MESSAGES.errorDestroyingServlet(this.getName()), t);
            }
            this.instancePool = null;
            this.nInstances = 0;
        }
        this.singleThreadModel = false;
        this.unloading = false;
        this.fireContainerEvent("unload", this);
    }

    public String getInitParameter(String name) {
        return this.findInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return new Enumerator(this.parameters.keySet());
    }

    public ServletContext getServletContext() {
        if (this.parent == null) {
            return null;
        }
        if (!(this.parent instanceof Context)) {
            return null;
        }
        return ((Context)this.parent).getServletContext();
    }

    public String getServletName() {
        return this.getName();
    }

    public long getProcessingTime() {
        return this.swValve.getProcessingTime();
    }

    public void setProcessingTime(long processingTime) {
        this.swValve.setProcessingTime(processingTime);
    }

    public long getMaxTime() {
        return this.swValve.getMaxTime();
    }

    public void setMaxTime(long maxTime) {
        this.swValve.setMaxTime(maxTime);
    }

    public long getMinTime() {
        return this.swValve.getMinTime();
    }

    public void setMinTime(long minTime) {
        this.swValve.setMinTime(minTime);
    }

    public int getRequestCount() {
        return this.swValve.getRequestCount();
    }

    public void setRequestCount(int requestCount) {
        this.swValve.setRequestCount(requestCount);
    }

    public int getErrorCount() {
        return this.swValve.getErrorCount();
    }

    public void setErrorCount(int errorCount) {
        this.swValve.setErrorCount(errorCount);
    }

    @Override
    public void incrementErrorCount() {
        this.swValve.setErrorCount(this.swValve.getErrorCount() + 1);
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public void setLoadTime(long loadTime) {
        this.loadTime = loadTime;
    }

    public int getClassLoadTime() {
        return this.classLoadTime;
    }

    protected void addDefaultMapper(String mapperClass) {
    }

    protected boolean isContainerProvidedServlet(String classname) {
        if (classname.startsWith("org.apache.catalina.")) {
            return true;
        }
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(classname);
            return ContainerServlet.class.isAssignableFrom(clazz);
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected Method[] getAllDeclaredMethods(Class c) {
        if (c.equals(HttpServlet.class)) {
            return null;
        }
        Method[] parentMethods = this.getAllDeclaredMethods(c.getSuperclass());
        Method[] thisMethods = c.getDeclaredMethods();
        if (thisMethods == null) {
            return parentMethods;
        }
        if (parentMethods != null && parentMethods.length > 0) {
            Method[] allMethods = new Method[parentMethods.length + thisMethods.length];
            System.arraycopy(parentMethods, 0, allMethods, 0, parentMethods.length);
            System.arraycopy(thisMethods, 0, allMethods, parentMethods.length, thisMethods.length);
            thisMethods = allMethods;
        }
        return thisMethods;
    }

    @Override
    public void start() throws LifecycleException {
        Notification notification;
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.starting", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        super.start();
        if (Constants.ENABLE_MODELER && this.oname != null) {
            this.registerJMX((StandardContext)this.getParent());
        }
        this.setAvailable(0L);
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.running", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        Notification notification;
        this.setAvailable(Long.MAX_VALUE);
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.stopping", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        try {
            this.unload();
        }
        catch (ServletException e) {
            this.getServletContext().log(CatalinaMessages.MESSAGES.errorUnloadingServlet(this.getName()), (Throwable)e);
        }
        super.stop();
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.stopped", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        if (Constants.ENABLE_MODELER) {
            if (this.oname != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
                notification = new Notification("j2ee.object.deleted", this.getObjectName(), this.sequenceNumber++);
                this.broadcaster.sendNotification(notification);
            }
            if (this.isJspServlet && this.jspMonitorON != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.jspMonitorON);
            }
        }
    }

    protected void registerJMX(StandardContext ctx) {
        String parentName = ctx.getName();
        parentName = "".equals(parentName) ? "/" : parentName;
        String hostName = ctx.getParent().getName();
        hostName = hostName == null ? "DEFAULT" : hostName;
        String domain = ctx.getDomain();
        String webMod = "//" + hostName + parentName;
        String onameStr = domain + ":j2eeType=Servlet,name=" + this.getName() + ",WebModule=" + webMod + ",J2EEApplication=" + ctx.getJ2EEApplication() + ",J2EEServer=" + ctx.getJ2EEServer();
        try {
            this.controller = this.oname = new ObjectName(onameStr);
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            if (this.getObjectName() != null) {
                Notification notification = new Notification("j2ee.object.created", this.getObjectName(), this.sequenceNumber++);
                this.broadcaster.sendNotification(notification);
            }
        }
        catch (Exception ex) {
            CatalinaLogger.CORE_LOGGER.failedServletJmxRegistration(this, ex);
        }
        if (this.isJspServlet) {
            onameStr = domain + ":type=JspMonitor,name=" + this.getName() + ",WebModule=" + webMod + ",J2EEApplication=" + ctx.getJ2EEApplication() + ",J2EEServer=" + ctx.getJ2EEServer();
            try {
                this.jspMonitorON = new ObjectName(onameStr);
                Registry.getRegistry(null, null).registerComponent((Object)this.instance, this.jspMonitorON, null);
            }
            catch (Exception ex) {
                CatalinaLogger.CORE_LOGGER.failedServletJspMonitorJmxRegistration(this.instance, ex);
            }
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notificationInfo == null) {
            this.notificationInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"j2ee.object.created"}, Notification.class.getName(), "servlet is created"), new MBeanNotificationInfo(new String[]{"j2ee.state.starting"}, Notification.class.getName(), "servlet is starting"), new MBeanNotificationInfo(new String[]{"j2ee.state.running"}, Notification.class.getName(), "servlet is running"), new MBeanNotificationInfo(new String[]{"j2ee.state.stopped"}, Notification.class.getName(), "servlet start to stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.stopped"}, Notification.class.getName(), "servlet is stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.deleted"}, Notification.class.getName(), "servlet is deleted")};
        }
        return this.notificationInfo;
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, object);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    public boolean isEventProvider() {
        return false;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }
}

