/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.jboss.web.WebsocketsMessages;

public class AsyncChannelGroupUtil {
    private static AsynchronousChannelGroup group = null;
    private static int usageCount = 0;
    private static final Object lock = new Object();

    private AsyncChannelGroupUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsynchronousChannelGroup register() {
        Object object = lock;
        synchronized (object) {
            if (usageCount == 0) {
                group = AsyncChannelGroupUtil.createAsynchronousChannelGroup();
            }
            ++usageCount;
            return group;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister() {
        Object object = lock;
        synchronized (object) {
            if (--usageCount == 0) {
                group.shutdown();
                group = null;
            }
        }
    }

    private static AsynchronousChannelGroup createAsynchronousChannelGroup() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(AsyncIOThreadFactory.class.getClassLoader());
            int initialSize = Runtime.getRuntime().availableProcessors();
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new AsyncIOThreadFactory());
            try {
                AsynchronousChannelGroup asynchronousChannelGroup = AsynchronousChannelGroup.withCachedThreadPool(executorService, initialSize);
                return asynchronousChannelGroup;
            }
            catch (IOException e) {
                throw WebsocketsMessages.MESSAGES.asyncGroupFail();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private static class AsyncIOThreadFactory
    implements ThreadFactory {
        private AtomicInteger count = new AtomicInteger(0);

        private AsyncIOThreadFactory() {
        }

        @Override
        public Thread newThread(final Runnable r) {
            return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    Thread t = new Thread(r);
                    t.setName("WebSocketClient-AsyncIO-" + AsyncIOThreadFactory.this.count.incrementAndGet());
                    t.setContextClassLoader(this.getClass().getClassLoader());
                    t.setDaemon(true);
                    return t;
                }
            });
        }
    }
}

