/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.web;

import java.io.IOException;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.authentication.web.HTTPAuthenticationScheme;
import org.picketlink.common.util.Base64;
import org.picketlink.common.util.StringUtil;
import org.picketlink.credential.DefaultLoginCredentials;

public class BasicAuthenticationScheme
implements HTTPAuthenticationScheme {
    public static final String REALM_NAME_INIT_PARAM = "realmName";
    public static final String DEFAULT_REALM_NAME = "PicketLink Default Realm";
    private String realm = "PicketLink Default Realm";

    public BasicAuthenticationScheme(FilterConfig config) {
        String providedRealm = config.getInitParameter(REALM_NAME_INIT_PARAM);
        if (providedRealm != null) {
            this.realm = providedRealm;
        }
    }

    @Override
    public void extractCredential(HttpServletRequest request, DefaultLoginCredentials creds) {
        if (this.isBasicAuthentication(request)) {
            String[] usernameAndPassword = this.extractUsernameAndPassword(request);
            String username = usernameAndPassword[0];
            String password = usernameAndPassword[1];
            if (!StringUtil.isNullOrEmpty((String)username) || !StringUtil.isNullOrEmpty((String)password)) {
                creds.setUserId(username);
                creds.setPassword(password);
            }
        }
    }

    @Override
    public void challengeClient(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
        response.sendError(401);
    }

    @Override
    public boolean postAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return true;
    }

    private boolean isBasicAuthentication(HttpServletRequest request) {
        return this.getAuthorizationHeader(request) != null && this.getAuthorizationHeader(request).startsWith("Basic ");
    }

    private String getAuthorizationHeader(HttpServletRequest request) {
        return request.getHeader("Authorization");
    }

    public String[] extractUsernameAndPassword(HttpServletRequest request) {
        String authorizationHeader = this.getAuthorizationHeader(request);
        String base64Token = authorizationHeader.substring(6);
        String token = new String(Base64.decode((String)base64Token));
        String username = "";
        String password = "";
        int delim = token.indexOf(":");
        if (delim != -1) {
            username = token.substring(0, delim);
            password = token.substring(delim + 1);
        }
        return new String[]{username, password};
    }
}

