/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.FixedBitSet;

public class MultiTermQueryWrapperFilter<Q extends MultiTermQuery>
extends Filter {
    protected final Q query;

    protected MultiTermQueryWrapperFilter(Q query) {
        this.query = query;
    }

    public String toString() {
        return ((Query)this.query).toString();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass().equals(o.getClass())) {
            return ((MultiTermQuery)this.query).equals(((MultiTermQueryWrapperFilter)o).query);
        }
        return false;
    }

    public final int hashCode() {
        return ((MultiTermQuery)this.query).hashCode();
    }

    @Deprecated
    public int getTotalNumberOfTerms() {
        return ((MultiTermQuery)this.query).getTotalNumberOfTerms();
    }

    @Deprecated
    public void clearTotalNumberOfTerms() {
        ((MultiTermQuery)this.query).clearTotalNumberOfTerms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        FilteredTermEnum enumerator = ((MultiTermQuery)this.query).getEnum(reader);
        try {
            if (((TermEnum)enumerator).term() == null) {
                DocIdSet docIdSet = DocIdSet.EMPTY_DOCIDSET;
                return docIdSet;
            }
            FixedBitSet bitSet = new FixedBitSet(reader.maxDoc());
            int[] docs = new int[32];
            int[] freqs = new int[32];
            TermDocs termDocs = reader.termDocs();
            try {
                Term term;
                int termCount = 0;
                while ((term = ((TermEnum)enumerator).term()) != null) {
                    int count;
                    ++termCount;
                    termDocs.seek(term);
                    while ((count = termDocs.read(docs, freqs)) != 0) {
                        for (int i = 0; i < count; ++i) {
                            bitSet.set(docs[i]);
                        }
                    }
                    if (((TermEnum)enumerator).next()) continue;
                }
                ((MultiTermQuery)this.query).incTotalNumberOfTerms(termCount);
            }
            finally {
                termDocs.close();
            }
            FixedBitSet fixedBitSet = bitSet;
            return fixedBitSet;
        }
        finally {
            ((TermEnum)enumerator).close();
        }
    }
}

