/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.FieldCacheSource;

public class ByteFieldSource
extends FieldCacheSource {
    private FieldCache.ByteParser parser;

    public ByteFieldSource(String field) {
        this(field, null);
    }

    public ByteFieldSource(String field, FieldCache.ByteParser parser) {
        super(field);
        this.parser = parser;
    }

    @Override
    public String description() {
        return "byte(" + super.description() + ')';
    }

    @Override
    public DocValues getCachedFieldValues(FieldCache cache, String field, IndexReader reader) throws IOException {
        final byte[] arr = cache.getBytes(reader, field, this.parser);
        return new DocValues(){

            @Override
            public float floatVal(int doc) {
                return arr[doc];
            }

            @Override
            public int intVal(int doc) {
                return arr[doc];
            }

            @Override
            public String toString(int doc) {
                return ByteFieldSource.this.description() + '=' + this.intVal(doc);
            }

            @Override
            Object getInnerArray() {
                return arr;
            }
        };
    }

    @Override
    public boolean cachedFieldSourceEquals(FieldCacheSource o) {
        if (o.getClass() != ByteFieldSource.class) {
            return false;
        }
        ByteFieldSource other = (ByteFieldSource)o;
        return this.parser == null ? other.parser == null : this.parser.getClass() == other.parser.getClass();
    }

    @Override
    public int cachedFieldSourceHashCode() {
        return this.parser == null ? Byte.class.hashCode() : this.parser.getClass().hashCode();
    }
}

