/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

class ComponentInstantiatorInterceptor
implements Interceptor {
    private final ManagedReferenceFactory componentFactory;
    private final Object contextKey;
    private final boolean setTarget;

    public ComponentInstantiatorInterceptor(ManagedReferenceFactory componentFactory, Object contextKey, boolean setTarget) {
        this.setTarget = setTarget;
        if (componentFactory == null) {
            throw EeMessages.MESSAGES.nullVar("componentFactory");
        }
        if (contextKey == null) {
            throw EeMessages.MESSAGES.nullVar("contextKey");
        }
        this.componentFactory = componentFactory;
        this.contextKey = contextKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        ComponentInstance componentInstance = (ComponentInstance)context.getPrivateData(ComponentInstance.class);
        ManagedReference existing = (ManagedReference)componentInstance.getInstanceData(this.contextKey);
        if (existing == null) {
            ManagedReference reference = this.componentFactory.getReference();
            boolean ok = false;
            try {
                componentInstance.setInstanceData(this.contextKey, reference);
                if (this.setTarget) {
                    context.setTarget(reference.getInstance());
                }
                Object result = context.proceed();
                ok = true;
                Object object = result;
                return object;
            }
            finally {
                if (!ok) {
                    reference.release();
                    componentInstance.setInstanceData(this.contextKey, reference);
                }
            }
        }
        return context.proceed();
    }
}

